/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.mixin.common;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1706;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_4861;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.betterx.bclib.blocks.BaseAnvilBlock;
import org.betterx.bclib.blocks.LeveledAnvilBlock;
import org.betterx.bclib.interfaces.AnvilScreenHandlerExtended;
import org.betterx.bclib.recipes.AnvilRecipe;
import org.betterx.bclib.recipes.AnvilRecipeInput;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1706.class})
public abstract class AnvilMenuMixin
extends class_4861
implements AnvilScreenHandlerExtended {
    @Unique
    private List<class_8786<AnvilRecipe>> bcl_recipes = Collections.emptyList();
    @Unique
    private class_8786<AnvilRecipe> bcl_currentRecipe;
    @Unique
    private class_3915 bcl_anvilLevel;

    public AnvilMenuMixin(@Nullable class_3917<?> menuType, int i, class_1661 inventory, class_3914 containerLevelAccess) {
        super(menuType, i, inventory, containerLevelAccess);
    }

    @Unique
    private AnvilRecipeInput bcl_AnvilRecipeInput(class_6862<class_1792> allowedTools) {
        return new AnvilRecipeInput(this.field_22480.method_5438(0), this.field_22480.method_5438(1), allowedTools);
    }

    @Inject(method={"<init>(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/inventory/ContainerLevelAccess;)V"}, at={@At(value="TAIL")})
    public void be_initAnvilLevel(int syncId, class_1661 inventory, class_3914 context, CallbackInfo info) {
        this.bcl_anvilLevel = this.method_17362(class_3915.method_17403());
        if (context != class_3914.field_17304) {
            int level = (Integer)context.method_17396((world, blockPos) -> {
                class_2248 anvilBlock = world.method_8320(blockPos).method_26204();
                return LeveledAnvilBlock.getAnvilCraftingLevel(anvilBlock);
            }, (Object)0);
            this.bcl_anvilLevel.method_17404(level);
        } else {
            this.bcl_anvilLevel.method_17404(0);
        }
    }

    @Shadow
    public abstract void method_24928();

    @Inject(method={"mayPickup"}, at={@At(value="HEAD")}, cancellable=true)
    protected void bcl_canTakeOutput(class_1657 player, boolean present, CallbackInfoReturnable<Boolean> info) {
        if (this.bcl_currentRecipe != null) {
            AnvilRecipeInput recipeInput = this.bcl_AnvilRecipeInput(((AnvilRecipe)this.bcl_currentRecipe.comp_1933()).getAllowedTools());
            info.setReturnValue((Object)((AnvilRecipe)this.bcl_currentRecipe.comp_1933()).checkHammerDurability(recipeInput, player));
        }
    }

    @Inject(method={"method_24922"}, at={@At(value="HEAD")}, cancellable=true)
    private static void bcl_onDamageAnvil(class_1657 player, class_1937 level, class_2338 blockPos, CallbackInfo ci) {
        class_2248 class_22482;
        class_2680 blockState = level.method_8320(blockPos);
        if (!player.method_31549().field_7477 && (class_22482 = blockState.method_26204()) instanceof BaseAnvilBlock) {
            BaseAnvilBlock anvil = (BaseAnvilBlock)class_22482;
            if (player.method_59922().method_43058() < 0.12) {
                class_2680 damaged = anvil.damageAnvilUse(blockState, player.method_59922());
                BaseAnvilBlock.destroyWhenNull(level, blockPos, damaged);
                ci.cancel();
            }
        }
    }

    @Inject(method={"onTake"}, at={@At(value="HEAD")}, cancellable=true)
    protected void bcl_onTakeAnvilOutput(class_1657 player, class_1799 stack, CallbackInfo info) {
        if (this.bcl_currentRecipe != null) {
            AnvilRecipeInput recipeInput = this.bcl_AnvilRecipeInput(((AnvilRecipe)this.bcl_currentRecipe.comp_1933()).getAllowedTools());
            recipeInput.getIngredient().method_7934(((AnvilRecipe)this.bcl_currentRecipe.comp_1933()).getInputCount());
            stack = ((AnvilRecipe)this.bcl_currentRecipe.comp_1933()).craft(recipeInput, player);
            this.method_7609(this.field_22480);
            this.field_22481.method_17393((level, blockPos) -> {
                class_2680 anvilState = level.method_8320(blockPos);
                class_2248 anvilBlock = anvilState.method_26204();
                if (anvilBlock instanceof BaseAnvilBlock) {
                    BaseAnvilBlock anvil = (BaseAnvilBlock)anvilBlock;
                    if (!player.method_31549().field_7477 && anvilState.method_26164(class_3481.field_15486) && player.method_59922().method_43058() < 0.1) {
                        class_2680 damagedState = anvil.damageAnvilUse(anvilState, player.method_59922());
                        BaseAnvilBlock.destroyWhenNull(level, blockPos, damagedState);
                    } else {
                        level.method_20290(1030, blockPos, 0);
                    }
                }
            });
            info.cancel();
        }
    }

    @Inject(method={"createResult"}, at={@At(value="HEAD")}, cancellable=true)
    public void bcl_updateOutput(CallbackInfo info) {
        AnvilRecipeInput recipeInput = this.bcl_AnvilRecipeInput(null);
        class_1863 recipeManager = this.field_22482.method_37908().method_8433();
        this.bcl_recipes = recipeManager.method_17877(AnvilRecipe.TYPE, (class_9695)recipeInput, this.field_22482.method_37908());
        if (!this.bcl_recipes.isEmpty()) {
            int anvilLevel = this.bcl_anvilLevel.method_17407();
            this.bcl_recipes = this.bcl_recipes.stream().filter(recipe -> anvilLevel >= ((AnvilRecipe)recipe.comp_1933()).getAnvilLevel()).collect(Collectors.toList());
            if (!this.bcl_recipes.isEmpty()) {
                if (this.bcl_currentRecipe == null || !this.bcl_recipes.contains(this.bcl_currentRecipe)) {
                    this.bcl_currentRecipe = this.bcl_recipes.get(0);
                }
                this.bcl_updateResult();
                info.cancel();
            } else {
                this.bcl_currentRecipe = null;
            }
        }
    }

    @Inject(method={"setItemName"}, at={@At(value="HEAD")}, cancellable=true)
    public void bcl_setNewItemName(String string, CallbackInfoReturnable<Boolean> cir) {
        if (this.bcl_currentRecipe != null) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    public boolean method_7604(class_1657 player, int id) {
        if (id == 0) {
            this.be_previousRecipe();
            return true;
        }
        if (id == 1) {
            this.be_nextRecipe();
            return true;
        }
        return super.method_7604(player, id);
    }

    @Unique
    private void bcl_updateResult() {
        if (this.bcl_currentRecipe == null) {
            return;
        }
        AnvilRecipeInput recipeInput = this.bcl_AnvilRecipeInput(((AnvilRecipe)this.bcl_currentRecipe.comp_1933()).getAllowedTools());
        this.field_22479.method_5447(0, ((AnvilRecipe)this.bcl_currentRecipe.comp_1933()).assemble(recipeInput, (class_7225.class_7874)this.field_22482.method_37908().method_30349()));
        this.method_7623();
    }

    @Override
    public void bcl_updateCurrentRecipe(class_8786<AnvilRecipe> recipe) {
        this.bcl_currentRecipe = recipe;
        this.bcl_updateResult();
    }

    @Override
    public class_8786<AnvilRecipe> bcl_getCurrentRecipe() {
        return this.bcl_currentRecipe;
    }

    @Override
    public List<class_8786<AnvilRecipe>> bcl_getRecipes() {
        return this.bcl_recipes;
    }
}

