/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.commands;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_5742;
import net.minecraft.class_6544;
import net.minecraft.class_7138;
import org.betterx.bclib.BCLib;
import org.betterx.wover.state.api.WorldState;

public class DumpMap {
    public static LiteralArgumentBuilder<class_2168> register(LiteralArgumentBuilder<class_2168> bnContext) {
        return (LiteralArgumentBuilder)bnContext.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"dump_maps").requires(source -> source.method_9259(4))).then(class_2170.method_9247((String)"png").executes(DumpMap::dumpImageMaps))).then(class_2170.method_9247((String)"json").executes(DumpMap::dumpJsonMaps)));
    }

    static int dumpJsonMaps(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        class_3218 serverLevel = source.method_9225();
        class_243 pos = source.method_9222();
        Path basePath = WorldState.storageAccess().method_27010(class_5218.field_24188).resolve(BCLib.C.namespace).resolve("export").resolve(serverLevel.method_27983().method_29177().method_12832()).normalize();
        class_7138 randomState = serverLevel.method_14178().method_41248();
        class_6544.class_6552 sampler = randomState.method_42371();
        int x = class_5742.method_33100((int)((int)pos.field_1352));
        int z = class_5742.method_33100((int)((int)pos.field_1350));
        int minHeight = class_5742.method_33100((int)serverLevel.method_31607());
        int maxHeight = class_5742.method_33100((int)serverLevel.method_31600());
        int maxOffset = 128;
        class_5250 result = class_2561.method_43470((String)("Wrote maps to " + basePath.toString() + ":\n")).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_10977(class_124.field_1078));
        JsonObject root = new JsonObject();
        JsonObject header = new JsonObject();
        JsonObject center = new JsonObject();
        center.addProperty("x", (Number)((int)pos.field_1352));
        center.addProperty("y", (Number)((int)pos.field_1351));
        center.addProperty("z", (Number)((int)pos.field_1350));
        JsonObject start = new JsonObject();
        start.addProperty("x", (Number)(x - maxOffset));
        start.addProperty("y", (Number)minHeight);
        start.addProperty("z", (Number)(z - maxOffset));
        JsonObject dimensions = new JsonObject();
        dimensions.addProperty("x", (Number)(2 * maxOffset + 1));
        dimensions.addProperty("y", (Number)(maxHeight - minHeight));
        dimensions.addProperty("z", (Number)(2 * maxOffset + 1));
        header.add("center", (JsonElement)center);
        header.add("start", (JsonElement)start);
        header.add("size", (JsonElement)dimensions);
        header.addProperty("dimension", serverLevel.method_27983().method_29177().toString());
        root.add("info", (JsonElement)header);
        long minTemperature = Long.MAX_VALUE;
        long minHumidity = Long.MAX_VALUE;
        long minContinentalness = Long.MAX_VALUE;
        long minErosion = Long.MAX_VALUE;
        long minDepth = Long.MAX_VALUE;
        long minWeirdness = Long.MAX_VALUE;
        long maxTemperature = Long.MIN_VALUE;
        long maxHumidity = Long.MIN_VALUE;
        long maxContinentalness = Long.MIN_VALUE;
        long maxErosion = Long.MIN_VALUE;
        long maxDepth = Long.MIN_VALUE;
        long maxWeirdness = Long.MIN_VALUE;
        JsonArray samplesX = new JsonArray();
        for (int ox = -maxOffset; ox <= maxOffset; ++ox) {
            JsonArray samplesZ = new JsonArray();
            for (int oz = -maxOffset; oz <= maxOffset; ++oz) {
                JsonArray samplesY = new JsonArray();
                for (int y = minHeight; y <= maxHeight; ++y) {
                    JsonArray samples = new JsonArray();
                    class_6544.class_6553 t = sampler.method_40444(x + ox, y, z + oz);
                    samples.add((Number)t.comp_112());
                    samples.add((Number)t.comp_113());
                    samples.add((Number)t.comp_114());
                    samples.add((Number)t.comp_115());
                    samples.add((Number)t.comp_116());
                    samples.add((Number)t.comp_117());
                    samplesY.add((JsonElement)samples);
                    if (t.comp_112() < minTemperature) {
                        minTemperature = t.comp_112();
                    }
                    if (t.comp_113() < minHumidity) {
                        minHumidity = t.comp_113();
                    }
                    if (t.comp_114() < minContinentalness) {
                        minContinentalness = t.comp_114();
                    }
                    if (t.comp_115() < minErosion) {
                        minErosion = t.comp_115();
                    }
                    if (t.comp_116() < minDepth) {
                        minDepth = t.comp_116();
                    }
                    if (t.comp_117() < minWeirdness) {
                        minWeirdness = t.comp_117();
                    }
                    if (t.comp_112() > maxTemperature) {
                        maxTemperature = t.comp_112();
                    }
                    if (t.comp_113() > maxHumidity) {
                        maxHumidity = t.comp_113();
                    }
                    if (t.comp_114() > maxContinentalness) {
                        maxContinentalness = t.comp_114();
                    }
                    if (t.comp_115() > maxErosion) {
                        maxErosion = t.comp_115();
                    }
                    if (t.comp_116() > maxDepth) {
                        maxDepth = t.comp_116();
                    }
                    if (t.comp_117() <= maxWeirdness) continue;
                    maxWeirdness = t.comp_117();
                }
                samplesZ.add((JsonElement)samplesY);
            }
            samplesX.add((JsonElement)samplesZ);
        }
        JsonObject extrema = new JsonObject();
        DumpMap.setExtrema("temperature", minTemperature, maxTemperature, extrema);
        DumpMap.setExtrema("humidity", minHumidity, maxHumidity, extrema);
        DumpMap.setExtrema("continentalness", minContinentalness, maxContinentalness, extrema);
        DumpMap.setExtrema("erosion", minErosion, maxErosion, extrema);
        DumpMap.setExtrema("depth", minDepth, maxDepth, extrema);
        DumpMap.setExtrema("weirdness", minWeirdness, maxWeirdness, extrema);
        header.add("extrema", (JsonElement)extrema);
        root.add("samples", (JsonElement)samplesX);
        File fJson = new File(basePath.toString() + "/samples.json");
        try {
            Gson gson = new Gson();
            String s = gson.toJson((JsonElement)root);
            Files.writeString(fJson.toPath(), (CharSequence)s, new OpenOption[0]);
        }
        catch (Exception e) {
            BCLib.C.LOG.error("Error while saving json: " + e.getMessage());
            result.method_10852((class_2561)class_2561.method_43470((String)("Error while saving json: " + fJson.toString())));
        }
        ((class_2168)ctx.getSource()).method_9226(() -> result, false);
        return 1;
    }

    private static void setExtrema(String property, long minTemperature, long maxTemperature, JsonObject root) {
        JsonObject jTemperature = new JsonObject();
        jTemperature.addProperty("min", (Number)minTemperature);
        jTemperature.addProperty("max", (Number)maxTemperature);
        root.add(property, (JsonElement)jTemperature);
    }

    static int dumpImageMaps(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        class_3218 serverLevel = source.method_9225();
        class_243 pos = source.method_9222();
        Path basePath = WorldState.storageAccess().method_27010(class_5218.field_24188).resolve(BCLib.C.namespace).resolve("export").resolve(serverLevel.method_27983().method_29177().method_12832()).normalize();
        class_7138 randomState = serverLevel.method_14178().method_41248();
        class_6544.class_6552 sampler = randomState.method_42371();
        int x = class_5742.method_33100((int)((int)pos.field_1352));
        int y = class_5742.method_33100((int)((int)pos.field_1351));
        int z = class_5742.method_33100((int)((int)pos.field_1350));
        int maxOffset = 128;
        class_5250 result = class_2561.method_43470((String)("Wrote maps to " + basePath.toString() + ":\n")).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_10977(class_124.field_1078));
        long minTemperature = Long.MAX_VALUE;
        long minHumidity = Long.MAX_VALUE;
        long minContinentalness = Long.MAX_VALUE;
        long minErosion = Long.MAX_VALUE;
        long minDepth = Long.MAX_VALUE;
        long minWeirdness = Long.MAX_VALUE;
        long maxTemperature = Long.MIN_VALUE;
        long maxHumidity = Long.MIN_VALUE;
        long maxContinentalness = Long.MIN_VALUE;
        long maxErosion = Long.MIN_VALUE;
        long maxDepth = Long.MIN_VALUE;
        long maxWeirdness = Long.MIN_VALUE;
        for (int ox = -maxOffset; ox <= maxOffset; ++ox) {
            for (int oz = -maxOffset; oz <= maxOffset; ++oz) {
                class_6544.class_6553 t = sampler.method_40444(x + ox, y, z + oz);
                if (t.comp_112() < minTemperature) {
                    minTemperature = t.comp_112();
                }
                if (t.comp_113() < minHumidity) {
                    minHumidity = t.comp_113();
                }
                if (t.comp_114() < minContinentalness) {
                    minContinentalness = t.comp_114();
                }
                if (t.comp_115() < minErosion) {
                    minErosion = t.comp_115();
                }
                if (t.comp_116() < minDepth) {
                    minDepth = t.comp_116();
                }
                if (t.comp_117() < minWeirdness) {
                    minWeirdness = t.comp_117();
                }
                if (t.comp_112() > maxTemperature) {
                    maxTemperature = t.comp_112();
                }
                if (t.comp_113() > maxHumidity) {
                    maxHumidity = t.comp_113();
                }
                if (t.comp_114() > maxContinentalness) {
                    maxContinentalness = t.comp_114();
                }
                if (t.comp_115() > maxErosion) {
                    maxErosion = t.comp_115();
                }
                if (t.comp_116() > maxDepth) {
                    maxDepth = t.comp_116();
                }
                if (t.comp_117() <= maxWeirdness) continue;
                maxWeirdness = t.comp_117();
            }
        }
        if (minTemperature == maxTemperature) {
            ++maxTemperature;
        }
        if (minHumidity == maxHumidity) {
            ++maxHumidity;
        }
        if (minContinentalness == maxContinentalness) {
            ++maxContinentalness;
        }
        if (minErosion == maxErosion) {
            ++maxErosion;
        }
        if (minDepth == maxDepth) {
            ++maxDepth;
        }
        if (minWeirdness == maxWeirdness) {
            ++maxWeirdness;
        }
        BufferedImage iTemperature = new BufferedImage(2 * maxOffset + 1, 2 * maxOffset + 1, 10);
        BufferedImage iHumidity = new BufferedImage(2 * maxOffset + 1, 2 * maxOffset + 1, 10);
        BufferedImage iContinentalness = new BufferedImage(2 * maxOffset + 1, 2 * maxOffset + 1, 10);
        BufferedImage iErosion = new BufferedImage(2 * maxOffset + 1, 2 * maxOffset + 1, 10);
        BufferedImage iDepth = new BufferedImage(2 * maxOffset + 1, 2 * maxOffset + 1, 10);
        BufferedImage iWeirdness = new BufferedImage(2 * maxOffset + 1, 2 * maxOffset + 1, 10);
        for (int ox = -maxOffset; ox <= maxOffset; ++ox) {
            for (int oz = -maxOffset; oz <= maxOffset; ++oz) {
                class_6544.class_6553 t = sampler.method_40444(x + ox, y, z + oz);
                int temperature = (int)((t.comp_112() - minTemperature) * 255L / (maxTemperature - minTemperature));
                int humidity = (int)((t.comp_113() - minHumidity) * 255L / (maxHumidity - minHumidity));
                int continentalness = (int)((t.comp_114() - minContinentalness) * 255L / (maxContinentalness - minContinentalness));
                int erosion = (int)((t.comp_115() - minErosion) * 255L / (maxErosion - minErosion));
                int depth = (int)((t.comp_116() - minDepth) * 255L / (maxDepth - minDepth));
                int weirdness = (int)((t.comp_117() - minWeirdness) * 255L / (maxWeirdness - minWeirdness));
                iTemperature.setRGB(ox + maxOffset, oz + maxOffset, new Color(temperature, temperature, temperature).getRGB());
                iHumidity.setRGB(ox + maxOffset, oz + maxOffset, new Color(humidity, humidity, humidity).getRGB());
                iContinentalness.setRGB(ox + maxOffset, oz + maxOffset, new Color(continentalness, continentalness, continentalness).getRGB());
                iErosion.setRGB(ox + maxOffset, oz + maxOffset, new Color(erosion, erosion, erosion).getRGB());
                iDepth.setRGB(ox + maxOffset, oz + maxOffset, new Color(depth, depth, depth).getRGB());
                iWeirdness.setRGB(ox + maxOffset, oz + maxOffset, new Color(weirdness, weirdness, weirdness).getRGB());
            }
        }
        File fBasePath = basePath.toFile();
        if (!fBasePath.exists() && !fBasePath.mkdirs()) {
            BCLib.C.LOG.error("Error while creating directory: " + fBasePath.toString());
            result.method_10852((class_2561)class_2561.method_43470((String)("Error while creating directory: " + fBasePath.toString())));
            return 1;
        }
        DumpMap.write(iTemperature, new File(basePath.toString() + "/temperature_" + minTemperature + "_" + maxTemperature + ".png"), result);
        DumpMap.write(iHumidity, new File(basePath.toString() + "/humidity_" + minHumidity + "_" + maxHumidity + ".png"), result);
        DumpMap.write(iContinentalness, new File(basePath.toString() + "/continentalness_" + minContinentalness + "_" + maxContinentalness + ".png"), result);
        DumpMap.write(iErosion, new File(basePath.toString() + "/erosion_" + minErosion + "_" + maxErosion + ".png"), result);
        DumpMap.write(iDepth, new File(basePath.toString() + "/depth_" + minDepth + "_" + maxDepth + ".png"), result);
        DumpMap.write(iWeirdness, new File(basePath.toString() + "/weirdness_" + minWeirdness + "_" + maxWeirdness + ".png"), result);
        ((class_2168)ctx.getSource()).method_9226(() -> result, false);
        return 1;
    }

    private static void write(BufferedImage iTemperature, File fTemperature, class_5250 result) {
        try {
            ImageIO.write((RenderedImage)iTemperature, "png", fTemperature);
        }
        catch (IOException e) {
            BCLib.C.LOG.error("Error while saving image: " + e.getMessage());
            result.method_10852((class_2561)class_2561.method_43470((String)("Error while saving image: " + fTemperature.toString())));
        }
    }
}

