/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.dataexchange;

import java.util.Collection;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_634;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.dataexchange.BaseDataHandler;

public abstract class DataHandler<T extends class_8710>
extends BaseDataHandler<T> {
    protected DataHandler(class_2960 identifier, boolean originatesOnServer) {
        super(identifier, originatesOnServer);
    }

    protected boolean prepareData(boolean isClient) {
        return true;
    }

    protected abstract T serializeData(boolean var1);

    protected abstract void deserializeIncomingData(T var1, PacketSender var2, boolean var3);

    protected abstract void runOnGameThread(class_310 var1, MinecraftServer var2, boolean var3);

    @Override
    @Environment(value=EnvType.CLIENT)
    void receiveFromServer(class_310 client, class_634 handler, T payload, PacketSender responseSender) {
        this.deserializeIncomingData(payload, responseSender, true);
        Runnable runner = () -> this.runOnGameThread(client, null, true);
        if (this.isBlocking()) {
            client.method_19537(runner);
        } else {
            client.execute(runner);
        }
    }

    @Override
    void receiveFromClient(MinecraftServer server, class_3222 player, class_3244 handler, T payload, PacketSender responseSender) {
        super.receiveFromClient(server, player, handler, payload, responseSender);
        this.deserializeIncomingData(payload, responseSender, false);
        Runnable runner = () -> this.runOnGameThread(null, server, false);
        if (this.isBlocking()) {
            server.method_19537(runner);
        } else {
            server.execute(runner);
        }
    }

    @Override
    void sendToClient(MinecraftServer server) {
        if (this.prepareData(false)) {
            T obj = this.serializeData(false);
            DataHandler._sendToClient(this.getIdentifier(), server, PlayerLookup.all((MinecraftServer)server), obj);
        }
    }

    @Override
    void sendToClient(MinecraftServer server, class_3222 player) {
        if (this.prepareData(false)) {
            T obj = this.serializeData(false);
            DataHandler._sendToClient(this.getIdentifier(), server, List.of(player), obj);
        }
    }

    public static <T extends class_8710> void _sendToClient(class_2960 identifier, MinecraftServer server, Collection<class_3222> players, T payload) {
        if (payload == null) {
            return;
        }
        for (class_3222 player : players) {
            ServerPlayNetworking.send((class_3222)player, payload);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    void sendToServer(class_310 client) {
        if (this.prepareData(true)) {
            T obj = this.serializeData(true);
            ClientPlayNetworking.send(obj);
        }
    }

    public static abstract class FromServer<T extends class_8710>
    extends BaseDataHandler<T> {
        protected FromServer(class_2960 identifier) {
            super(identifier, true);
        }

        protected boolean prepareDataOnServer() {
            return true;
        }

        protected abstract T serializeDataOnServer();

        @Environment(value=EnvType.CLIENT)
        protected abstract void deserializeIncomingDataOnClient(T var1, PacketSender var2);

        @Environment(value=EnvType.CLIENT)
        protected abstract void runOnClientGameThread(class_310 var1);

        @Override
        void receiveFromServer(class_310 client, class_634 handler, T payload, PacketSender responseSender) {
            this.deserializeIncomingDataOnClient(payload, responseSender);
            Runnable runner = () -> this.runOnClientGameThread(client);
            if (this.isBlocking()) {
                client.method_19537(runner);
            } else {
                client.execute(runner);
            }
        }

        @Override
        void receiveFromClient(MinecraftServer server, class_3222 player, class_3244 handler, T payload, PacketSender responseSender) {
            super.receiveFromClient(server, player, handler, payload, responseSender);
            BCLib.LOGGER.error("[Internal Error] The message '" + String.valueOf(this.getIdentifier()) + "' must originate from the server!");
        }

        public void receiveFromMemory(T payload) {
            this.receiveFromServer(class_310.method_1551(), null, payload, null);
        }

        @Override
        final void sendToClient(MinecraftServer server) {
            if (this.prepareDataOnServer()) {
                T obj = this.serializeDataOnServer();
                DataHandler._sendToClient(this.getIdentifier(), server, PlayerLookup.all((MinecraftServer)server), obj);
            }
        }

        @Override
        final void sendToClient(MinecraftServer server, class_3222 player) {
            if (this.prepareDataOnServer()) {
                T obj = this.serializeDataOnServer();
                DataHandler._sendToClient(this.getIdentifier(), server, List.of(player), obj);
            }
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        final void sendToServer(class_310 client) {
            BCLib.LOGGER.error("[Internal Error] The message '" + String.valueOf(this.getIdentifier()) + "' must originate from the server!");
        }

        public static abstract class WithoutPayload<T extends class_8710>
        extends FromServer<T> {
            protected WithoutPayload(class_2960 identifier) {
                super(identifier);
            }

            @Override
            protected boolean prepareDataOnServer() {
                return true;
            }

            @Override
            protected T serializeDataOnServer() {
                return null;
            }

            @Override
            protected void deserializeIncomingDataOnClient(T payload, PacketSender responseSender) {
            }
        }
    }

    public static abstract class FromClient<T extends class_8710>
    extends BaseDataHandler<T> {
        protected FromClient(class_2960 identifier) {
            super(identifier, false);
        }

        @Environment(value=EnvType.CLIENT)
        protected boolean prepareDataOnClient() {
            return true;
        }

        @Environment(value=EnvType.CLIENT)
        protected abstract T serializeDataOnClient();

        protected abstract void deserializeIncomingDataOnServer(T var1, class_1657 var2, PacketSender var3);

        protected abstract void runOnServerGameThread(MinecraftServer var1, class_1657 var2);

        @Override
        void receiveFromServer(class_310 client, class_634 handler, class_8710 payload, PacketSender responseSender) {
            BCLib.LOGGER.error("[Internal Error] The message '" + String.valueOf(this.getIdentifier()) + "' must originate from the client!");
        }

        @Override
        void receiveFromClient(MinecraftServer server, class_3222 player, class_3244 handler, T payload, PacketSender responseSender) {
            super.receiveFromClient(server, player, handler, payload, responseSender);
            this.deserializeIncomingDataOnServer(payload, (class_1657)player, responseSender);
            Runnable runner = () -> this.runOnServerGameThread(server, (class_1657)player);
            if (this.isBlocking()) {
                server.method_19537(runner);
            } else {
                server.execute(runner);
            }
        }

        @Override
        void sendToClient(MinecraftServer server) {
            BCLib.LOGGER.error("[Internal Error] The message '" + String.valueOf(this.getIdentifier()) + "' must originate from the client!");
        }

        @Override
        void sendToClient(MinecraftServer server, class_3222 player) {
            BCLib.LOGGER.error("[Internal Error] The message '" + String.valueOf(this.getIdentifier()) + "' must originate from the client!");
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        void sendToServer(class_310 client) {
            T obj;
            if (this.prepareDataOnClient() && (obj = this.serializeDataOnClient()) != null) {
                ClientPlayNetworking.send(obj);
            }
        }

        public static abstract class WithoutPayload<T extends class_8710>
        extends FromClient<T> {
            protected WithoutPayload(class_2960 identifier) {
                super(identifier);
            }

            @Override
            protected boolean prepareDataOnClient() {
                return true;
            }

            @Override
            protected T serializeDataOnClient() {
                return null;
            }

            @Override
            protected void deserializeIncomingDataOnServer(T payload, class_1657 player, PacketSender responseSender) {
            }
        }
    }

    public static abstract class WithoutPayload<T extends class_8710>
    extends DataHandler<T> {
        protected WithoutPayload(class_2960 identifier, boolean originatesOnServer) {
            super(identifier, originatesOnServer);
        }

        @Override
        protected boolean prepareData(boolean isClient) {
            return true;
        }

        @Override
        protected T serializeData(boolean isClient) {
            return null;
        }

        @Override
        protected void deserializeIncomingData(T payload, PacketSender responseSender, boolean isClient) {
        }
    }
}

