/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.spellbinding;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1718;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2331;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7701;
import net.spell_engine.api.item.SpellEngineItemTags;
import net.spell_engine.api.item.trinket.ISpellBookItem;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.internals.SpellContainerHelper;
import net.spell_engine.spellbinding.SpellBinding;
import net.spell_engine.spellbinding.SpellBindingBlock;
import net.spell_engine.spellbinding.SpellBindingCriteria;
import net.spell_engine.spellbinding.SpellBookCreationCriteria;

public class SpellBindingScreenHandler
extends class_1703 {
    public static final class_3917<SpellBindingScreenHandler> HANDLER_TYPE = new class_3917(SpellBindingScreenHandler::new, class_7701.field_40182);
    public static final int MAXIMUM_SPELL_COUNT = 32;
    public static final int INIT_SYNC_ID = 14999;
    private static final int SPELL_ID_RAW_NONE = -1;
    private final class_1263 inventory = new class_1277(2){

        public void method_5431() {
            super.method_5431();
            SpellBindingScreenHandler.this.method_7609((class_1263)this);
        }
    };
    private final class_3914 context;
    private boolean creative = false;
    public final int[] mode = new int[]{SpellBinding.Mode.SPELL.ordinal()};
    public final int[] spellId = new int[32];
    public final int[] spellLevelCost = new int[32];
    public final int[] spellLevelRequirement = new int[32];
    public final int[] spellPoweredByLib = new int[32];
    public final int[] spellLapisCost = new int[32];
    public static class_2960 soundId = class_2960.method_60655((String)"spell_engine", (String)"bind_spell");
    public static class_3414 soundEvent = class_3414.method_47908((class_2960)soundId);

    public SpellBindingScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, class_3914.field_17304);
    }

    public SpellBindingScreenHandler(int syncId, class_1661 playerInventory, class_3914 context) {
        super(HANDLER_TYPE, syncId);
        int i;
        this.context = context;
        this.method_7621(new class_1735(this, this.inventory, 0, 15, 47){

            public boolean method_7680(class_1799 stack) {
                return stack.method_7909() == class_1802.field_8529 || SpellContainerHelper.hasBindableContainer(stack);
            }

            public int method_7675() {
                return 1;
            }
        });
        this.method_7621(new class_1735(this, this.inventory, 1, 35, 47){

            public boolean method_7680(class_1799 stack) {
                return stack.method_31574(class_1802.field_8759) || stack.method_31573(SpellEngineItemTags.SPELL_BOOK_MERGEABLE);
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)playerInventory, i, 8 + i * 18, 142));
        }
        for (i = 0; i < 32; ++i) {
            this.method_17362(class_3915.method_17406((int[])this.spellId, (int)i));
            this.method_17362(class_3915.method_17406((int[])this.spellLevelCost, (int)i));
            this.method_17362(class_3915.method_17406((int[])this.spellLevelRequirement, (int)i));
            this.method_17362(class_3915.method_17406((int[])this.spellPoweredByLib, (int)i));
            this.method_17362(class_3915.method_17406((int[])this.spellLapisCost, (int)i));
        }
        this.method_17362(class_3915.method_17406((int[])this.mode, (int)0));
        Arrays.fill(this.spellId, -1);
        class_1657 class_16572 = playerInventory.field_7546;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            SpellBindingCriteria.INSTANCE.trigger(serverPlayer, SpellBinding.ADVANCEMENT_VISIT_ID, true);
        }
    }

    public int getLapisCount() {
        class_1799 itemStack = this.inventory.method_5438(1);
        if (itemStack.method_7960()) {
            return 0;
        }
        return itemStack.method_7947();
    }

    public void method_7609(class_1263 inventory) {
        if (inventory != this.inventory) {
            return;
        }
        class_1799 mainStack = inventory.method_5438(0);
        class_1799 consumableStack = inventory.method_5438(1);
        if (mainStack.method_7960() || !SpellContainerHelper.hasValidContainer(mainStack) && mainStack.method_7909() != class_1802.field_8529) {
            this.mode[0] = SpellBinding.Mode.SPELL.ordinal();
            for (int i = 0; i < 32; ++i) {
                this.spellId[i] = -1;
                this.spellLevelCost[i] = 0;
                this.spellLevelRequirement[i] = 0;
                this.spellPoweredByLib[i] = 0;
                this.spellLapisCost[i] = 0;
            }
        } else {
            this.context.method_17393((world, pos) -> {
                int libraryPower = 0;
                for (class_2338 blockPos : class_2331.field_36535) {
                    if (!class_2331.method_40445((class_1937)world, (class_2338)pos, (class_2338)blockPos)) continue;
                    ++libraryPower;
                }
                SpellBinding.OfferResult offerResult = SpellBinding.offersFor(world, this.creative, mainStack, consumableStack, libraryPower);
                this.mode[0] = offerResult.mode().ordinal();
                List<SpellBinding.Offer> offers = offerResult.offers();
                for (int i = 0; i < 32; ++i) {
                    if (i < offers.size()) {
                        SpellBinding.Offer offer = offers.get(i);
                        this.spellId[i] = offer.id();
                        this.spellLevelCost[i] = offer.levelCost();
                        this.spellLevelRequirement[i] = offer.levelRequirement();
                        this.spellPoweredByLib[i] = offer.isPowered() ? 1 : 0;
                        this.spellLapisCost[i] = offer.lapisCost();
                        continue;
                    }
                    this.spellId[i] = -1;
                    this.spellLevelCost[i] = 0;
                    this.spellLevelRequirement[i] = 0;
                    this.spellPoweredByLib[i] = 0;
                    this.spellLapisCost[i] = 0;
                }
                this.method_7623();
            });
        }
    }

    public boolean method_7597(class_1657 player) {
        return class_1718.method_17695((class_3914)this.context, (class_1657)player, (class_2248)SpellBindingBlock.INSTANCE);
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.context.method_17393((world, pos) -> this.method_7607(player, this.inventory));
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 itemStack2 = slot.method_7677();
            itemStack = itemStack2.method_7972();
            if (index == 0) {
                if (!this.method_7616(itemStack2, 2, 38, true)) {
                    return class_1799.field_8037;
                }
            } else if (index == 1) {
                if (!this.method_7616(itemStack2, 2, 38, true)) {
                    return class_1799.field_8037;
                }
            } else if (itemStack2.method_31574(class_1802.field_8759) || itemStack2.method_31573(SpellEngineItemTags.SPELL_BOOK_MERGEABLE)) {
                if (!this.method_7616(itemStack2, 1, 2, true)) {
                    return class_1799.field_8037;
                }
            } else if (!((class_1735)this.field_7761.get(0)).method_7681() && ((class_1735)this.field_7761.get(0)).method_7680(itemStack2)) {
                class_1799 itemStack3 = itemStack2.method_7972();
                itemStack3.method_7939(1);
                itemStack2.method_7934(1);
                ((class_1735)this.field_7761.get(0)).method_53512(itemStack3);
            } else {
                return class_1799.field_8037;
            }
            if (itemStack2.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (itemStack2.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, itemStack2);
        }
        return itemStack;
    }

    public boolean method_7604(class_1657 player, int id) {
        this.creative = player.method_7337();
        if (id == 14999) {
            return false;
        }
        try {
            SpellBinding.Mode mode = SpellBinding.Mode.values()[this.mode[0]];
            int rawId = this.spellId[id];
            int levelCost = this.spellLevelCost[id];
            int requiredLevel = this.spellLevelRequirement[id];
            int poweredByLib = this.spellPoweredByLib[id];
            int lapisCost = this.spellLapisCost[id];
            int lapisCount = this.getLapisCount();
            class_1799 mainStack = (class_1799)this.method_7602().get(0);
            class_1799 consumableStack = (class_1799)this.method_7602().get(1);
            class_1937 playerWorld = player.method_37908();
            if (poweredByLib == 0) {
                return false;
            }
            switch (mode) {
                case SPELL: {
                    Optional spellEntry = SpellRegistry.from(playerWorld).method_40265(rawId);
                    if (spellEntry.isEmpty()) {
                        return false;
                    }
                    class_2960 spellId = ((class_5321)((class_6880.class_6883)spellEntry.get()).method_40230().get()).method_29177();
                    SpellBinding.State binding = SpellBinding.State.of(spellId, mainStack, requiredLevel, levelCost, lapisCost);
                    if (binding.state == SpellBinding.State.ApplyState.INVALID) {
                        return false;
                    }
                    if (!binding.readyToApply(player, lapisCount)) {
                        return false;
                    }
                    this.context.method_17393((world, pos) -> {
                        SpellContainerHelper.addSpell(world, spellId, mainStack);
                        if (consumableStack.method_31573(SpellEngineItemTags.SPELL_BOOK_MERGEABLE)) {
                            consumableStack.method_7934(1);
                        } else if (!player.method_7337()) {
                            consumableStack.method_7934(binding.requirements.lapisCost());
                        }
                        SpellBindingScreenHandler.applyLevelCost(player, binding.requirements.levelCost());
                        this.inventory.method_5431();
                        this.method_7609(this.inventory);
                        world.method_8396(null, pos, soundEvent, class_3419.field_15245, 1.0f, world.field_9229.method_43057() * 0.1f + 0.9f);
                        if (player instanceof class_3222) {
                            class_3222 serverPlayer = (class_3222)player;
                            SpellContainer container = SpellContainerHelper.containerFromItemStack(mainStack);
                            class_2960 poolId = SpellContainerHelper.getPoolId(container);
                            if (poolId != null) {
                                List<class_6880<Spell>> pool = SpellRegistry.entries(world, container.pool());
                                boolean isComplete = container.spell_ids().size() == pool.size();
                                SpellBindingCriteria.INSTANCE.trigger(serverPlayer, poolId, isComplete);
                            } else {
                                SpellBindingCriteria.INSTANCE.trigger(serverPlayer, null, false);
                            }
                        }
                    });
                    break;
                }
                case BOOK: {
                    ISpellBookItem item = SpellBinding.availableSpellBooks(player.method_37908()).get(rawId - 1);
                    class_1799 itemStack = ((class_1792)item).method_7854();
                    SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
                    if (container == null || !container.isValid() || container.pool() == null) {
                        return false;
                    }
                    class_2960 poolId = class_2960.method_60654((String)container.pool());
                    SpellBinding.State binding = SpellBinding.State.forBook(levelCost, requiredLevel);
                    if (binding.state == SpellBinding.State.ApplyState.INVALID) {
                        return false;
                    }
                    if (!binding.readyToApply(player, lapisCount)) {
                        return false;
                    }
                    this.context.method_17393((world, pos) -> {
                        ((class_1735)this.field_7761.get(0)).method_53512(itemStack);
                        if (!player.method_7337()) {
                            consumableStack.method_7934(binding.requirements.lapisCost());
                        }
                        SpellBindingScreenHandler.applyLevelCost(player, binding.requirements.levelCost());
                        this.inventory.method_5431();
                        this.method_7609(this.inventory);
                        world.method_8396(null, pos, soundEvent, class_3419.field_15245, 1.0f, world.field_9229.method_43057() * 0.1f + 0.9f);
                        if (player instanceof class_3222) {
                            class_3222 serverPlayer = (class_3222)player;
                            SpellBookCreationCriteria.INSTANCE.trigger(serverPlayer, poolId);
                        }
                    });
                }
            }
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private static void applyLevelCost(class_1657 player, int levelCost) {
        player.field_7520 -= levelCost;
        if (player.field_7520 < 0) {
            player.field_7520 = 0;
            player.field_7510 = 0.0f;
            player.field_7495 = 0;
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            serverPlayer.method_14252(player.field_7520);
        }
    }
}

