/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.spellbinding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.item.SpellEngineItemTags;
import net.spell_engine.api.item.trinket.ISpellBookItem;
import net.spell_engine.api.item.trinket.SpellBooks;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.internals.SpellContainerHelper;

public class SpellBinding {
    public static final class_2960 ADVANCEMENT_VISIT_ID = class_2960.method_60655((String)"spell_engine", (String)"visit_spell_binding_table");
    public static final String name = "spell_binding";
    public static final class_2960 ID = class_2960.method_60655((String)"spell_engine", (String)"spell_binding");
    private static final float LIBRARY_POWER_BASE = 10.0f;
    private static final float LIBRARY_POWER_MULTIPLIER = 1.5f;
    private static final int LIBRARY_POWER_CAP = 18;
    public static final int BOOK_OFFSET = 1;

    public static List<ISpellBookItem> availableSpellBooks(class_1937 world) {
        return SpellBooks.sorted(world).stream().filter(spellBookItem -> {
            class_1792 item = spellBookItem.method_8389();
            class_6880 entry = class_7923.field_41178.method_47983((Object)item);
            return !entry.method_40220(SpellEngineItemTags.NON_CRAFTABLE_SPELL_BOOK);
        }).toList();
    }

    public static OfferResult offersFor(class_1937 world, boolean creative, class_1799 itemStack, class_1799 consumableStack, int libraryPower) {
        List<class_6880<Spell>> spells;
        if (itemStack.method_7909() == class_1802.field_8529) {
            List<ISpellBookItem> books = SpellBinding.availableSpellBooks(world);
            ArrayList<Offer> offers = new ArrayList<Offer>();
            if (SpellEngineMod.config.spell_book_creation_enabled) {
                for (int i = 0; i < books.size(); ++i) {
                    offers.add(new Offer(i + 1, SpellEngineMod.config.spell_book_creation_cost, SpellEngineMod.config.spell_book_creation_requirement, 0, true));
                }
            }
            return new OfferResult(Mode.BOOK, offers);
        }
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        if (container == null) {
            return new OfferResult(Mode.SPELL, List.of());
        }
        List<class_6880<Spell>> pool = SpellRegistry.entries(world, container.pool());
        if (pool == null || pool.isEmpty()) {
            return new OfferResult(Mode.SPELL, List.of());
        }
        SpellContainer consumableContainer = SpellContainerHelper.containerFromItemStack(consumableStack);
        boolean scrollMode = false;
        if (consumableStack.method_31573(SpellEngineItemTags.SPELL_BOOK_MERGEABLE) && consumableContainer != null) {
            scrollMode = true;
            class_2378<Spell> spellRegistry = SpellRegistry.from(world);
            List<class_6880.class_6883> consumableSpells = consumableContainer.spell_ids().stream().map(class_2960::method_60654).map(arg_0 -> spellRegistry.method_55841(arg_0)).filter(Optional::isPresent).map(Optional::get).toList();
            Set availableSpellIds = pool.stream().map(entry -> ((class_5321)entry.method_40230().get()).method_29177()).collect(Collectors.toSet());
            spells = consumableSpells.stream().filter(entry -> {
                class_2960 spellId = ((class_5321)entry.method_40230().get()).method_29177();
                return availableSpellIds.contains(spellId) || creative;
            }).map(entry -> entry).toList();
        } else {
            spells = pool;
        }
        HashMap spellMap = new HashMap();
        spells.forEach(entry -> {
            Spell spell = (Spell)entry.comp_349();
            spellMap.put(((class_5321)entry.method_40230().get()).method_29177(), spell);
        });
        boolean finalScrollMode = scrollMode;
        return new OfferResult(Mode.SPELL, spellMap.entrySet().stream().filter(entry -> {
            Spell spell = (Spell)entry.getValue();
            if (finalScrollMode) {
                return spell.scroll != null;
            }
            return spell.learn != null && spell.learn.enabled && spell.learn.tier > 0;
        }).sorted(SpellContainerHelper.spellSorter).map(entry -> {
            Spell spell = (Spell)entry.getValue();
            if (finalScrollMode) {
                int cost = spell.learn.tier * spell.scroll.level_cost_per_tier + spell.scroll.apply_cost_base;
                int levelRequirement = spell.learn.tier * spell.scroll.level_requirement_per_tier;
                return new Offer(SpellBinding.rawSpellId(world, (class_2960)entry.getKey()), cost, levelRequirement, 0, true);
            }
            int cost = spell.learn.tier * spell.learn.level_cost_per_tier;
            int levelRequirement = spell.learn.tier * spell.learn.level_requirement_per_tier;
            return new Offer(SpellBinding.rawSpellId(world, (class_2960)entry.getKey()), cost * SpellEngineMod.config.spell_binding_level_cost_multiplier, levelRequirement, cost * SpellEngineMod.config.spell_binding_lapis_cost_multiplier, libraryPower == 18 || 10.0f + (float)libraryPower * 1.5f >= (float)levelRequirement);
        }).collect(Collectors.toList()));
    }

    private static int rawSpellId(class_1937 world, class_2960 spellId) {
        class_2378<Spell> registry = SpellRegistry.from(world);
        class_6880.class_6883 entry = (class_6880.class_6883)registry.method_55841(spellId).get();
        return registry.method_10206((Object)((Spell)entry.comp_349()));
    }

    public record Offer(int id, int levelCost, int levelRequirement, int lapisCost, boolean isPowered) {
    }

    public record OfferResult(Mode mode, List<Offer> offers) {
    }

    public static enum Mode {
        SPELL,
        BOOK;

    }

    public static class State {
        public ApplyState state;
        public Requirements requirements;

        public State(ApplyState state, Requirements requirements) {
            this.state = state;
            this.requirements = requirements;
        }

        public static State of(class_1937 world, int spellId, class_1799 itemStack, int levelCost, int requiredLevel, int lapisCost) {
            class_2378<Spell> registry = SpellRegistry.from(world);
            Optional spellEntry = registry.method_40265(spellId);
            if (spellEntry.isEmpty()) {
                return new State(ApplyState.INVALID, null);
            }
            return State.of(((class_5321)((class_6880.class_6883)spellEntry.get()).method_40230().get()).method_29177(), itemStack, levelCost, requiredLevel, lapisCost);
        }

        public static State of(class_2960 spellId, class_1799 itemStack, int requiredLevel, int levelCost, int lapisCost) {
            SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
            Requirements requirements = new Requirements(lapisCost, levelCost, requiredLevel);
            if (container == null) {
                return new State(ApplyState.INVALID, requirements);
            }
            if (container.spell_ids().contains(spellId.toString())) {
                return new State(ApplyState.ALREADY_APPLIED, requirements);
            }
            if (container.max_spell_count() > 0 && container.spell_ids().size() >= container.max_spell_count()) {
                return new State(ApplyState.NO_MORE_SLOT, requirements);
            }
            return new State(ApplyState.APPLICABLE, requirements);
        }

        public boolean readyToApply(class_1657 player, int lapisCount) {
            return this.state == ApplyState.APPLICABLE && this.requirements != null && this.requirements.satisfiedFor(player, lapisCount);
        }

        public static State forBook(int cost, int requiredLevel) {
            Requirements requirements = new Requirements(0, cost, requiredLevel);
            return new State(ApplyState.APPLICABLE, requirements);
        }

        public static enum ApplyState {
            ALREADY_APPLIED,
            NO_MORE_SLOT,
            APPLICABLE,
            INVALID;

        }

        public record Requirements(int lapisCost, int levelCost, int requiredLevel) {
            public boolean satisfiedFor(class_1657 player, int lapisCount) {
                return player.method_7337() || this.metRequiredLevel(player) && this.hasEnoughLapis(lapisCount) && this.hasEnoughLevelsToSpend(player);
            }

            public boolean metRequiredLevel(class_1657 player) {
                return player.field_7520 >= this.requiredLevel;
            }

            public boolean hasEnoughLapis(int lapisCount) {
                return lapisCount >= this.lapisCost;
            }

            public boolean hasEnoughLevelsToSpend(class_1657 player) {
                return player.field_7520 >= this.levelCost;
            }
        }
    }
}

