/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.spellbinding;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.class_120;
import net.minecraft.class_169;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5658;
import net.minecraft.class_5659;
import net.minecraft.class_6880;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.api.spell.registry.SpellTags;
import net.spell_engine.internals.SpellContainerHelper;
import net.spell_engine.item.ScrollItem;
import net.spell_engine.item.SpellEngineItems;

public class SpellBindRandomlyLootFunction
extends class_120 {
    public static final String NAME = "spell_bind_randomly";
    public static final class_2960 ID = class_2960.method_60655((String)"spell_engine", (String)"spell_bind_randomly");
    public static final MapCodec<SpellBindRandomlyLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> SpellBindRandomlyLootFunction.method_53344((RecordCodecBuilder.Instance)instance).and(instance.group((App)class_5659.field_45888.fieldOf("tier").forGetter(function -> function.tier), (App)Codec.BOOL.fieldOf("add").orElse((Object)false).forGetter(function -> function.add))).apply((Applicative)instance, SpellBindRandomlyLootFunction::new));
    public static final class_5339<SpellBindRandomlyLootFunction> TYPE = new class_5339(CODEC);
    private final class_5658 tier;
    private final boolean add;

    private SpellBindRandomlyLootFunction(List<class_5341> conditions, class_5658 tier, boolean add) {
        super(conditions);
        this.tier = tier;
        this.add = add;
    }

    public class_5339<SpellBindRandomlyLootFunction> method_29321() {
        return TYPE;
    }

    public Set<class_169<?>> method_293() {
        return this.tier.method_293();
    }

    public class_1799 method_522(class_1799 stack, class_47 context) {
        int selectedTier = this.tier.method_366(context);
        List<class_6880.class_6883> spells = SpellRegistry.stream((class_1937)context.method_299()).filter(entry -> ((Spell)entry.comp_349()).learn.tier == selectedTier && entry.method_40220(SpellTags.TREASURE)).toList();
        if (spells.size() > 0) {
            class_6880.class_6883 spell = spells.get(context.method_294().method_43048(spells.size()));
            int retryAttempts = 3;
            if (stack.method_7909() == SpellEngineItems.SCROLL.method_15332()) {
                boolean success = ScrollItem.applySpell(stack, (class_6880<Spell>)spell, true);
                while (retryAttempts-- > 0 && !success) {
                    spell = spells.get(context.method_294().method_43048(spells.size()));
                    success = ScrollItem.applySpell(stack, (class_6880<Spell>)spell, true);
                }
                if (!success) {
                    return class_1799.field_8037;
                }
            } else {
                boolean isValid = SpellContainerHelper.isSpellValidForItem(stack.method_7909(), (class_6880<Spell>)spell);
                while (retryAttempts-- > 0 && !isValid) {
                    spell = spells.get(context.method_294().method_43048(spells.size()));
                    isValid = SpellContainerHelper.isSpellValidForItem(stack.method_7909(), (class_6880<Spell>)spell);
                }
                if (isValid) {
                    SpellContainer container = SpellContainerHelper.create((class_6880<Spell>)spell, stack.method_7909());
                    stack.method_57379(SpellDataComponents.SPELL_CONTAINER, (Object)container);
                }
            }
        } else if (stack.method_7909() == SpellEngineItems.SCROLL.method_15332()) {
            return class_1799.field_8037;
        }
        return stack;
    }

    public static class_120.class_121<?> builder(class_5658 tier) {
        return SpellBindRandomlyLootFunction.method_520(conditions -> new SpellBindRandomlyLootFunction((List<class_5341>)conditions, tier, false));
    }

    public static class_120.class_121<?> builder(class_5658 tier, boolean add) {
        return SpellBindRandomlyLootFunction.method_520(conditions -> new SpellBindRandomlyLootFunction((List<class_5341>)conditions, tier, add));
    }
}

