/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.rpg_series;

import java.util.HashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.minecraft.class_1792;
import net.spell_engine.api.loot.LootConfig;
import net.spell_engine.api.loot.LootHelper;
import net.spell_engine.rpg_series.config.Defaults;
import net.tinyconfig.ConfigManager;

public class RPGSeriesCore {
    public static final String NAMESPACE = "rpg_series";
    public static ConfigManager<LootConfig> lootEquipmentConfig = new ConfigManager("loot_equipment", (Object)Defaults.itemLootConfig).builder().setDirectory("rpg_series").sanitize(true).constrain(LootConfig::constrainValues).build();
    public static ConfigManager<LootConfig> lootScrollsConfig = new ConfigManager("loot_scrolls", (Object)Defaults.scrollLootConfig).builder().setDirectory("rpg_series").sanitize(true).constrain(LootConfig::constrainValues).build();

    public static void initialize() {
        lootEquipmentConfig.refresh();
        lootScrollsConfig.refresh();
        LootHelper.TAG_CACHE.refresh();
        LootTableEvents.MODIFY.register((key, tableBuilder, source, registries) -> {
            LootHelper.configureV2(registries, key.method_29177(), tableBuilder, (LootConfig)RPGSeriesCore.lootEquipmentConfig.value, new HashMap<String, class_1792>());
            LootHelper.configureV2(registries, key.method_29177(), tableBuilder, (LootConfig)RPGSeriesCore.lootScrollsConfig.value, new HashMap<String, class_1792>());
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> LootHelper.updateTagCache((LootConfig)RPGSeriesCore.lootEquipmentConfig.value));
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, serverResourceManager, success) -> LootHelper.updateTagCache((LootConfig)RPGSeriesCore.lootEquipmentConfig.value));
    }
}

