/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.client;

import net.minecraft.class_1291;
import net.minecraft.class_1309;
import net.spell_engine.api.effect.CustomParticleStatusEffect;
import net.spell_engine.api.effect.Synchronized;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.client.beam.BeamEmitterEntity;
import net.spell_engine.internals.Beam;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.particle.ParticleHelper;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1309.class})
public class LivingEntityVisualMixin
implements BeamEmitterEntity {
    @Nullable
    public Beam.Rendered lastRenderedBeam;

    private class_1309 livingEntity() {
        return (class_1309)this;
    }

    @Override
    public void setLastRenderedBeam(Beam.Rendered beam) {
        this.lastRenderedBeam = beam;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick_TAIL_spawnBeamParticles(CallbackInfo ci) {
        class_1309 livingEntity = this.livingEntity();
        Spell.Release.Target.Beam beam = null;
        if (livingEntity instanceof SpellCasterEntity) {
            SpellCasterEntity caster = (SpellCasterEntity)livingEntity;
            beam = caster.getBeam();
        }
        Beam.Rendered renderedBeam = this.lastRenderedBeam;
        if (livingEntity.method_37908().field_9236 && beam != null && renderedBeam != null) {
            Beam.Position position = renderedBeam.position();
            Spell.Release.Target.Beam appearance = renderedBeam.appearance();
            float yaw = livingEntity.method_36454();
            if (position.hitBlock()) {
                for (ParticleBatch batch : appearance.block_hit_particles) {
                    ParticleHelper.play(livingEntity.method_37908(), livingEntity.field_6012, position.end(), appearance.width * 2.0f, yaw, livingEntity.method_36455(), batch);
                }
            }
        }
    }

    @Inject(method={"tickStatusEffects"}, at={@At(value="TAIL")})
    private void tickStatusEffects_TAIL_SpellEngine_CustomParticles(CallbackInfo ci) {
        class_1309 livingEntity = this.livingEntity();
        if (!livingEntity.method_5805() || !livingEntity.method_37908().method_8608()) {
            return;
        }
        for (Synchronized.Effect entry : Synchronized.effectsOf(livingEntity)) {
            class_1291 effect = entry.effect();
            int amplifier = entry.amplifier();
            CustomParticleStatusEffect.Spawner spawner = CustomParticleStatusEffect.spawnerOf(effect);
            if (spawner == null) continue;
            spawner.spawnParticles(livingEntity, amplifier);
        }
    }
}

