/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.Function;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.effect.EntityImmunity;
import net.spell_engine.api.entity.SpellSpawnedEntity;
import net.spell_engine.api.event.CombatEvents;
import net.spell_engine.api.item.trinket.ISpellBookItem;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.event.CustomSpellHandler;
import net.spell_engine.api.spell.event.SpellEvents;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.fx.Sound;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.entity.ConfigurableKnockback;
import net.spell_engine.entity.SpellCloud;
import net.spell_engine.entity.SpellProjectile;
import net.spell_engine.internals.SpellCastSyncHelper;
import net.spell_engine.internals.SpellContainerHelper;
import net.spell_engine.internals.WorldScheduler;
import net.spell_engine.internals.arrow.ArrowHelper;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.particle.ParticleHelper;
import net.spell_engine.utils.AnimationHelper;
import net.spell_engine.utils.AttributeModifierHelper;
import net.spell_engine.utils.ItemCooldownManagerExtension;
import net.spell_engine.utils.SoundHelper;
import net.spell_engine.utils.TargetHelper;
import net.spell_power.api.SpellDamageSource;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import org.jetbrains.annotations.Nullable;

public class SpellHelper {
    private static final class_2960 SPELL_INFINITY = class_2960.method_60655((String)"spell_engine", (String)"spell_infinity");
    public static float launchPointOffsetDefault = 0.5f;
    private static final float knockbackDefaultStrength = 0.4f;

    public static SpellCast.Attempt attemptCasting(class_1657 player, class_1799 itemStack, class_2960 spellId) {
        return SpellHelper.attemptCasting(player, itemStack, spellId, true);
    }

    public static SpellCast.Attempt attemptCasting(class_1657 player, class_1799 itemStack, class_2960 spellId, boolean checkAmmo) {
        AmmoResult ammoResult;
        SpellCasterEntity caster = (SpellCasterEntity)player;
        class_6880.class_6883 spellEntry = SpellRegistry.from(player.method_37908()).method_55841(spellId).orElse(null);
        if (spellEntry == null) {
            return SpellCast.Attempt.none();
        }
        Spell spell = (Spell)spellEntry.comp_349();
        if (caster.getCooldownManager().isCoolingDown(spellId)) {
            return SpellCast.Attempt.failOnCooldown(new SpellCast.Attempt.OnCooldownInfo());
        }
        if (checkAmmo && !(ammoResult = SpellHelper.ammoForSpell(player, spell, itemStack)).satisfied()) {
            return SpellCast.Attempt.failMissingItem(new SpellCast.Attempt.MissingItemInfo(ammoResult.ammo.method_7909()));
        }
        return SpellCast.Attempt.success();
    }

    public static AmmoResult ammoForSpell(class_1657 player, Spell spell, class_1799 itemStack) {
        boolean ignoreAmmo;
        boolean satisfied = true;
        class_1799 ammo = null;
        boolean hasInfinity = false;
        boolean bl = ignoreAmmo = player.method_31549().field_7477 || !SpellEngineMod.config.spell_cost_item_allowed;
        if (!ignoreAmmo && spell.cost.item_id != null && !spell.cost.item_id.isEmpty()) {
            Optional enchantmentQuery;
            class_2960 id = class_2960.method_60654((String)spell.cost.item_id);
            boolean needsArrow = id.method_12832().contains("arrow");
            Optional optional = enchantmentQuery = needsArrow ? player.method_37908().method_30349().method_30530(class_7924.field_41265).method_40264(class_1893.field_9125) : player.method_37908().method_30349().method_30530(class_7924.field_41265).method_55841(SPELL_INFINITY);
            if (enchantmentQuery.isPresent()) {
                boolean bl2 = hasInfinity = class_1890.method_8225((class_6880)((class_6880)enchantmentQuery.get()), (class_1799)itemStack) > 0;
            }
            if (hasInfinity) {
                return new AmmoResult(satisfied, ammo);
            }
            class_1792 ammoItem = (class_1792)class_7923.field_41178.method_10223(id);
            if (ammoItem != null) {
                ammo = ammoItem.method_7854();
                satisfied = player.method_31548().method_7379(ammo);
            }
        }
        return new AmmoResult(satisfied, ammo);
    }

    public static float hasteAffectedValue(float value, float haste) {
        return value / haste;
    }

    public static float hasteAffectedValue(class_1309 caster, SpellSchool school, float value) {
        return SpellHelper.hasteAffectedValue(caster, school, value, null);
    }

    public static float hasteAffectedValue(class_1309 caster, SpellSchool school, float value, class_1799 provisionedWeapon) {
        float haste = SpellPower.getHaste((class_1309)caster, (SpellSchool)school);
        return SpellHelper.hasteAffectedValue(value, haste);
    }

    public static float getRange(class_1657 player, Spell spell) {
        return spell.range_melee ? (float)player.method_55755() + spell.range : spell.range;
    }

    public static float getCastDuration(class_1309 caster, Spell spell) {
        return SpellHelper.getCastDuration(caster, spell, null);
    }

    public static float getCastDuration(class_1309 caster, Spell spell, class_1799 provisionedWeapon) {
        if (spell.cast == null) {
            return 0.0f;
        }
        return SpellHelper.hasteAffectedValue(caster, spell.school, spell.cast.duration, provisionedWeapon);
    }

    public static SpellCast.Duration getCastTimeDetails(class_1309 caster, Spell spell) {
        float haste = spell.cast.haste_affected ? SpellPower.getHaste((class_1309)caster, (SpellSchool)spell.school) : 1.0f;
        float duration = SpellHelper.hasteAffectedValue(spell.cast.duration, haste);
        return new SpellCast.Duration(haste, Math.round(duration * 20.0f));
    }

    public static float getCooldownDuration(class_1309 caster, Spell spell) {
        return SpellHelper.getCooldownDuration(caster, spell, null);
    }

    public static float getCooldownDuration(class_1309 caster, Spell spell, class_1799 provisionedWeapon) {
        float duration = spell.cost.cooldown_duration;
        if (duration > 0.0f && SpellEngineMod.config.haste_affects_cooldown && spell.cost.cooldown_haste_affected) {
            duration = SpellHelper.hasteAffectedValue(caster, spell.school, spell.cost.cooldown_duration, provisionedWeapon);
        }
        return duration;
    }

    public static boolean isChanneled(Spell spell) {
        return SpellHelper.channelValueMultiplier(spell) != 0.0f;
    }

    public static boolean isInstant(Spell spell) {
        return spell.cast.duration == 0.0f;
    }

    public static float channelValueMultiplier(Spell spell) {
        int ticks = spell.cast.channel_ticks;
        if (ticks <= 0) {
            return 0.0f;
        }
        return (float)ticks / 20.0f;
    }

    public static void startCasting(class_1657 player, class_2960 spellId, float speed, int length) {
        class_6880.class_6883 spellEntry = SpellRegistry.from(player.method_37908()).method_55841(spellId).orElse(null);
        if (spellEntry == null) {
            return;
        }
        Spell spell = (Spell)spellEntry.comp_349();
        class_1799 itemStack = player.method_6047();
        SpellCast.Attempt attempt = SpellHelper.attemptCasting(player, itemStack, spellId);
        if (!attempt.isSuccess()) {
            return;
        }
        SpellCast.Process process = new SpellCast.Process((class_6880<Spell>)spellEntry, itemStack.method_7909(), speed, length, player.method_37908().method_8510());
        SpellCastSyncHelper.setCasting(player, process);
        SoundHelper.playSound(player.method_37908(), (class_1297)player, spell.cast.start_sound);
    }

    public static void performSpell(class_1937 world, class_1657 player, class_2960 spellId, TargetHelper.SpellTargetResult targetResult, SpellCast.Action action, float progress) {
        if (player.method_7325()) {
            return;
        }
        Optional optionalSpellEntry = SpellRegistry.from(world).method_55841(spellId);
        if (optionalSpellEntry.isEmpty()) {
            return;
        }
        class_6880.class_6883 spellEntry = (class_6880.class_6883)optionalSpellEntry.get();
        Spell spell = (Spell)spellEntry.comp_349();
        class_1799 heldItemStack = player.method_6047();
        SpellContainerHelper.Source spellSource = SpellContainerHelper.getFirstSourceOfSpell(spellId, player);
        if (spellSource == null) {
            return;
        }
        SpellCast.Attempt attempt = SpellHelper.attemptCasting(player, heldItemStack, spellId);
        if (!attempt.isSuccess()) {
            return;
        }
        SpellCasterEntity caster = (SpellCasterEntity)player;
        List<class_1297> targets = targetResult.entities();
        class_243 targetLocation = targetResult.location();
        float castingSpeed = caster.getCurrentCastingSpeed();
        progress = Math.max(Math.min(progress, 1.0f), 0.0f);
        float channelMultiplier = 1.0f;
        int channelTickIndex = 0;
        int incrementChannelTicks = 0;
        boolean shouldPerformImpact = true;
        Supplier trackingPlayers = Suppliers.memoize(() -> PlayerLookup.tracking((class_1297)player));
        switch (action) {
            case CHANNEL: {
                channelTickIndex = caster.getChannelTickIndex();
                incrementChannelTicks = 1;
                channelMultiplier = SpellHelper.channelValueMultiplier(spell);
                break;
            }
            case RELEASE: {
                if (SpellHelper.isChanneled(spell)) {
                    shouldPerformImpact = false;
                    channelMultiplier = 1.0f;
                } else {
                    channelMultiplier = progress >= 1.0f ? 1.0f : 0.0f;
                }
                SpellCastSyncHelper.clearCasting(player);
            }
        }
        AmmoResult ammoResult = SpellHelper.ammoForSpell(player, spell, heldItemStack);
        if (channelMultiplier > 0.0f && ammoResult.satisfied()) {
            boolean released;
            Spell.Release.Target targeting = spell.release.target;
            boolean bl = released = action == SpellCast.Action.RELEASE;
            if (shouldPerformImpact) {
                ImpactContext context = new ImpactContext(channelMultiplier, 1.0f, null, SpellPower.getSpellPower((SpellSchool)spell.school, (class_1309)player), SpellHelper.impactTargetingMode(spell), channelTickIndex);
                if (spell.release.custom_impact) {
                    Function<CustomSpellHandler.Data, Boolean> handler = CustomSpellHandler.handlers.get(spellId);
                    released = false;
                    if (handler != null) {
                        released = (Boolean)handler.apply((Object)new CustomSpellHandler.Data(player, targets, heldItemStack, action, progress, context));
                    }
                } else {
                    switch (targeting.type) {
                        case AREA: {
                            class_243 center = player.method_19538().method_1031(0.0, (double)(player.method_17682() / 2.0f), 0.0);
                            Spell.Release.Target.Area area = spell.release.target.area;
                            float range = SpellHelper.getRange(player, spell) * player.method_55693();
                            SpellHelper.applyAreaImpact(world, (class_1309)player, targets, range, area, (class_6880<Spell>)spellEntry, spell.impact, context.position(center), true);
                            break;
                        }
                        case BEAM: {
                            SpellHelper.beamImpact(world, (class_1309)player, targets, (class_6880<Spell>)spellEntry, context);
                            break;
                        }
                        case CLOUD: {
                            SpellHelper.placeCloud(world, (class_1309)player, (class_6880<Spell>)spellEntry, context);
                            released = true;
                            break;
                        }
                        case CURSOR: {
                            class_1297 target = targets.stream().findFirst();
                            if (target.isPresent()) {
                                SpellHelper.directImpact(world, (class_1309)player, (class_1297)target.get(), (class_6880<Spell>)spellEntry, context);
                                break;
                            }
                            released = false;
                            break;
                        }
                        case PROJECTILE: {
                            class_1297 target = null;
                            Optional entityFound = targets.stream().findFirst();
                            if (entityFound.isPresent()) {
                                target = (class_1297)entityFound.get();
                            }
                            SpellHelper.shootProjectile(world, (class_1309)player, target, (class_6880<Spell>)spellEntry, context);
                            break;
                        }
                        case METEOR: {
                            class_1297 target = targets.stream().findFirst();
                            if (target.isPresent() || targetLocation != null) {
                                SpellHelper.fallProjectile(world, (class_1309)player, target.orElse(null), targetLocation, (class_6880<Spell>)spellEntry, context);
                                break;
                            }
                            released = false;
                            break;
                        }
                        case SELF: {
                            SpellHelper.directImpact(world, (class_1309)player, (class_1297)player, (class_6880<Spell>)spellEntry, context);
                            released = true;
                            break;
                        }
                        case SHOOT_ARROW: {
                            ArrowHelper.shootArrow(world, (class_1309)player, (class_6880<Spell>)spellEntry, context);
                            released = true;
                        }
                    }
                }
                caster.setChannelTickIndex(channelTickIndex + incrementChannelTicks);
            }
            if (released) {
                Optional effect;
                ParticleHelper.sendBatches((class_1297)player, spell.release.particles);
                SoundHelper.playSound(world, (class_1297)player, spell.release.sound);
                AnimationHelper.sendAnimation(player, (Collection)trackingPlayers.get(), SpellCast.Animation.RELEASE, spell.release.animation, castingSpeed);
                SpellHelper.imposeCooldown(player, spellSource, spellId, spell, progress);
                player.method_7322(spell.cost.exhaust * SpellEngineMod.config.spell_cost_exhaust_multiplier);
                if (SpellEngineMod.config.spell_cost_durability_allowed && spell.cost.durability > 0) {
                    class_1799 stackToDamage = spellSource.itemStack().method_7963() ? spellSource.itemStack() : heldItemStack;
                    stackToDamage.method_7970(spell.cost.durability, (class_1309)player, class_1304.field_6173);
                }
                if (ammoResult.ammo != null && spell.cost.consume_item) {
                    for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                        class_1799 stack = player.method_31548().method_5438(i);
                        if (!stack.method_31574(ammoResult.ammo.method_7909())) continue;
                        stack.method_7934(1);
                        if (!stack.method_7960()) break;
                        player.method_31548().method_7378(stack);
                        break;
                    }
                }
                if (spell.cost.effect_id != null && (effect = class_7923.field_41174.method_55841(class_2960.method_60654((String)spell.cost.effect_id))).isPresent()) {
                    player.method_6016((class_6880)effect.get());
                }
                if (CombatEvents.SPELL_CAST.isListened()) {
                    CombatEvents.SpellCast.Args args = new CombatEvents.SpellCast.Args(player, (class_6880<Spell>)spellEntry, targets, action, progress);
                    CombatEvents.SPELL_CAST.invoke(listener -> listener.onSpellCast(args));
                }
            }
        }
    }

    public static void imposeCooldown(class_1657 player, SpellContainerHelper.Source source, class_2960 spellId, Spell spell, float progress) {
        float duration = SpellHelper.cooldownToSet((class_1309)player, spell, progress);
        int durationTicks = Math.round(duration * 20.0f);
        if (duration > 0.0f) {
            ((SpellCasterEntity)player).getCooldownManager().set(spellId, durationTicks);
        }
        if (SpellEngineMod.config.spell_item_cooldown_lock && spell.cost.cooldown_hosting_item) {
            class_1792 hostingItem = source.itemStack().method_7909();
            class_1796 itemCooldowns = player.method_7357();
            float durationLeft = (float)((ItemCooldownManagerExtension)itemCooldowns).SE_getLastCooldownDuration(hostingItem) * itemCooldowns.method_7905(hostingItem, 0.0f);
            if ((float)durationTicks > durationLeft) {
                itemCooldowns.method_7906(hostingItem, durationTicks);
            }
        }
    }

    private static float cooldownToSet(class_1309 caster, Spell spell, float progress) {
        if (spell.cost.cooldown_proportional) {
            return SpellHelper.getCooldownDuration(caster, spell) * progress;
        }
        return SpellHelper.getCooldownDuration(caster, spell);
    }

    public static float launchHeight(class_1309 livingEntity) {
        float eyeHeight = livingEntity.method_5751();
        double shoulderDistance = (double)livingEntity.method_17682() * 0.15;
        return (float)(((double)eyeHeight - shoulderDistance) * (double)livingEntity.method_17825());
    }

    public static class_243 launchPoint(class_1309 caster) {
        return SpellHelper.launchPoint(caster, launchPointOffsetDefault);
    }

    public static class_243 launchPoint(class_1309 caster, float forward) {
        class_243 look = caster.method_5720().method_1021((double)(forward * caster.method_17825()));
        return caster.method_19538().method_1031(0.0, (double)SpellHelper.launchHeight(caster), 0.0).method_1019(look);
    }

    public static void shootProjectile(class_1937 world, class_1309 caster, class_1297 target, class_6880<Spell> spellEntry, ImpactContext context) {
        SpellHelper.shootProjectile(world, caster, target, spellEntry, context, 0);
    }

    public static void shootProjectile(class_1937 world, class_1309 caster, class_1297 target, class_6880<Spell> spellEntry, ImpactContext context, int sequenceIndex) {
        if (world.field_9236) {
            return;
        }
        Spell spell = (Spell)spellEntry.comp_349();
        class_243 launchPoint = SpellHelper.launchPoint(caster);
        Spell.Release.Target.ShootProjectile data = spell.release.target.projectile;
        Spell.ProjectileData projectileData = data.projectile;
        Spell.ProjectileData.Perks mutablePerks = projectileData.perks.copy();
        SpellProjectile projectile = new SpellProjectile(world, caster, launchPoint.method_10216(), launchPoint.method_10214(), launchPoint.method_10215(), SpellProjectile.Behaviour.FLY, ((class_5321)spellEntry.method_40230().get()).method_29177(), target, context, mutablePerks);
        Spell.LaunchProperties mutableLaunchProperties = data.launch_properties.copy();
        if (SpellEvents.PROJECTILE_SHOOT.isListened()) {
            SpellEvents.PROJECTILE_SHOOT.invoke(listener -> listener.onProjectileLaunch(new SpellEvents.ProjectileLaunchEvent(projectile, mutableLaunchProperties, caster, target, spellEntry, context, sequenceIndex)));
        }
        float velocity = mutableLaunchProperties.velocity;
        float divergence = projectileData.divergence;
        float casterPitch = caster.method_36455();
        float casterYaw = caster.method_36454();
        if (data.inherit_shooter_velocity) {
            projectile.method_24919((class_1297)caster, casterPitch, casterYaw, 0.0f, velocity, divergence);
        } else {
            if (!(data.direction_offsets == null || data.direction_offsets.length <= 0 || data.direction_offsets_require_target && target == null)) {
                int baseIndex = context.isChanneled() ? context.channelTickIndex() : sequenceIndex;
                int index = baseIndex % data.direction_offsets.length;
                Spell.Release.Target.ShootProjectile.DirectionOffset offset = data.direction_offsets[index];
                casterPitch += offset.pitch;
                casterYaw += offset.yaw;
            }
            class_243 look = caster.method_5631(casterPitch, casterYaw).method_1029();
            projectile.method_7485(look.field_1352, look.field_1351, look.field_1350, velocity, divergence);
        }
        projectile.range = spell.range;
        projectile.method_36457(casterPitch);
        projectile.method_36456(casterYaw);
        projectile.setFollowedTarget(target);
        world.method_8649((class_1297)projectile);
        SoundHelper.playSound(world, (class_1297)projectile, mutableLaunchProperties.sound);
        if (sequenceIndex == 0 && mutableLaunchProperties.extra_launch_count > 0) {
            for (int i = 0; i < mutableLaunchProperties.extra_launch_count; ++i) {
                int ticks = (i + 1) * mutableLaunchProperties.extra_launch_delay;
                int nextSequenceIndex = i + 1;
                ((WorldScheduler)world).schedule(ticks, () -> {
                    if (caster == null || !caster.method_5805()) {
                        return;
                    }
                    SpellHelper.shootProjectile(world, caster, target, spellEntry, context, nextSequenceIndex);
                });
            }
        }
    }

    public static boolean fallProjectile(class_1937 world, class_1309 caster, class_1297 target, @Nullable class_243 targetLocation, class_6880<Spell> spellEntry, ImpactContext context) {
        return SpellHelper.fallProjectile(world, caster, target, targetLocation, spellEntry, context, 0);
    }

    public static boolean fallProjectile(class_1937 world, class_1309 caster, class_1297 target, @Nullable class_243 targetLocation, class_6880<Spell> spellEntry, ImpactContext context, int sequenceIndex) {
        class_243 targetPosition;
        if (world.field_9236) {
            return false;
        }
        class_243 class_2432 = targetPosition = target != null ? target.method_19538() : targetLocation;
        if (targetPosition == null) {
            return false;
        }
        Spell spell = (Spell)spellEntry.comp_349();
        Spell.Release.Target.Meteor meteor = spell.release.target.meteor;
        if (meteor.requires_entity && target == null) {
            return false;
        }
        float height = meteor.launch_height;
        class_243 launchPoint = targetPosition.method_1031(0.0, (double)height, 0.0);
        Spell.Release.Target.Meteor data = spell.release.target.meteor;
        Spell.ProjectileData projectileData = data.projectile;
        Spell.LaunchProperties mutableLaunchProperties = data.launch_properties.copy();
        Spell.ProjectileData.Perks mutablePerks = projectileData.perks.copy();
        SpellProjectile projectile = new SpellProjectile(world, caster, launchPoint.method_10216(), launchPoint.method_10214(), launchPoint.method_10215(), SpellProjectile.Behaviour.FALL, ((class_5321)spellEntry.method_40230().get()).method_29177(), target, context, mutablePerks);
        if (SpellEvents.PROJECTILE_FALL.isListened()) {
            SpellEvents.PROJECTILE_FALL.invoke(listener -> listener.onProjectileLaunch(new SpellEvents.ProjectileLaunchEvent(projectile, mutableLaunchProperties, caster, target, spellEntry, context, sequenceIndex)));
        }
        projectile.method_36456(0.0f);
        projectile.method_36457(90.0f);
        if (SpellHelper.launchSequenceEligible(sequenceIndex, meteor.divergence_requires_sequence)) {
            projectile.setVelocity(0.0, -1.0, 0.0, mutableLaunchProperties.velocity, 0.5f, projectileData.divergence);
        } else {
            projectile.method_18799(new class_243(0.0, (double)(-mutableLaunchProperties.velocity), 0.0));
        }
        if (SpellHelper.launchSequenceEligible(sequenceIndex, meteor.follow_target_requires_sequence)) {
            projectile.setFollowedTarget(target);
        } else {
            projectile.setFollowedTarget(null);
        }
        if (meteor.launch_radius > 0.0f && SpellHelper.launchSequenceEligible(sequenceIndex, meteor.offset_requires_sequence)) {
            double randomAngle = Math.toRadians(world.field_9229.method_43057() * 360.0f);
            class_243 offset = new class_243((double)meteor.launch_radius, 0.0, 0.0).method_1024((float)randomAngle);
            projectile.method_33574(projectile.method_19538().method_1019(offset));
        }
        projectile.field_5982 = projectile.method_36454();
        projectile.field_6004 = projectile.method_36455();
        projectile.range = height;
        world.method_8649((class_1297)projectile);
        if (sequenceIndex == 0 && mutableLaunchProperties.extra_launch_count > 0) {
            for (int i = 0; i < mutableLaunchProperties.extra_launch_count; ++i) {
                int ticks = (i + 1) * mutableLaunchProperties.extra_launch_delay;
                int nextSequenceIndex = i + 1;
                ((WorldScheduler)world).schedule(ticks, () -> {
                    if (caster == null || !caster.method_5805()) {
                        return;
                    }
                    SpellHelper.fallProjectile(world, caster, target, targetLocation, spellEntry, context, nextSequenceIndex);
                });
            }
        }
        return true;
    }

    private static boolean launchSequenceEligible(int index, int rule) {
        if (rule == 0) {
            return false;
        }
        if (rule > 0) {
            return index >= rule;
        }
        return index < -1 * rule;
    }

    private static void directImpact(class_1937 world, class_1309 caster, class_1297 target, class_6880<Spell> spellEntry, ImpactContext context) {
        SpellHelper.performImpacts(world, caster, target, target, spellEntry, ((Spell)spellEntry.comp_349()).impact, context);
    }

    private static void beamImpact(class_1937 world, class_1309 caster, List<class_1297> targets, class_6880<Spell> spellEntry, ImpactContext context) {
        for (class_1297 target : targets) {
            SpellHelper.performImpacts(world, caster, target, target, spellEntry, ((Spell)spellEntry.comp_349()).impact, context.position(target.method_19538()));
        }
    }

    public static void fallImpact(class_1309 caster, class_1297 projectile, class_6880<Spell> spellEntry, ImpactContext context) {
        class_243 adjustedCenter = context.position().method_1031(0.0, 1.0, 0.0);
        SpellHelper.performImpacts(projectile.method_37908(), caster, null, projectile, spellEntry, ((Spell)spellEntry.comp_349()).impact, context.position(adjustedCenter));
    }

    public static boolean projectileImpact(class_1309 caster, class_1297 projectile, class_1297 target, class_6880<Spell> spellEntry, ImpactContext context) {
        return SpellHelper.performImpacts(projectile.method_37908(), caster, target, projectile, spellEntry, ((Spell)spellEntry.comp_349()).impact, context);
    }

    public static boolean arrowImpact(class_1309 caster, class_1297 projectile, class_1297 target, class_6880<Spell> spellEntry, ImpactContext context) {
        Spell.ArrowPerks arrowPerks = ((Spell)spellEntry.comp_349()).arrow_perks;
        if (arrowPerks != null && arrowPerks.impact != null) {
            return SpellHelper.performImpacts(projectile.method_37908(), caster, target, projectile, spellEntry, arrowPerks.impact, context);
        }
        return false;
    }

    public static void lookupAndPerformAreaImpact(Spell.AreaImpact area_impact, class_6880<Spell> spellEntry, class_1309 caster, class_1297 exclude, class_1297 aoeSource, Spell.Impact[] impacts, ImpactContext context, boolean additionalTargetLookup) {
        class_243 center = context.position();
        float radius = area_impact.combinedRadius(context.power());
        List<class_1297> targets = TargetHelper.targetsFromArea(aoeSource, center, radius, area_impact.area, null);
        if (exclude != null) {
            targets.remove(exclude);
        }
        SpellHelper.applyAreaImpact(aoeSource.method_37908(), caster, targets, radius, area_impact.area, spellEntry, impacts, context.target(TargetHelper.TargetingMode.AREA), additionalTargetLookup);
        ParticleHelper.sendBatches(aoeSource, area_impact.particles);
        SoundHelper.playSound(aoeSource.method_37908(), aoeSource, area_impact.sound);
    }

    private static void applyAreaImpact(class_1937 world, class_1309 caster, List<class_1297> targets, float range, Spell.Release.Target.Area area, class_6880<Spell> spellEntry, Spell.Impact[] impacts, ImpactContext context, boolean additionalTargetLookup) {
        double squaredRange = range * range;
        class_243 center = context.position();
        for (class_1297 target : targets) {
            float distanceBasedMultiplier = 1.0f;
            switch (area.distance_dropoff) {
                case NONE: {
                    break;
                }
                case SQUARED: {
                    distanceBasedMultiplier = (float)((squaredRange - target.method_5707(center)) / squaredRange);
                    distanceBasedMultiplier = Math.max(distanceBasedMultiplier, 0.0f);
                }
            }
            SpellHelper.performImpacts(world, caster, target, target, spellEntry, impacts, context.distance(distanceBasedMultiplier), additionalTargetLookup);
        }
    }

    public static boolean performImpacts(class_1937 world, class_1309 caster, @Nullable class_1297 target, class_1297 aoeSource, class_6880<Spell> spellEntry, Spell.Impact[] impacts, ImpactContext context) {
        return SpellHelper.performImpacts(world, caster, target, aoeSource, spellEntry, impacts, context, true);
    }

    public static boolean performImpacts(class_1937 world, class_1309 caster, @Nullable class_1297 target, class_1297 aoeSource, class_6880<Spell> spellEntry, Spell.Impact[] impacts, ImpactContext context, boolean additionalTargetLookup) {
        Collection trackers = target != null ? PlayerLookup.tracking((class_1297)target) : null;
        Spell spell = (Spell)spellEntry.comp_349();
        boolean performed = false;
        TargetHelper.Intent selectedIntent = null;
        for (Spell.Impact impact : impacts) {
            TargetHelper.Intent intent = SpellHelper.intent(impact.action);
            if (!impact.action.apply_to_caster && selectedIntent != null && selectedIntent != intent || target == null) continue;
            boolean result = SpellHelper.performImpact(world, caster, target, spellEntry, impact, context, trackers);
            boolean bl = performed = performed || result;
            if (!result) continue;
            selectedIntent = intent;
        }
        Spell.AreaImpact area_impact = spell.area_impact;
        if (area_impact != null && additionalTargetLookup && (performed || target == null)) {
            SpellHelper.lookupAndPerformAreaImpact(area_impact, spellEntry, caster, target, aoeSource, impacts, context, false);
        }
        return performed;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean performImpact(class_1937 world, class_1309 caster, class_1297 target, class_6880<Spell> spellEntry, Spell.Impact impact, ImpactContext context, Collection<class_3222> trackers) {
        block44: {
            if (!target.method_5732()) {
                return false;
            }
            success = false;
            isKnockbackPushed = false;
            spell = (Spell)spellEntry.comp_349();
            try {
                if (impact.action.apply_to_caster) {
                    target = caster;
                }
                intent = SpellHelper.intent(impact.action);
                if (!TargetHelper.actionAllowed(context.targetingMode(), intent, caster, target)) {
                    return false;
                }
                if (intent == TargetHelper.Intent.HARMFUL && context.targetingMode() == TargetHelper.TargetingMode.AREA && ((EntityImmunity)target).isImmuneTo(EntityImmunity.Type.AREA_EFFECT)) {
                    return false;
                }
                conditionResult = SpellHelper.evaluateImpactConditions(target, impact.target_conditions);
                if (!conditionResult.allowed) {
                    return false;
                }
                particleMultiplier = 1.0f * context.total();
                power = context.power();
                v0 = school = impact.school != null ? impact.school : spell.school;
                if (power == null || power.school() != school) {
                    power = SpellPower.getSpellPower((SpellSchool)school, (class_1309)caster);
                }
                bonusPower = 1.0f + conditionResult.modifiers().stream().map((java.util.function.Function<Spell.Impact.Modifier, Float>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$performImpact$6(net.spell_engine.api.spell.Spell$Impact$Modifier ), (Lnet/spell_engine/api/spell/Spell$Impact$Modifier;)Ljava/lang/Float;)()).reduce(Float.valueOf(0.0f), (BinaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, sum(float float ), (Ljava/lang/Float;Ljava/lang/Float;)Ljava/lang/Float;)()).floatValue();
                bonusCritChance = conditionResult.modifiers().stream().map((java.util.function.Function<Spell.Impact.Modifier, Float>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$performImpact$7(net.spell_engine.api.spell.Spell$Impact$Modifier ), (Lnet/spell_engine/api/spell/Spell$Impact$Modifier;)Ljava/lang/Float;)()).reduce(Float.valueOf(0.0f), (BinaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, sum(float float ), (Ljava/lang/Float;Ljava/lang/Float;)Ljava/lang/Float;)());
                bonusCritDamage = conditionResult.modifiers().stream().map((java.util.function.Function<Spell.Impact.Modifier, Float>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$performImpact$8(net.spell_engine.api.spell.Spell$Impact$Modifier ), (Lnet/spell_engine/api/spell/Spell$Impact$Modifier;)Ljava/lang/Float;)()).reduce(Float.valueOf(0.0f), (BinaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, sum(float float ), (Ljava/lang/Float;Ljava/lang/Float;)Ljava/lang/Float;)());
                if ((power = new SpellPower.Result(power.school(), power.baseValue() * (double)bonusPower, power.criticalChance() + (double)bonusCritChance.floatValue(), power.criticalDamage() + (double)bonusCritDamage.floatValue())).baseValue() < (double)impact.action.min_power) {
                    power = new SpellPower.Result(power.school(), (double)impact.action.min_power, power.criticalChance(), power.criticalDamage());
                }
                switch (1.$SwitchMap$net$spell_engine$api$spell$Spell$Impact$Action$Type[impact.action.type.ordinal()]) {
                    case 1: {
                        damageData = impact.action.damage;
                        knockbackMultiplier = Math.max(0.0f, damageData.knockback * context.total());
                        vulnerability = SpellPower.Vulnerability.none;
                        timeUntilRegen = target.field_6008;
                        if (target instanceof class_1309) {
                            livingEntity = (class_1309)target;
                            ((ConfigurableKnockback)livingEntity).pushKnockbackMultiplier_SpellEngine(context.hasOffset() != false ? 0.0f : knockbackMultiplier);
                            isKnockbackPushed = true;
                            if (damageData.bypass_iframes && SpellEngineMod.config.bypass_iframes) {
                                target.field_6008 = 0;
                            }
                            vulnerability = SpellPower.getVulnerability((class_1309)livingEntity, (SpellSchool)school);
                        }
                        amount = power.randomValue(vulnerability);
                        amount *= (double)damageData.spell_power_coefficient;
                        amount *= (double)context.total();
                        if (context.isChanneled()) {
                            amount *= (double)SpellPower.getHaste((class_1309)caster, (SpellSchool)school);
                        }
                        particleMultiplier = power.criticalDamage() + (double)vulnerability.criticalDamageBonus();
                        caster.method_6114(target);
                        target.method_5643(SpellDamageSource.create((SpellSchool)school, (class_1309)caster), (float)amount);
                        if (target instanceof class_1309) {
                            livingEntity = (class_1309)target;
                            ((ConfigurableKnockback)livingEntity).popKnockbackMultiplier_SpellEngine();
                            isKnockbackPushed = false;
                            target.field_6008 = timeUntilRegen;
                            if (context.hasOffset()) {
                                direction = context.knockbackDirection(livingEntity.method_19538()).method_22882();
                                livingEntity.method_6005((double)(0.4f * knockbackMultiplier), direction.field_1352, direction.field_1350);
                            }
                        }
                        success = true;
                        break;
                    }
                    case 2: {
                        if (!(target instanceof class_1309)) break;
                        livingTarget = (class_1309)target;
                        healData = impact.action.heal;
                        particleMultiplier = power.criticalDamage();
                        amount = power.randomValue();
                        amount *= (double)healData.spell_power_coefficient;
                        amount *= (double)context.total();
                        if (context.isChanneled()) {
                            amount *= (double)SpellPower.getHaste((class_1309)caster, (SpellSchool)school);
                        }
                        livingTarget.method_6025((float)amount);
                        success = true;
                        break;
                    }
                    case 3: {
                        data = impact.action.status_effect;
                        if (!(target instanceof class_1309)) break;
                        livingTarget = (class_1309)target;
                        id = class_2960.method_60654((String)data.effect_id);
                        effectQuery = class_7923.field_41174.method_55841(id);
                        if (effectQuery.isEmpty()) {
                            return false;
                        }
                        effect = (class_6880.class_6883)effectQuery.get();
                        if (!SpellHelper.underApplyLimit(power, livingTarget, school, data.apply_limit)) {
                            return false;
                        }
                        duration = Math.round(data.duration * 20.0f);
                        amplifier = data.amplifier + (int)((double)data.amplifier_power_multiplier * power.nonCriticalValue());
                        showParticles = data.show_particles;
                        switch (1.$SwitchMap$net$spell_engine$api$spell$Spell$Impact$Action$StatusEffect$ApplyMode[data.apply_mode.ordinal()]) {
                            case 1: {
                                break;
                            }
                            case 2: {
                                currentEffect = livingTarget.method_6112((class_6880)effect);
                                newAmplifier = 0;
                                if (currentEffect != null) {
                                    incrementedAmplifier = currentEffect.method_5578() + 1;
                                    newAmplifier = Math.min(incrementedAmplifier, amplifier);
                                }
                                amplifier = newAmplifier;
                            }
                        }
                        livingTarget.method_37222(new class_1293((class_6880)effect, duration, amplifier, false, showParticles, true), (class_1297)caster);
                        success = true;
                        break;
                    }
                    case 4: {
                        data = impact.action.fire;
                        target.method_5639((float)data.duration);
                        if (target.method_20802() <= 0) break;
                        target.method_20803(target.method_20802() + data.tick_offset);
                        break;
                    }
                    case 5: {
                        spawns = impact.action.spawns.length > 0 ? List.of(impact.action.spawns) : List.of(impact.action.spawn);
                        for (Spell.Impact.Action.Spawn data : spawns) {
                            id = class_2960.method_60654((String)data.entity_type_id);
                            type = (class_1299)class_7923.field_41177.method_10223(id);
                            entity = type.method_5883(world);
                            SpellHelper.applyEntityPlacement(entity, caster, target.method_19538(), data.placement);
                            if (entity instanceof SpellSpawnedEntity) {
                                spellSpawnedEntity = (SpellSpawnedEntity)entity;
                                spellSpawnedEntity.onCreatedFromSpell(caster, ((class_5321)spellEntry.method_40230().get()).method_29177(), data);
                            }
                            ((WorldScheduler)world).schedule(data.delay_ticks, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$performImpact$9(net.minecraft.class_1937 net.minecraft.class_1297 ), ()V)((class_1937)world, (class_1297)entity));
                            success = true;
                        }
                        break;
                    }
                    case 6: {
                        data = impact.action.teleport;
                        if (!(target instanceof class_1309)) break;
                        livingTarget = (class_1309)target;
                        teleportedEntity = null;
                        destination = null;
                        startingPosition = null;
                        applyRotation = null;
                        switch (1.$SwitchMap$net$spell_engine$api$spell$Spell$Impact$Action$Teleport$Mode[data.mode.ordinal()]) {
                            case 1: {
                                teleportedEntity = livingTarget;
                                forward = data.forward;
                                look = target.method_5720();
                                startingPosition = target.method_19538();
                                destination = TargetHelper.findTeleportDestination(teleportedEntity, look, forward.distance, data.required_clearance_block_y);
                                groundJustBelow = TargetHelper.findSolidBlockBelow(teleportedEntity, destination, target.method_37908(), -1.5f);
                                if (groundJustBelow == null) break;
                                destination = groundJustBelow;
                                break;
                            }
                            case 2: {
                                if (livingTarget == caster) {
                                    return false;
                                }
                                look = target.method_5720();
                                distance = 1.0f;
                                if (data.behind_target != null) {
                                    distance = data.behind_target.distance;
                                }
                                teleportedEntity = caster;
                                startingPosition = caster.method_19538();
                                destination = target.method_19538().method_1019(look.method_1021((double)(-distance)));
                                groundJustBelow = TargetHelper.findSolidBlockBelow(teleportedEntity, destination, target.method_37908(), -1.5f);
                                if (groundJustBelow != null) {
                                    destination = groundJustBelow;
                                }
                                yaw = (yaw = (float)Math.toDegrees(Math.atan2(-(x = look.field_1352), z = look.field_1350))) < 0.0f ? yaw + 360.0f : yaw;
                                applyRotation = Float.valueOf(yaw);
                            }
                        }
                        if (destination == null || startingPosition == null || teleportedEntity == null) break;
                        ParticleHelper.sendBatches((class_1297)teleportedEntity, data.depart_particles, false);
                        world.method_32888((class_6880)class_5712.field_39446, startingPosition, class_5712.class_7397.method_43285((class_1297)teleportedEntity));
                        if (applyRotation == null || !(teleportedEntity instanceof class_3222)) ** GOTO lbl-1000
                        serverPlayer = (class_3222)teleportedEntity;
                        if (world instanceof class_3218) {
                            serverWorld = (class_3218)world;
                            serverPlayer.method_14251(serverWorld, destination.field_1352, destination.field_1351, destination.field_1350, applyRotation.floatValue(), serverPlayer.method_36455());
                        } else lbl-1000:
                        // 2 sources

                        {
                            teleportedEntity.method_6082(destination.field_1352, destination.field_1351, destination.field_1350, false);
                        }
                        success = true;
                        ParticleHelper.sendBatches((class_1297)teleportedEntity, data.arrive_particles, false);
                    }
                }
                if (success) {
                    if (impact.particles != null) {
                        ParticleHelper.sendBatches(target, impact.particles, (float)particleMultiplier * caster.method_55693(), trackers);
                    }
                    if (impact.sound != null) {
                        SoundHelper.playSound(world, target, impact.sound);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Failed to perform impact effect");
                System.err.println(e.getMessage());
                if (!isKnockbackPushed) break block44;
                ((ConfigurableKnockback)target).popKnockbackMultiplier_SpellEngine();
            }
        }
        return success;
    }

    public static TargetConditionResult evaluateImpactConditions(class_1297 target, Spell.Impact.TargetCondition[] target_conditions) {
        if (target_conditions == null) {
            return TargetConditionResult.ALLOWED;
        }
        ArrayList<Spell.Impact.Modifier> modifiers = new ArrayList<Spell.Impact.Modifier>();
        for (Spell.Impact.TargetCondition condition : target_conditions) {
            boolean conditionMet;
            boolean entityTypeMatches = false;
            if (condition.entity_type != null && !condition.entity_type.isEmpty()) {
                boolean invert = condition.entity_type.startsWith("!");
                entityTypeMatches = invert ? !SpellHelper.entityTypeMatches(condition.entity_type.substring(1), target) : SpellHelper.entityTypeMatches(condition.entity_type, target);
            }
            boolean hasStatusEffect = false;
            if (condition.has_effect != null && !condition.has_effect.isEmpty() && target instanceof class_1309) {
                class_1309 livingTarget = (class_1309)target;
                boolean invert = condition.has_effect.startsWith("!");
                String idString = invert ? condition.has_effect.substring(1) : condition.has_effect;
                class_2960 id = class_2960.method_60654((String)idString);
                Optional effect = class_7923.field_41174.method_55841(id);
                boolean bl = hasStatusEffect = effect.isPresent() && livingTarget.method_6059((class_6880)effect.get());
            }
            boolean bl = condition.all_required ? entityTypeMatches && hasStatusEffect : (conditionMet = entityTypeMatches || hasStatusEffect);
            if (!conditionMet) continue;
            if (!condition.allow_action) {
                return TargetConditionResult.DENIED;
            }
            if (condition.modifier == null) continue;
            modifiers.add(condition.modifier);
        }
        return new TargetConditionResult(true, modifiers);
    }

    public static boolean entityTypeMatches(String typeString, class_1297 target) {
        if (typeString.startsWith("#")) {
            class_2960 id = class_2960.method_60654((String)typeString.substring(1));
            class_6862 tag = class_6862.method_40092((class_5321)class_7923.field_41177.method_30517(), (class_2960)id);
            if (tag != null) {
                return target.method_5864().method_20210(tag);
            }
        } else {
            class_2960 id = class_2960.method_60654((String)typeString);
            Optional type = class_7923.field_41177.method_55841(id);
            if (type.isPresent()) {
                return ((class_1299)((class_6880.class_6883)type.get()).comp_349()).equals(target.method_5864());
            }
        }
        return false;
    }

    public static void placeCloud(class_1937 world, class_1309 caster, class_6880<Spell> spellEntry, ImpactContext context) {
        Spell spell = (Spell)spellEntry.comp_349();
        List<Spell.Release.Target.Cloud> clouds = spell.release.target.clouds.length > 0 ? List.of(spell.release.target.clouds) : List.of(spell.release.target.cloud);
        for (Spell.Release.Target.Cloud cloud : clouds) {
            SpellCloud entity;
            if (cloud.entity_type_id != null) {
                class_2960 id = class_2960.method_60654((String)cloud.entity_type_id);
                class_1299 type = (class_1299)class_7923.field_41177.method_10223(id);
                entity = (SpellCloud)type.method_5883(world);
            } else {
                entity = new SpellCloud(world);
            }
            entity.setOwner(caster);
            entity.onCreatedFromSpell(((class_5321)spellEntry.method_40230().get()).method_29177(), cloud, context);
            SpellHelper.applyEntityPlacement(entity, caster, caster.method_19538(), cloud.placement);
            ((WorldScheduler)world).schedule(cloud.delay_ticks, () -> {
                ParticleBatch[] particles;
                world.method_8649((class_1297)entity);
                Sound sound = cloud.spawn.sound;
                if (sound != null) {
                    SoundHelper.playSound(world, entity, sound);
                }
                if ((particles = cloud.spawn.particles) != null) {
                    ParticleHelper.sendBatches(entity, particles);
                }
            });
        }
    }

    public static void applyEntityPlacement(class_1297 entity, class_1309 target, class_243 initialPosition, Spell.EntityPlacement placement) {
        class_243 position = initialPosition;
        if (placement != null) {
            if (placement.location_offset_by_look > 0.0f) {
                float yaw = target.method_36454() + placement.location_yaw_offset;
                position = position.method_1019(class_243.method_1030((float)0.0f, (float)yaw).method_1021((double)placement.location_offset_by_look));
            }
            position = position.method_1019(new class_243((double)placement.location_offset_x, (double)placement.location_offset_y, (double)placement.location_offset_z));
            if (placement.force_onto_ground) {
                class_243 groundPosBelow;
                class_243 searchPosition = position;
                class_2338 blockPos = class_2338.method_49637((double)searchPosition.method_10216(), (double)searchPosition.method_10214(), (double)searchPosition.method_10215());
                if (target.method_37908().method_8320(blockPos).method_51367()) {
                    searchPosition = searchPosition.method_1031(0.0, 2.0, 0.0);
                }
                class_243 class_2432 = position = (groundPosBelow = TargetHelper.findSolidBlockBelow(target, searchPosition, target.method_37908(), -20.0f)) != null ? groundPosBelow : position;
            }
            if (placement.apply_yaw) {
                entity.method_36456(target.method_36454());
            }
            if (placement.apply_pitch) {
                entity.method_36457(target.method_36455());
            }
            position = position.method_1019(new class_243((double)placement.location_offset_x, (double)placement.location_offset_y, (double)placement.location_offset_z));
        }
        entity.method_5814(position.method_10216(), position.method_10214(), position.method_10215());
    }

    public static TargetHelper.TargetingMode selectionTargetingMode(Spell spell) {
        switch (spell.release.target.type) {
            case AREA: 
            case BEAM: {
                return TargetHelper.TargetingMode.AREA;
            }
            case CLOUD: 
            case CURSOR: 
            case PROJECTILE: 
            case METEOR: 
            case SELF: 
            case SHOOT_ARROW: {
                return TargetHelper.TargetingMode.DIRECT;
            }
        }
        return null;
    }

    public static TargetHelper.TargetingMode impactTargetingMode(Spell spell) {
        switch (spell.release.target.type) {
            case AREA: 
            case BEAM: 
            case METEOR: {
                return TargetHelper.TargetingMode.AREA;
            }
            case CLOUD: 
            case CURSOR: 
            case PROJECTILE: 
            case SELF: 
            case SHOOT_ARROW: {
                return TargetHelper.TargetingMode.DIRECT;
            }
        }
        return null;
    }

    public static EnumSet<TargetHelper.Intent> intents(Spell spell) {
        HashSet<TargetHelper.Intent> intents = new HashSet<TargetHelper.Intent>();
        for (Spell.Impact impact : spell.impact) {
            intents.add(SpellHelper.intent(impact.action));
        }
        return EnumSet.copyOf(intents);
    }

    public static TargetHelper.Intent intent(Spell.Impact.Action action) {
        switch (action.type) {
            case DAMAGE: 
            case FIRE: {
                return TargetHelper.Intent.HARMFUL;
            }
            case HEAL: 
            case SPAWN: {
                return TargetHelper.Intent.HELPFUL;
            }
            case STATUS_EFFECT: {
                Spell.Impact.Action.StatusEffect data = action.status_effect;
                class_2960 id = class_2960.method_60654((String)data.effect_id);
                class_1291 effect = (class_1291)class_7923.field_41174.method_10223(id);
                return effect.method_5573() ? TargetHelper.Intent.HELPFUL : TargetHelper.Intent.HARMFUL;
            }
            case TELEPORT: {
                return action.teleport.intent;
            }
        }
        return null;
    }

    public static boolean underApplyLimit(SpellPower.Result spellPower, class_1309 target, SpellSchool school, Spell.Impact.Action.StatusEffect.ApplyLimit limit) {
        if (limit == null) {
            return true;
        }
        float power = (float)spellPower.nonCriticalValue();
        float cap = limit.health_base + power * limit.spell_power_multiplier;
        return cap >= target.method_6063();
    }

    public static EstimatedOutput estimate(Spell spell, class_1657 caster, class_1799 itemStack) {
        SpellSchool spellSchool = spell.school;
        ArrayList<EstimatedValue> damageEffects = new ArrayList<EstimatedValue>();
        ArrayList<EstimatedValue> healEffects = new ArrayList<EstimatedValue>();
        boolean forSpellBook = itemStack.method_7909() instanceof ISpellBookItem;
        boolean replaceAttributes = caster.method_6047() != itemStack && !forSpellBook;
        Multimap<class_6880<class_1320>, class_1322> heldAttributes = AttributeModifierHelper.modifierMultimap(caster.method_6047());
        Multimap<class_6880<class_1320>, class_1322> itemAttributes = AttributeModifierHelper.modifierMultimap(itemStack);
        if (replaceAttributes) {
            caster.method_6127().method_59935(heldAttributes);
            caster.method_6127().method_59932(itemAttributes);
        }
        block4: for (Spell.Impact impact : spell.impact) {
            SpellSchool school = impact.school != null ? impact.school : spellSchool;
            SpellPower.Result power = SpellPower.getSpellPower((SpellSchool)school, (class_1309)caster);
            if (power.baseValue() < (double)impact.action.min_power) {
                power = new SpellPower.Result(power.school(), (double)impact.action.min_power, power.criticalChance(), power.criticalDamage());
            }
            switch (impact.action.type) {
                case DAMAGE: {
                    Spell.Impact.Action.Damage damageData = impact.action.damage;
                    EstimatedValue damage = new EstimatedValue(power.nonCriticalValue(), power.forcedCriticalValue()).multiply(damageData.spell_power_coefficient);
                    damageEffects.add(damage);
                    continue block4;
                }
                case HEAL: {
                    Spell.Impact.Action.Heal healData = impact.action.heal;
                    EstimatedValue healing = new EstimatedValue(power.nonCriticalValue(), power.forcedCriticalValue()).multiply(healData.spell_power_coefficient);
                    healEffects.add(healing);
                    continue block4;
                }
            }
        }
        if (replaceAttributes) {
            caster.method_6127().method_59935(itemAttributes);
            caster.method_6127().method_59932(heldAttributes);
        }
        return new EstimatedOutput(damageEffects, healEffects);
    }

    private static /* synthetic */ void lambda$performImpact$9(class_1937 world, class_1297 entity) {
        world.method_8649(entity);
    }

    private static /* synthetic */ Float lambda$performImpact$8(Spell.Impact.Modifier modifier) {
        return Float.valueOf(modifier.critical_damage_bonus);
    }

    private static /* synthetic */ Float lambda$performImpact$7(Spell.Impact.Modifier modifier) {
        return Float.valueOf(modifier.critical_chance_bonus);
    }

    private static /* synthetic */ Float lambda$performImpact$6(Spell.Impact.Modifier modifier) {
        return Float.valueOf(modifier.power_multiplier);
    }

    public record AmmoResult(boolean satisfied, class_1799 ammo) {
    }

    public record ImpactContext(float channel, float distance, @Nullable class_243 position, SpellPower.Result power, TargetHelper.TargetingMode targetingMode, int channelTickIndex) {
        public ImpactContext() {
            this(1.0f, 1.0f, null, null, TargetHelper.TargetingMode.DIRECT, 0);
        }

        public ImpactContext channeled(float multiplier) {
            return new ImpactContext(multiplier, this.distance, this.position, this.power, this.targetingMode, this.channelTickIndex);
        }

        public ImpactContext distance(float multiplier) {
            return new ImpactContext(this.channel, multiplier, this.position, this.power, this.targetingMode, this.channelTickIndex);
        }

        public ImpactContext position(class_243 position) {
            return new ImpactContext(this.channel, this.distance, position, this.power, this.targetingMode, this.channelTickIndex);
        }

        public ImpactContext power(SpellPower.Result spellPower) {
            return new ImpactContext(this.channel, this.distance, this.position, spellPower, this.targetingMode, this.channelTickIndex);
        }

        public ImpactContext target(TargetHelper.TargetingMode targetingMode) {
            return new ImpactContext(this.channel, this.distance, this.position, this.power, targetingMode, this.channelTickIndex);
        }

        public boolean hasOffset() {
            return this.position != null;
        }

        public class_243 knockbackDirection(class_243 targetPosition) {
            return targetPosition.method_1020(this.position).method_1029();
        }

        public boolean isChanneled() {
            return this.channel != 1.0f;
        }

        public float total() {
            return this.channel * this.distance;
        }
    }

    public record TargetConditionResult(boolean allowed, List<Spell.Impact.Modifier> modifiers) {
        public static final TargetConditionResult ALLOWED = new TargetConditionResult(true, List.of());
        public static final TargetConditionResult DENIED = new TargetConditionResult(false, List.of());
    }

    public record EstimatedValue(double min, double max) {
        public EstimatedValue multiply(double value) {
            return new EstimatedValue(this.min * value, this.max * value);
        }
    }

    public record EstimatedOutput(List<EstimatedValue> damage, List<EstimatedValue> heal) {
    }
}

