/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.item.SpellEngineItemTags;
import net.spell_engine.api.item.trinket.ISpellBookItem;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.compat.trinkets.TrinketsCompat;
import net.spell_engine.internals.SpellCasterItemStack;
import net.spell_power.api.SpellSchool;
import org.jetbrains.annotations.Nullable;

public class SpellContainerHelper {
    public static final Comparator<Map.Entry<class_2960, Spell>> spellSorter = (spell1, spell2) -> {
        if (((Spell)spell1.getValue()).learn.tier > ((Spell)spell2.getValue()).learn.tier) {
            return 1;
        }
        if (((Spell)spell1.getValue()).learn.tier < ((Spell)spell2.getValue()).learn.tier) {
            return -1;
        }
        return ((class_2960)spell1.getKey()).toString().compareTo(((class_2960)spell2.getKey()).toString());
    };

    public static class_2960 getPoolId(SpellContainer container) {
        if (container != null && container.pool() != null) {
            return class_2960.method_60654((String)container.pool());
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    public static SpellContainer getEquipped(class_1799 heldItemStack, class_1657 player) {
        return SpellContainerHelper.getAvailable(player);
    }

    @Deprecated(forRemoval=true)
    public static SpellContainer getEquipped(SpellContainer starterContainer, class_1657 player) {
        return SpellContainerHelper.mergedContainerSources(player);
    }

    public static SpellContainer getAvailable(class_1657 player) {
        return SpellContainerHelper.mergedContainerSources(player);
    }

    @Nullable
    public static Source getFirstSourceOfSpell(class_2960 spellId, class_1657 player) {
        List<Source> query = SpellContainerHelper.getContainerSources(player);
        for (Source source : query) {
            if (!SpellContainerHelper.contains(source.container(), spellId)) continue;
            return source;
        }
        return null;
    }

    public static List<Source> getContainerSources(class_1657 player) {
        ArrayList<Source> sources = new ArrayList<Source>();
        class_1799 heldItemStack = player.method_6047();
        SpellContainer heldContainer = SpellContainerHelper.containerFromItemStack(heldItemStack);
        if (heldContainer == null || !heldContainer.is_proxy()) {
            return List.of();
        }
        sources.add(new Source(heldItemStack, heldContainer));
        if (TrinketsCompat.isEnabled()) {
            Query trinketSources = TrinketsCompat.getSpellContainers(player);
            sources.addAll(trinketSources.spell_book());
            sources.addAll(trinketSources.others());
        }
        if (SpellEngineMod.config.spell_container_from_offhand) {
            class_1799 offhandStack = SpellEngineMod.config.spell_container_from_offhand_ignore_dual_wielding ? SpellContainerHelper.getOffhandItemStack(player) : player.method_6079();
            SpellContainerHelper.addSourceIfValid(offhandStack, sources);
        }
        if (SpellEngineMod.config.spell_container_from_equipment) {
            for (class_1799 slot : player.method_31548().field_7548) {
                SpellContainerHelper.addSourceIfValid(slot, sources);
            }
        }
        return sources;
    }

    public static SpellContainer mergedContainerSources(class_1657 player) {
        List<Source> sources = SpellContainerHelper.getContainerSources(player);
        if (sources.isEmpty()) {
            return SpellContainer.EMPTY;
        }
        SpellContainer heldContainer = sources.get(0).container();
        ArrayList<class_6880.class_6883> spells = new ArrayList<class_6880.class_6883>();
        class_2378<Spell> registry = SpellRegistry.from(player.method_37908());
        for (Source source : sources) {
            SpellContainer spellContainer = source.container();
            if (spellContainer.content() != heldContainer.content()) continue;
            for (String idString : spellContainer.spell_ids()) {
                class_2960 id = class_2960.method_60654((String)idString);
                class_6880.class_6883 spell = registry.method_55841(id).orElse(null);
                if (spell == null) continue;
                spells.add(spell);
            }
        }
        LinkedHashSet<String> spellIds = new LinkedHashSet<String>();
        for (class_6880 class_68802 : spells) {
            spellIds.add(((class_5321)class_68802.method_40230().get()).method_29177().toString());
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (class_6880 class_68803 : spells) {
            Spell spell = (Spell)class_68803.comp_349();
            String tag = spell.group;
            if (tag == null) continue;
            for (class_6880 class_68804 : spells) {
                class_2960 otherId;
                class_2960 spellId = ((class_5321)class_68803.method_40230().get()).method_29177();
                if (spellId.equals((Object)(otherId = ((class_5321)class_68804.method_40230().get()).method_29177())) || !tag.equals(((Spell)class_68804.comp_349()).group)) continue;
                if (((Spell)class_68803.comp_349()).learn.tier == ((Spell)class_68804.comp_349()).learn.tier && ((Spell)class_68803.comp_349()).rank > ((Spell)class_68804.comp_349()).rank) {
                    hashSet.add(otherId.toString());
                }
                if (((Spell)class_68803.comp_349()).learn.tier <= ((Spell)class_68804.comp_349()).learn.tier) continue;
                hashSet.add(otherId.toString());
            }
        }
        spellIds.removeAll(hashSet);
        return new SpellContainer(heldContainer.content(), heldContainer.is_proxy(), null, 0, new ArrayList<String>(spellIds));
    }

    private static void addContainerIfValid(class_1799 fromItemStack, List<SpellContainer> intoContainers) {
        SpellContainer container = SpellContainerHelper.containerFromItemStack(fromItemStack);
        if (container != null && container.isValid()) {
            intoContainers.add(container);
        }
    }

    private static void addSourceIfValid(class_1799 fromItemStack, List<Source> sources) {
        SpellContainer container = SpellContainerHelper.containerFromItemStack(fromItemStack);
        if (container != null && container.isValid()) {
            sources.add(new Source(fromItemStack, container));
        }
    }

    @Deprecated(forRemoval=true)
    private static boolean isOffhandContainerValid(class_1657 player, SpellContainer.ContentType allowedContent) {
        class_1799 offhandItemStack = SpellContainerHelper.getOffhandItemStack(player);
        SpellContainer container = SpellContainerHelper.containerFromItemStack(offhandItemStack);
        return container != null && container.isValid() && container.content() == allowedContent;
    }

    @Deprecated(forRemoval=true)
    private static List<String> getOffhandSpellIds(class_1657 player) {
        class_1799 offhandItemStack = SpellContainerHelper.getOffhandItemStack(player);
        SpellContainer container = SpellContainerHelper.containerFromItemStack(offhandItemStack);
        if (container == null) {
            return Collections.emptyList();
        }
        return container.spell_ids();
    }

    private static class_1799 getOffhandItemStack(class_1657 player) {
        return (class_1799)player.method_31548().field_7544.get(0);
    }

    public static SpellContainer containerFromItemStack(class_1799 itemStack) {
        SpellCasterItemStack stack;
        SpellContainer container;
        if (itemStack.method_7960()) {
            return null;
        }
        class_1799 object = itemStack;
        if (object instanceof SpellCasterItemStack && (container = (stack = (SpellCasterItemStack)object).getSpellContainer()) != null && container.isValid()) {
            return container;
        }
        return null;
    }

    public static boolean contains(SpellContainer container, class_2960 spellId) {
        return container != null && container.spell_ids().contains(spellId.toString());
    }

    public static void addContainerToItemStack(SpellContainer container, class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return;
        }
        itemStack.method_57379(SpellDataComponents.SPELL_CONTAINER, (Object)container);
    }

    @Nullable
    public static class_2960 spellId(SpellContainer container, int selectedIndex) {
        if (container == null || !container.isUsable()) {
            return null;
        }
        return class_2960.method_60654((String)container.spellId(selectedIndex));
    }

    public static SpellContainer addSpell(class_1937 world, class_2960 spellId, SpellContainer container) {
        ArrayList<String> spellIds = new ArrayList<String>(container.spell_ids());
        spellIds.add(spellId.toString());
        HashMap<class_2960, Spell> spells = new HashMap<class_2960, Spell>();
        for (String idString : spellIds) {
            class_2960 id = class_2960.method_60654((String)idString);
            class_6880.class_6883 spellEntry = SpellRegistry.from(world).method_55841(id).orElse(null);
            if (spellEntry == null) continue;
            spells.put(id, (Spell)spellEntry.comp_349());
        }
        List<String> sortedSpellIds = spells.entrySet().stream().sorted(spellSorter).map(entry -> ((class_2960)entry.getKey()).toString()).collect(Collectors.toList());
        return container.copyWith(sortedSpellIds);
    }

    public static void addSpell(class_1937 world, class_2960 spellId, class_1799 itemStack) {
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        if (container == null || !container.isValid()) {
            System.err.println("Trying to add spell: " + String.valueOf(spellId) + " to an ItemStack without valid spell container");
            return;
        }
        SpellContainer modifiedContainer = SpellContainerHelper.addSpell(world, spellId, container);
        itemStack.method_57379(SpellDataComponents.SPELL_CONTAINER, (Object)modifiedContainer);
    }

    public static boolean hasValidContainer(class_1799 itemStack) {
        return SpellContainerHelper.containerFromItemStack(itemStack) != null;
    }

    public static boolean hasBindableContainer(class_1799 itemStack) {
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        return container != null && container.pool() != null && !container.pool().isEmpty();
    }

    public static boolean hasUsableContainer(class_1799 itemStack) {
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        return container != null && (container.isUsable() || container.is_proxy());
    }

    public static boolean isSpellValidForItem(class_1792 item, class_6880<Spell> spell) {
        SpellContainer.ContentType spellType = ((Spell)spell.comp_349()).school.archetype == SpellSchool.Archetype.ARCHERY ? SpellContainer.ContentType.ARCHERY : SpellContainer.ContentType.MAGIC;
        SpellContainer.ContentType expectedContentType = item instanceof class_1811 ? SpellContainer.ContentType.ARCHERY : SpellContainer.ContentType.MAGIC;
        return spellType == expectedContentType;
    }

    public static SpellContainer.ContentType contentTypeForItem(Spell spell) {
        return spell.school.archetype == SpellSchool.Archetype.ARCHERY ? SpellContainer.ContentType.ARCHERY : SpellContainer.ContentType.MAGIC;
    }

    public static SpellContainer create(class_6880<Spell> spell, class_1792 item) {
        return SpellContainerHelper.create(List.of(spell), item);
    }

    public static SpellContainer create(List<class_6880<Spell>> spells, class_1792 item) {
        SpellContainer.ContentType contentType = SpellContainerHelper.contentTypeForItem((Spell)spells.get(0).comp_349());
        boolean isProxy = !ISpellBookItem.isSpellBook(item) && !item.method_40131().method_40220(SpellEngineItemTags.SPELL_BOOK_MERGEABLE);
        List<String> spellIds = spells.stream().filter(entry -> SpellContainerHelper.contentTypeForItem((Spell)entry.comp_349()) == contentType).map(entry -> ((class_5321)entry.method_40230().get()).method_29177().toString()).toList();
        return new SpellContainer(contentType, isProxy, "", spellIds.size(), spellIds);
    }

    public record Source(class_1799 itemStack, SpellContainer container) {
    }

    public record Query(List<Source> spell_book, List<Source> others) {
        public static final Query EMPTY = new Query(List.of(), List.of());
    }
}

