/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.compat.trinkets;

import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.spell_engine.api.item.trinket.ISpellBookItem;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_engine.internals.SpellContainerHelper;

public class TrinketsCompat {
    private static boolean intialized = false;
    private static boolean enabled = false;

    public static void init() {
        if (intialized) {
            return;
        }
        enabled = FabricLoader.getInstance().isModLoaded("trinkets");
        if (enabled) {
            TrinketsApi.registerTrinketPredicate((class_2960)class_2960.method_60655((String)"spell_engine", (String)"spell_book"), (itemStack, slotReference, livingEntity) -> {
                if (ISpellBookItem.isSpellBook(itemStack.method_7909())) {
                    return TriState.TRUE;
                }
                return TriState.DEFAULT;
            });
        }
        intialized = true;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static List<SpellContainer> getEquippedSpells(class_1657 player) {
        if (!enabled) {
            return Collections.emptyList();
        }
        Optional component = TrinketsApi.getTrinketComponent((class_1309)player);
        if (component.isEmpty()) {
            return Collections.emptyList();
        }
        TrinketComponent trinketComponent = (TrinketComponent)component.get();
        LinkedHashSet<class_1799> items = new LinkedHashSet<class_1799>();
        TrinketInventory spellBookSlot = (TrinketInventory)((Map)trinketComponent.getInventory().get("spell")).get("book");
        items.add(spellBookSlot.method_5438(0));
        trinketComponent.getAllEquipped().forEach(pair -> {
            if (((SlotReference)pair.method_15442()).getId().contains("spell/book")) {
                return;
            }
            items.add((class_1799)pair.method_15441());
        });
        ArrayList<SpellContainer> containers = new ArrayList<SpellContainer>();
        for (class_1799 stack : items) {
            SpellContainer container;
            if (stack.method_7960() || (container = SpellContainerHelper.containerFromItemStack(stack)) == null || !container.isValid()) continue;
            containers.add(container);
        }
        return containers;
    }

    public static SpellContainerHelper.Query getSpellContainers(class_1657 player) {
        if (!enabled) {
            return SpellContainerHelper.Query.EMPTY;
        }
        Optional component = TrinketsApi.getTrinketComponent((class_1309)player);
        if (component.isEmpty()) {
            return SpellContainerHelper.Query.EMPTY;
        }
        ArrayList<SpellContainerHelper.Source> spellBooks = new ArrayList<SpellContainerHelper.Source>();
        ArrayList<SpellContainerHelper.Source> others = new ArrayList<SpellContainerHelper.Source>();
        TrinketComponent trinketComponent = (TrinketComponent)component.get();
        trinketComponent.getAllEquipped().forEach(pair -> {
            class_1799 stack = (class_1799)pair.method_15441();
            if (stack.method_7960()) {
                return;
            }
            SpellContainer container = SpellContainerHelper.containerFromItemStack(stack);
            if (container != null && container.isValid()) {
                if (((SlotReference)pair.method_15442()).getId().contains("spell/book")) {
                    spellBooks.add(new SpellContainerHelper.Source(stack, container));
                } else {
                    others.add(new SpellContainerHelper.Source(stack, container));
                }
            }
        });
        return new SpellContainerHelper.Query(spellBooks, others);
    }

    public static class_1799 getSpellBookStack(class_1657 player) {
        if (!enabled) {
            return class_1799.field_8037;
        }
        Optional component = TrinketsApi.getTrinketComponent((class_1309)player);
        if (component.isEmpty()) {
            return class_1799.field_8037;
        }
        return ((TrinketInventory)((Map)((TrinketComponent)component.get()).getInventory().get("spell")).get("book")).method_5438(0);
    }
}

