/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.util;

public record Color(float red, float green, float blue, float alpha) {
    public static final Color RED = new Color(1.0f, 0.0f, 0.0f);
    public static final Color GREEN = new Color(1.0f, 0.0f, 0.0f);
    public static final Color BLUE = new Color(1.0f, 0.0f, 0.0f);
    public static final Color WHITE = new Color(1.0f, 1.0f, 1.0f);
    public static final Color HOLY = Color.from(0xFFFFCC);
    public static final Color NATURE = Color.from(0x66FF66);
    public static final Color FROST = Color.from(0x66CCFF);
    public static final Color ELECTRIC = Color.from(0xFFFF66);
    public static final Color RAGE = Color.from(12533824);

    public Color(float red, float green, float blue) {
        this(red, green, blue, 1.0f);
    }

    public static Color from(int rgb) {
        float red = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float green = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float blue = (float)(rgb & 0xFF) / 255.0f;
        return new Color(red, green, blue);
    }

    public IntFormat toIntFormat() {
        return new IntFormat((int)(this.red * 255.0f), (int)(this.green * 255.0f), (int)(this.blue * 255.0f), (int)(this.alpha * 255.0f));
    }

    public ByteFormat toByteFormat() {
        return new ByteFormat((byte)(this.red * 255.0f), (byte)(this.green * 255.0f), (byte)(this.blue * 255.0f), (byte)(this.alpha * 255.0f));
    }

    public record IntFormat(int red, int green, int blue, int alpha) {
        public static IntFormat fromLongRGBA(long rgba) {
            long red = rgba >> 24 & 0xFFL;
            long green = rgba >> 16 & 0xFFL;
            long blue = rgba >> 8 & 0xFFL;
            long alpha = rgba & 0xFFL;
            return new IntFormat((int)red, (int)green, (int)blue, (int)alpha);
        }
    }

    public record ByteFormat(byte red, byte green, byte blue, byte alpha) {
    }
}

