/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.gui;

import com.ibm.icu.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.mixin.client.keybinding.KeyBindingAccessor;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.item.SpellEngineItemTags;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.client.input.Keybindings;
import net.spell_engine.config.ClientConfig;
import net.spell_engine.config.ServerConfig;
import net.spell_engine.internals.SpellCasterItemStack;
import net.spell_engine.internals.SpellHelper;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;

public class SpellTooltip {
    private static final String damageToken = "damage";
    private static final String healToken = "heal";
    private static final String rangeToken = "range";
    private static final String durationToken = "duration";
    private static final String itemToken = "item";
    private static final String effectDurationToken = "effect_duration";
    private static final String effectAmplifierToken = "effect_amplifier";
    private static final String impactRangeToken = "impact_range";
    private static final String teleportDistanceToken = "teleport_distance";
    private static final Map<class_2960, DescriptionMutator> descriptionMutators = new HashMap<class_2960, DescriptionMutator>();

    public static String placeholder(String token) {
        return "{" + token + "}";
    }

    public static void addSpellLines(class_1799 itemStack, class_1836 tooltipType, List<class_2561> lines) {
        SpellCasterItemStack stack;
        SpellContainer container;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        ClientConfig config = SpellEngineClient.config;
        ArrayList<Object> spellEntry = new ArrayList<Object>();
        class_1799 class_17992 = itemStack;
        if (class_17992 instanceof SpellCasterItemStack && (container = (stack = (SpellCasterItemStack)class_17992).getSpellContainer()) != null && container.isValid()) {
            boolean showListHeader;
            if (container.is_proxy() && config.showSpellBookSuppportTooltip) {
                switch (container.content()) {
                    case MAGIC: {
                        spellEntry.add(class_2561.method_43471((String)"spell.tooltip.host.proxy.spell").method_27692(class_124.field_1080));
                        break;
                    }
                    case ARCHERY: {
                        spellEntry.add(class_2561.method_43471((String)"spell.tooltip.host.proxy.arrow").method_27692(class_124.field_1080));
                    }
                }
            }
            boolean bl = showListHeader = !itemStack.method_31573(SpellEngineItemTags.SPELL_BOOK_MERGEABLE);
            if (!container.spell_ids().isEmpty() && showListHeader) {
                if (container.pool() == null) {
                    spellEntry.add(class_2561.method_43471((String)(container.is_proxy() ? "spell.tooltip.host.additional" : "spell.tooltip.host.pre_loaded")).method_27692(class_124.field_1080));
                } else {
                    String limit = "";
                    if (container.max_spell_count() > 0) {
                        limit = class_1074.method_4662((String)"spell.tooltip.host.limit", (Object[])new Object[0]).replace(SpellTooltip.placeholder("current"), "" + container.spell_ids().size()).replace(SpellTooltip.placeholder("max"), "" + container.max_spell_count());
                    }
                    String key = "spell.tooltip.host.list.spell";
                    switch (container.content()) {
                        case MAGIC: {
                            key = "spell.tooltip.host.list.spell";
                            break;
                        }
                        case ARCHERY: {
                            key = "spell.tooltip.host.list.arrow";
                        }
                    }
                    spellEntry.add(class_2561.method_43471((String)key).method_10852((class_2561)class_2561.method_43470((String)(" " + limit))).method_27692(class_124.field_1080));
                }
            }
            class_304 keybinding = Keybindings.bypass_spell_hotbar;
            boolean showDetails = config.alwaysShowFullTooltip || !keybinding.method_1415() && class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)((KeyBindingAccessor)keybinding).fabric_getBoundKey().method_1444());
            for (int i = 0; i < container.spell_ids().size(); ++i) {
                class_2960 spellId = class_2960.method_60654((String)container.spell_ids().get(i));
                List<class_2561> info = SpellTooltip.spellEntry(spellId, (class_1657)player, itemStack, showDetails, showListHeader);
                if (info.isEmpty()) continue;
                if (i > 0 && showDetails) {
                    spellEntry.add(class_2561.method_43470((String)" "));
                }
                spellEntry.addAll(info);
            }
            if (!showDetails) {
                if (!keybinding.method_1415() && container.spell_ids().size() > 0) {
                    spellEntry.add(class_2561.method_43469((String)"spell.tooltip.hold_for_details", (Object[])new Object[]{keybinding.method_16007()}).method_27692(class_124.field_1080));
                }
                if (config.showSpellBindingTooltip && container.pool() != null && !container.pool().isEmpty() && container.spell_ids().isEmpty()) {
                    spellEntry.add(class_2561.method_43471((String)"spell.tooltip.spell_binding_tip").method_27692(class_124.field_1080));
                }
            }
        }
        if (spellEntry.isEmpty()) {
            return;
        }
        int found = 0;
        if (tooltipType.method_8035()) {
            class_2583 searchedStyle = class_2561.method_43470((String)"x").method_27692(class_124.field_1063).method_10866();
            int reverseIndex = lines.size();
            for (class_2561 line : lines.reversed()) {
                --reverseIndex;
                class_2583 style = line.method_10866();
                if (style == null) continue;
                boolean newFind = searchedStyle.method_10973().equals((Object)style.method_10973());
                if (found != 0 && !newFind) break;
                found = reverseIndex;
            }
        }
        if (found <= 0) {
            lines.addAll(spellEntry);
        } else {
            lines.addAll(found, spellEntry);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static List<class_2561> spellEntry(class_2960 spellId, class_1657 player, class_1799 itemStack, boolean details, boolean indented) {
        class_1792 item;
        float f;
        DescriptionMutator mutator;
        String group;
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return lines;
        }
        Optional spellEntry = SpellRegistry.from((class_1937)world).method_55841(spellId);
        if (spellEntry.isEmpty()) {
            return lines;
        }
        Spell spell = (Spell)((class_6880.class_6883)spellEntry.get()).comp_349();
        SpellPower.Result primaryPower = SpellPower.getSpellPower((SpellSchool)spell.school, (class_1309)player);
        class_5250 name = class_2561.method_43471((String)SpellTooltip.spellTranslationKey(spellId)).method_27692(class_124.field_1067).method_27692(class_124.field_1080);
        if (spell.group != null && !(group = SpellTooltip.spellGroup(spell.group)).isEmpty()) {
            name.method_10852((class_2561)class_2561.method_43470((String)(" " + group))).method_27692(class_124.field_1080);
        }
        lines.add((class_2561)class_2561.method_43470((String)(details || !indented ? "" : " ")).method_10852((class_2561)name));
        if (!details) {
            return lines;
        }
        String description = class_1074.method_4662((String)(SpellTooltip.spellKeyPrefix(spellId) + ".description"), (Object[])new Object[0]);
        if (spell.release != null) {
            int extra_launch_count;
            void var13_17;
            Spell.ProjectileData projectile = null;
            if (spell.release.target.projectile != null) {
                projectile = spell.release.target.projectile.projectile;
            }
            if (spell.release.target.meteor != null) {
                projectile = spell.release.target.meteor.projectile;
            }
            if (projectile != null) {
                if (projectile.perks.ricochet > 0) {
                    description = description.replace(SpellTooltip.placeholder("ricochet"), SpellTooltip.formattedNumber(projectile.perks.ricochet));
                }
                if (projectile.perks.bounce > 0) {
                    description = description.replace(SpellTooltip.placeholder("bounce"), SpellTooltip.formattedNumber(projectile.perks.bounce));
                }
                if (projectile.perks.pierce > 0) {
                    description = description.replace(SpellTooltip.placeholder("pierce"), SpellTooltip.formattedNumber(projectile.perks.pierce));
                }
                if (projectile.perks.chain_reaction_size > 0) {
                    description = description.replace(SpellTooltip.placeholder("chain_reaction_size"), SpellTooltip.formattedNumber(projectile.perks.chain_reaction_size));
                }
            }
            Object var13_13 = null;
            if (spell.release.target.projectile != null) {
                Spell.LaunchProperties launchProperties = spell.release.target.projectile.launch_properties;
            }
            if (spell.release.target.meteor != null) {
                Spell.LaunchProperties launchProperties = spell.release.target.meteor.launch_properties;
            }
            if (var13_17 != null && (extra_launch_count = var13_17.extra_launch_count) > 0) {
                description = description.replace(SpellTooltip.placeholder("extra_launch"), SpellTooltip.formattedNumber(extra_launch_count));
            }
            Spell.Release.Target.Cloud cloud = spell.release.target.cloud;
            if (spell.release.target.clouds.length > 0) {
                cloud = spell.release.target.clouds[0];
            }
            if (cloud != null) {
                float cloud_duration = cloud.time_to_live_seconds;
                if (cloud_duration > 0.0f) {
                    description = description.replace(SpellTooltip.placeholder("cloud_duration"), SpellTooltip.formattedNumber(cloud_duration));
                }
                float radius = cloud.volume.combinedRadius(primaryPower);
                description = description.replace(SpellTooltip.placeholder("cloud_radius"), SpellTooltip.formattedNumber(radius));
            }
        }
        if (spell.impact != null) {
            SpellHelper.EstimatedOutput estimatedOutput = SpellHelper.estimate(spell, player, itemStack);
            block9: for (Spell.Impact impact : spell.impact) {
                switch (impact.action.type) {
                    case DAMAGE: {
                        description = SpellTooltip.replaceTokens(description, damageToken, estimatedOutput.damage());
                        continue block9;
                    }
                    case HEAL: {
                        description = SpellTooltip.replaceTokens(description, healToken, estimatedOutput.heal());
                        continue block9;
                    }
                    case STATUS_EFFECT: {
                        Spell.Impact.Action.StatusEffect statusEffect = impact.action.status_effect;
                        description = description.replace(SpellTooltip.placeholder(effectAmplifierToken), "" + (statusEffect.amplifier + 1));
                        description = description.replace(SpellTooltip.placeholder(effectDurationToken), SpellTooltip.formattedNumber(statusEffect.duration));
                        continue block9;
                    }
                    case TELEPORT: {
                        Spell.Impact.Action.Teleport teleport = impact.action.teleport;
                        switch (teleport.mode) {
                            case FORWARD: {
                                Spell.Impact.Action.Teleport.Forward forward = teleport.forward;
                                description = description.replace(SpellTooltip.placeholder(teleportDistanceToken), SpellTooltip.formattedNumber(forward.distance));
                            }
                        }
                    }
                }
            }
            Spell.AreaImpact areaImpact = spell.area_impact;
            if (areaImpact != null) {
                float radius = areaImpact.combinedRadius(primaryPower);
                description = description.replace(SpellTooltip.placeholder(impactRangeToken), SpellTooltip.formattedNumber(radius));
            }
        }
        if ((mutator = descriptionMutators.get(spellId)) != null) {
            DescriptionMutator.Args args = new DescriptionMutator.Args(description, player);
            description = mutator.mutate(args);
        }
        lines.add((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43471((String)description)).method_27692(class_124.field_1080));
        if (SpellHelper.isInstant(spell)) {
            lines.add((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43471((String)"spell.tooltip.cast_instant")).method_27692(class_124.field_1065));
        } else {
            float f2 = SpellHelper.getCastDuration((class_1309)player, spell, itemStack);
            String castTimeKey = SpellTooltip.keyWithPlural("spell.tooltip.cast_time", f2);
            String castTime = class_1074.method_4662((String)castTimeKey, (Object[])new Object[0]).replace(SpellTooltip.placeholder(durationToken), SpellTooltip.formattedNumber(f2));
            lines.add((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43470((String)castTime)).method_27692(class_124.field_1065));
        }
        if (spell.range > 0.0f || spell.range_melee) {
            void var13_27;
            if (spell.range_melee) {
                if (spell.range == 0.0f) {
                    String string = class_1074.method_4662((String)"spell.tooltip.range.melee", (Object[])new Object[0]);
                } else {
                    String key = spell.range > 0.0f ? "spell.tooltip.range.melee.plus" : "spell.tooltip.range.melee.minus";
                    String rangeKey = SpellTooltip.keyWithPlural(key, spell.range);
                    String string = class_1074.method_4662((String)rangeKey, (Object[])new Object[0]).replace(SpellTooltip.placeholder(rangeToken), SpellTooltip.formattedNumber(Math.abs(spell.range)));
                }
            } else {
                String rangeKey = SpellTooltip.keyWithPlural("spell.tooltip.range", spell.range);
                String string = class_1074.method_4662((String)rangeKey, (Object[])new Object[0]).replace(SpellTooltip.placeholder(rangeToken), SpellTooltip.formattedNumber(spell.range));
            }
            lines.add((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43470((String)var13_27)).method_27692(class_124.field_1065));
        }
        if ((f = SpellHelper.getCooldownDuration((class_1309)player, spell, itemStack)) > 0.0f) {
            String cooldown;
            if (spell.cost.cooldown_proportional) {
                cooldown = class_1074.method_4662((String)"spell.tooltip.cooldown.proportional", (Object[])new Object[0]);
            } else {
                String cooldownKey = SpellTooltip.keyWithPlural("spell.tooltip.cooldown", f);
                cooldown = class_1074.method_4662((String)cooldownKey, (Object[])new Object[0]).replace(SpellTooltip.placeholder(durationToken), SpellTooltip.formattedNumber(f));
            }
            lines.add((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43470((String)cooldown)).method_27692(class_124.field_1065));
        }
        boolean showItemCost = true;
        ServerConfig config = SpellEngineMod.config;
        if (config != null) {
            showItemCost = config.spell_cost_item_allowed;
        }
        if (showItemCost && spell.cost != null && spell.cost.item_id != null && !spell.cost.item_id.isEmpty() && (item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)spell.cost.item_id))) != class_1802.field_8162) {
            String ammoKey = SpellTooltip.keyWithPlural("spell.tooltip.ammo", 1.0f);
            String itemName = class_1074.method_4662((String)item.method_7876(), (Object[])new Object[0]);
            String ammo = class_1074.method_4662((String)ammoKey, (Object[])new Object[0]).replace(SpellTooltip.placeholder(itemToken), itemName);
            boolean hasItem = SpellHelper.ammoForSpell(player, spell, itemStack).satisfied();
            lines.add((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43470((String)ammo).method_27692(hasItem ? class_124.field_1060 : class_124.field_1061)));
        }
        return lines;
    }

    private static String replaceTokens(String text, String token, List<SpellHelper.EstimatedValue> values) {
        boolean indexTokens = values.size() > 1;
        for (int i = 0; i < values.size(); ++i) {
            SpellHelper.EstimatedValue range = values.get(i);
            String actualToken = indexTokens ? SpellTooltip.placeholder(token + "_" + (i + 1)) : SpellTooltip.placeholder(token);
            text = text.replace(actualToken, SpellTooltip.formattedRange(range.min(), range.max()));
        }
        return text;
    }

    private static String formattedRange(double min, double max) {
        if (min == max) {
            return SpellTooltip.formattedNumber((float)min);
        }
        return SpellTooltip.formattedNumber((float)min) + " - " + SpellTooltip.formattedNumber((float)max);
    }

    private static String formattedNumber(float number) {
        DecimalFormat formatter = new DecimalFormat();
        formatter.setMaximumFractionDigits(1);
        return formatter.format((double)number);
    }

    private static String keyWithPlural(String key, float value) {
        if (value != 1.0f) {
            return key + ".plural";
        }
        return key;
    }

    public static String spellTranslationKey(class_2960 spellId) {
        return SpellTooltip.spellKeyPrefix(spellId) + ".name";
    }

    public static String spellKeyPrefix(class_2960 spellId) {
        return "spell." + spellId.method_12836() + "." + spellId.method_12832();
    }

    public static String spellGroup(String group) {
        String key = "spell.group." + group;
        if (class_1074.method_4663((String)key)) {
            return class_1074.method_4662((String)key, (Object[])new Object[0]);
        }
        return "";
    }

    private static <T> T coalesce(T ... items) {
        for (T i : items) {
            if (i == null) continue;
            return i;
        }
        return null;
    }

    public static void addDescriptionMutator(class_2960 spellId, DescriptionMutator handler) {
        descriptionMutators.put(spellId, handler);
    }

    public static interface DescriptionMutator {
        public String mutate(Args var1);

        public record Args(String description, class_1657 player) {
        }
    }
}

