/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutter.world.gen.tree;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.emilsg.clutter.world.gen.type.ModFoliagePlacerTypes;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4648;
import net.minecraft.class_5819;
import net.minecraft.class_6017;

public class RedwoodFoliagePlacer
extends class_4647 {
    public static final MapCodec<RedwoodFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> RedwoodFoliagePlacer.method_30411((RecordCodecBuilder.Instance)instance).and((App)class_6017.field_33451.fieldOf("crown_height").forGetter(placer -> placer.crownHeight)).apply((Applicative)instance, RedwoodFoliagePlacer::new));
    private final class_6017 crownHeight;

    public RedwoodFoliagePlacer(class_6017 radius, class_6017 offset, class_6017 crownHeight) {
        super(radius, offset);
        this.crownHeight = crownHeight;
    }

    protected class_4648<?> method_28843() {
        return ModFoliagePlacerTypes.REDWOOD_FOLIAGE_PLACER;
    }

    protected void method_23448(class_3746 world, class_4647.class_8179 placer, class_5819 random, class_4643 config, int trunkHeight, class_4647.class_5208 treeNode, int foliageHeight, int radius, int offset) {
        class_2338 blockPos = treeNode.method_27388();
        int y = blockPos.method_10264() + offset;
        int[] radii = new int[]{1, 1, 2, 3, 1, 3, 4, 2, 4, 5, 3, 4, 5, 3, 2, 4, 3};
        int[] radii2 = new int[]{1, 1, 2, 1, 2, 3, 4, 2, 4, 5, 3, 4, 7, 4, 3, 5, 3, 2, 4, 2, 3, 5, 3, 2, 4, 2};
        this.top(trunkHeight >= 40 ? radii2 : radii, y, random, blockPos, config, placer, world);
    }

    private void top(int[] radii, int y, class_5819 random, class_2338 blockPos, class_4643 config, class_4647.class_8179 placer, class_3746 world) {
        for (int i = 0; i < radii.length; ++i) {
            int currentRadius = radii[i];
            if (i == 0) {
                placer.method_49240(blockPos, config.field_29280.method_23455(random, blockPos));
                continue;
            }
            this.generateSquareWithSporadicLeaves(world, placer, random, config, new class_2338(blockPos.method_10263(), y - i, blockPos.method_10260()), currentRadius, 0, false, 0.5f);
        }
    }

    protected final void generateSquareWithSporadicLeaves(class_3746 world, class_4647.class_8179 placer, class_5819 random, class_4643 config, class_2338 centerPos, int radius, int y, boolean giantTrunk, float leafChance) {
        this.method_23449(world, placer, random, config, centerPos, radius, y, giantTrunk);
        int trunkOffset = giantTrunk ? 1 : 0;
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        for (int xOffset = -radius; xOffset <= radius + trunkOffset; ++xOffset) {
            for (int zOffset = -radius; zOffset <= radius + trunkOffset; ++zOffset) {
                mutablePos.method_25504((class_2382)centerPos, xOffset, y - 1, zOffset);
                boolean hasPlacedBlockAbove = placer.method_49239((class_2338)mutablePos.method_10098(class_2350.field_11036));
                mutablePos.method_10098(class_2350.field_11033);
                if (!hasPlacedBlockAbove || !(random.method_43057() < leafChance)) continue;
                RedwoodFoliagePlacer.method_34359((class_3746)world, (class_4647.class_8179)placer, (class_5819)random, (class_4643)config, (class_2338)mutablePos);
                class_2350 randomDirection = class_2350.values()[random.method_43048(class_2350.values().length)];
                class_2338 targetPos = mutablePos.method_10093(randomDirection);
                RedwoodFoliagePlacer.method_34359((class_3746)world, (class_4647.class_8179)placer, (class_5819)random, (class_4643)config, (class_2338)targetPos);
            }
        }
    }

    public int method_26989(class_5819 random, int trunkHeight, class_4643 config) {
        return this.crownHeight.method_35008(random);
    }

    protected boolean method_23451(class_5819 random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        if (dx + dz >= 7) {
            return true;
        }
        return dx * dx + dz * dz > radius * radius;
    }
}

