/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutter.util;

import java.util.Optional;
import net.emilsg.clutter.block.custom.SeahorseBucketItem;
import net.emilsg.clutter.entity.variants.ButterflyVariant;
import net.emilsg.clutter.entity.variants.SeahorseVariant;
import net.emilsg.clutter.item.custom.ButterflyBottleItem;
import net.emilsg.clutter.item.custom.ClutterElytraItem;
import net.emilsg.clutter.item.custom.CoinPouchItem;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_2960;
import net.minecraft.class_5272;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class ModModelPredicateProvider {
    public static void registerModModels() {
        for (class_1792 item : class_7923.field_41178) {
            if (item instanceof ClutterElytraItem) {
                ModModelPredicateProvider.registerElytra(item);
            }
            if (item instanceof ButterflyBottleItem) {
                ModModelPredicateProvider.registerButterflyInABottle(item);
            }
            if (item instanceof SeahorseBucketItem) {
                ModModelPredicateProvider.registerSeahorseBucket(item);
            }
            if (!(item instanceof CoinPouchItem)) continue;
            ModModelPredicateProvider.registerCoinPouch(item);
        }
    }

    private static void registerElytra(class_1792 elytra) {
        class_5272.method_27879((class_1792)elytra, (class_2960)class_2960.method_60654((String)"broken"), (stack, world, entity, seed) -> {
            class_1792 patt0$temp = stack.method_7909();
            if (!(patt0$temp instanceof ClutterElytraItem)) {
                return 0.0f;
            }
            ClutterElytraItem clutterElytraItem = (ClutterElytraItem)patt0$temp;
            return clutterElytraItem.isBroken(stack) ? 1.0f : 0.0f;
        });
    }

    private static void registerButterflyInABottle(class_1792 bottle) {
        class_5272.method_27879((class_1792)bottle, (class_2960)class_2960.method_60654((String)"type"), (stack, world, entity, seed) -> {
            if (!(stack.method_7909() instanceof ButterflyBottleItem)) {
                return 0.0f;
            }
            class_9279 nbtComponent = (class_9279)stack.method_57825(class_9334.field_49610, (Object)class_9279.field_49302);
            Optional optional = nbtComponent.method_57446(ButterflyBottleItem.BUTTERFLY_VARIANT_MAP_CODEC).result();
            if (optional.isEmpty()) {
                return 0.0f;
            }
            int id = ((ButterflyVariant)((Object)((Object)optional.get()))).getId();
            return (float)id / 100.0f;
        });
    }

    private static void registerSeahorseBucket(class_1792 bucket) {
        class_5272.method_27879((class_1792)bucket, (class_2960)class_2960.method_60654((String)"type"), (stack, world, entity, seed) -> {
            if (!(stack.method_7909() instanceof SeahorseBucketItem)) {
                return 0.0f;
            }
            class_9279 nbtComponent = (class_9279)stack.method_57825(class_9334.field_49610, (Object)class_9279.field_49302);
            Optional optional = nbtComponent.method_57446(SeahorseBucketItem.SEAHORSE_VARIANT_MAP_CODEC).result();
            if (optional.isEmpty()) {
                return 0.0f;
            }
            int id = ((SeahorseVariant)((Object)((Object)optional.get()))).getId();
            return (float)id / 10.0f;
        });
    }

    private static void registerCoinPouch(class_1792 pouch) {
        class_5272.method_27879((class_1792)pouch, (class_2960)class_2960.method_60654((String)"coins"), (stack, world, entity, seed) -> {
            if (!(stack.method_7909() instanceof CoinPouchItem)) {
                return 0.0f;
            }
            class_1814 rarity = (class_1814)stack.method_57825(class_9334.field_50073, (Object)class_1814.field_8906);
            int rarityInt = CoinPouchItem.getIntFromRarity(rarity);
            return (float)(rarityInt + 1) / 10.0f;
        });
    }
}

