/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutter.entity.custom;

import java.util.UUID;
import java.util.function.Predicate;
import net.emilsg.clutter.entity.ModEntityTypes;
import net.emilsg.clutter.entity.custom.goal.SeahorseFollowParentGoal;
import net.emilsg.clutter.entity.custom.goal.SeahorseMateGoal;
import net.emilsg.clutter.entity.custom.goal.SeahorseMoveToCoralGoal;
import net.emilsg.clutter.entity.custom.goal.SeahorseReleaseChildrenGoal;
import net.emilsg.clutter.entity.custom.goal.SwimToRandomPlaceGoal;
import net.emilsg.clutter.entity.custom.parent.ClutterFishEntity;
import net.emilsg.clutter.entity.variants.SeahorseVariant;
import net.emilsg.clutter.item.ModItems;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1374;
import net.minecraft.class_1391;
import net.minecraft.class_1422;
import net.minecraft.class_1480;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5328;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class SeahorseEntity
extends ClutterFishEntity {
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(SeahorseEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> HAS_CHILDREN = class_2945.method_12791(SeahorseEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Float> HAS_CHILDREN_TIMER = class_2945.method_12791(SeahorseEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Boolean> CHILD = class_2945.method_12791(SeahorseEntity.class, (class_2941)class_2943.field_13323);
    private int ticker = 0;
    private int loveTicks;
    @Nullable
    private UUID lovingPlayer;
    protected int breedingAge;
    protected int forcedAge;
    protected int happyTicksRemaining;
    public final class_7094 swimmingAnimationState = new class_7094();
    private int swimmingAnimationTimeout = 0;
    public final class_7094 flopAnimationState = new class_7094();
    private int flopAnimationTimeout = 0;

    private void setupAnimationStates() {
        if (this.swimmingAnimationTimeout <= 0) {
            this.swimmingAnimationTimeout = 20;
            this.swimmingAnimationState.method_41322(this.field_6012);
        } else {
            --this.swimmingAnimationTimeout;
        }
        if (this.flopAnimationTimeout <= 0) {
            this.flopAnimationTimeout = 20;
            this.flopAnimationState.method_41322(this.field_6012);
        } else {
            --this.flopAnimationTimeout;
        }
    }

    public SeahorseEntity(class_1299<? extends class_1422> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_18, 0.0f);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1374((class_1314)this, 0.7));
        this.field_6201.method_6277(1, (class_1352)new SeahorseFollowParentGoal(this, 1.25));
        this.field_6201.method_6277(2, (class_1352)new SeahorseMateGoal(this, 1.0, SeahorseEntity.class));
        this.field_6201.method_6277(3, (class_1352)new SeahorseReleaseChildrenGoal(this));
        this.field_6201.method_6277(4, (class_1352)new class_1391((class_1314)this, 1.25, (Predicate)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_17498}), false));
        this.field_6201.method_6277(5, (class_1352)new SwimToRandomPlaceGoal(this, 0.5));
        this.field_6201.method_6277(6, (class_1352)new SeahorseMoveToCoralGoal(this, 0.5, 8));
    }

    public static class_5132.class_5133 setAttributes() {
        return SeahorseEntity.method_26828().method_26868(class_5134.field_23716, 2.0);
    }

    public static boolean isValidNaturalSpawn(class_1299<? extends class_1480> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos).method_26227().method_39360((class_3611)class_3612.field_15910);
    }

    public void method_35170(class_2487 nbt) {
        if (nbt.method_10545("Variant")) {
            this.setVariant(SeahorseVariant.byId(nbt.method_10550("Variant")));
        }
        super.method_35170(nbt);
    }

    public void copyDataToStack(SeahorseEntity entity, class_1799 stack) {
        stack.method_57379(class_9334.field_49631, (Object)entity.method_5797());
        class_9279.method_57452((class_9331)class_9334.field_49610, (class_1799)stack, nbtCompound -> {
            if (entity.method_5987()) {
                nbtCompound.method_10556("NoAI", entity.method_5987());
            }
            if (entity.method_5701()) {
                nbtCompound.method_10556("Silent", entity.method_5701());
            }
            if (entity.method_5740()) {
                nbtCompound.method_10556("NoGravity", entity.method_5740());
            }
            if (entity.method_5851()) {
                nbtCompound.method_10556("Glowing", entity.method_5851());
            }
            if (entity.method_5655()) {
                nbtCompound.method_10556("Invulnerable", entity.method_5655());
            }
            nbtCompound.method_10548("Health", entity.method_6032());
            nbtCompound.method_10569("Variant", entity.getTypeVariant());
        });
    }

    public void copyDataFromNbt(SeahorseEntity entity, class_2487 nbt) {
        if (nbt.method_10545("NoAI")) {
            entity.method_5977(nbt.method_10577("NoAI"));
        }
        if (nbt.method_10545("Silent")) {
            entity.method_5803(nbt.method_10577("Silent"));
        }
        if (nbt.method_10545("NoGravity")) {
            entity.method_5875(nbt.method_10577("NoGravity"));
        }
        if (nbt.method_10545("Glowing")) {
            entity.method_5834(nbt.method_10577("Glowing"));
        }
        if (nbt.method_10545("Invulnerable")) {
            entity.method_5684(nbt.method_10577("Invulnerable"));
        }
        if (nbt.method_10545("Variant")) {
            entity.setVariant(SeahorseVariant.byId(nbt.method_10550("Variant")));
        }
        if (nbt.method_10573("Health", 99)) {
            entity.method_6033(nbt.method_10583("Health"));
        }
    }

    private class_1269 tryBucket(class_1657 player, class_1268 hand, SeahorseEntity seahorse) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_7909() == class_1802.field_8705 && seahorse.method_5805()) {
            seahorse.method_5783(class_3417.field_14568, 1.0f, 1.0f);
            class_1799 bottleStack = new class_1799((class_1935)ModItems.SEAHORSE_BUCKET);
            this.copyDataToStack(seahorse, bottleStack);
            class_1799 seahorseBucketStack = class_5328.method_30270((class_1799)itemStack, (class_1657)player, (class_1799)bottleStack, (boolean)false);
            player.method_6122(hand, seahorseBucketStack);
            class_1937 world = seahorse.method_37908();
            seahorse.method_31472();
            return class_1269.method_29236((boolean)world.field_9236);
        }
        return class_1269.field_5811;
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)0);
        builder.method_56912(HAS_CHILDREN, (Object)false);
        builder.method_56912(HAS_CHILDREN_TIMER, (Object)Float.valueOf(0.0f));
        builder.method_56912(CHILD, (Object)false);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", this.getTypeVariant());
        nbt.method_10556("HasChildren", this.hasChildren());
        nbt.method_10548("HasChildrenTimer", this.getHasChildrenTimer());
        nbt.method_10569("InLove", this.loveTicks);
        if (this.lovingPlayer != null) {
            nbt.method_25927("LoveCause", this.lovingPlayer);
        }
        nbt.method_10569("Age", this.getBreedingAge());
        nbt.method_10569("ForcedAge", this.forcedAge);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(VARIANT, (Object)nbt.method_10550("Variant"));
        this.field_6011.method_12778(HAS_CHILDREN, (Object)nbt.method_10577("HasChildren"));
        this.field_6011.method_12778(HAS_CHILDREN_TIMER, (Object)Float.valueOf(nbt.method_10583("HasChildrenTimer")));
        this.loveTicks = nbt.method_10550("InLove");
        this.lovingPlayer = nbt.method_25928("LoveCause") ? nbt.method_25926("LoveCause") : null;
        this.setBreedingAge(nbt.method_10550("Age"));
        this.forcedAge = nbt.method_10550("ForcedAge");
    }

    @Nullable
    public SeahorseEntity createChild(class_3218 world, SeahorseEntity entity) {
        return (SeahorseEntity)ModEntityTypes.SEAHORSE.method_5883((class_1937)world);
    }

    public int getBreedingAge() {
        if (this.method_37908().field_9236) {
            return (Boolean)this.field_6011.method_12789(CHILD) != false ? -1 : 1;
        }
        return this.breedingAge;
    }

    public void method_5674(class_2940<?> data) {
        if (CHILD.equals(data)) {
            this.method_18382();
        }
        super.method_5674(data);
    }

    public void growUp(int age, boolean overGrow) {
        int i;
        int j = i = this.getBreedingAge();
        if ((i += age * 20) > 0) {
            i = 0;
        }
        int k = i - j;
        this.setBreedingAge(i);
        if (overGrow) {
            this.forcedAge += k;
            if (this.happyTicksRemaining == 0) {
                this.happyTicksRemaining = 40;
            }
        }
        if (this.getBreedingAge() == 0) {
            this.setBreedingAge(this.forcedAge);
        }
    }

    public void growUp(int age) {
        this.growUp(age, false);
    }

    public void setBreedingAge(int age) {
        int i = this.getBreedingAge();
        this.breedingAge = age;
        if (i < 0 && age >= 0 || i >= 0 && age < 0) {
            this.field_6011.method_12778(CHILD, (Object)(age < 0 ? 1 : 0));
            this.onGrowUp();
        }
    }

    public boolean isBreedingItem(class_1799 stack) {
        return stack.method_31574(class_1802.field_17498);
    }

    public SeahorseVariant getVariant() {
        return SeahorseVariant.byId(this.getTypeVariant() & 0xFF);
    }

    public void setVariant(SeahorseVariant variant) {
        this.field_6011.method_12778(VARIANT, (Object)(variant.getId() & 0xFF));
    }

    private int getTypeVariant() {
        return (Integer)this.field_6011.method_12789(VARIANT);
    }

    public boolean hasChildren() {
        return (Boolean)this.field_6011.method_12789(HAS_CHILDREN);
    }

    public void setHasChildren(boolean hasChildren) {
        this.field_6011.method_12778(HAS_CHILDREN, (Object)hasChildren);
    }

    protected void method_5958() {
        if (this.getBreedingAge() != 0) {
            this.loveTicks = 0;
        }
        super.method_5958();
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (this.isBreedingItem(itemStack)) {
            int i = this.getBreedingAge();
            if (!this.method_37908().field_9236 && i == 0 && this.canEat()) {
                this.eat(player, hand, itemStack);
                this.lovePlayer(player);
                return class_1269.field_5812;
            }
            if (this.method_6109()) {
                this.eat(player, hand, itemStack);
                this.growUp(SeahorseEntity.toGrowUpAge(-i), true);
                return class_1269.method_29236((boolean)this.method_37908().field_9236);
            }
            if (this.method_37908().field_9236) {
                return class_1269.field_21466;
            }
        }
        return this.tryBucket(player, hand, this);
    }

    protected void eat(class_1657 player, class_1268 hand, class_1799 stack) {
        if (!player.method_31549().field_7477) {
            stack.method_7934(1);
        }
    }

    public boolean canEat() {
        return this.loveTicks <= 0;
    }

    public void lovePlayer(@Nullable class_1657 player) {
        this.loveTicks = 600;
        if (player != null) {
            this.lovingPlayer = player.method_5667();
        }
        this.method_37908().method_8421((class_1297)this, (byte)18);
    }

    public void setLoveTicks(int loveTicks) {
        this.loveTicks = loveTicks;
    }

    public int getLoveTicks() {
        return this.loveTicks;
    }

    @Nullable
    public class_3222 getLovingPlayer() {
        if (this.lovingPlayer == null) {
            return null;
        }
        class_1657 playerEntity = this.method_37908().method_18470(this.lovingPlayer);
        return playerEntity instanceof class_3222 ? (class_3222)playerEntity : null;
    }

    public boolean isInLove() {
        return this.getLoveTicks() > 0;
    }

    public void resetLoveTicks() {
        this.setLoveTicks(0);
    }

    public boolean canBreedWith(SeahorseEntity other) {
        if (other == this) {
            return false;
        }
        if (((Object)((Object)other)).getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        return this.isInLove() && other.isInLove();
    }

    public void breed(class_3218 world, SeahorseEntity other) {
        this.breed(world, other, null);
    }

    public void breed(class_3218 world, SeahorseEntity other, @Nullable SeahorseEntity baby) {
        this.setBreedingAge(6000);
        other.setBreedingAge(6000);
        this.setHasChildren(true);
        this.resetLoveTicks();
        other.resetLoveTicks();
        world.method_8421((class_1297)this, (byte)18);
        if (world.method_8450().method_8355(class_1928.field_19391)) {
            world.method_8649((class_1297)new class_1303((class_1937)world, this.method_23317(), this.method_23318(), this.method_23321(), this.method_59922().method_43048(7) + 1));
        }
    }

    public void method_5711(byte status) {
        if (status == 18) {
            for (int i = 0; i < 7; ++i) {
                double d = this.field_5974.method_43059() * 0.02;
                double e = this.field_5974.method_43059() * 0.02;
                double f = this.field_5974.method_43059() * 0.02;
                this.method_37908().method_8406((class_2394)class_2398.field_11201, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d, e, f);
            }
        } else {
            super.method_5711(status);
        }
    }

    public float getHasChildrenTimer() {
        return ((Float)this.field_6011.method_12789(HAS_CHILDREN_TIMER)).floatValue();
    }

    public void setHasChildrenTimer(float hasChildrenTimer) {
        this.field_6011.method_12778(HAS_CHILDREN_TIMER, (Object)Float.valueOf(hasChildrenTimer));
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        class_1296.class_4697 passiveData;
        if (entityData == null) {
            entityData = new class_1296.class_4697(true);
        }
        if ((passiveData = (class_1296.class_4697)entityData).method_22436() && passiveData.method_22432() > 0 && world.method_8409().method_43057() <= passiveData.method_22437()) {
            this.setBreedingAge(-24000);
        }
        passiveData.method_22435();
        SeahorseVariant variant = (SeahorseVariant)((Object)class_156.method_27173((Object[])SeahorseVariant.values(), (class_5819)this.field_5974));
        this.setVariant(variant);
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public void method_5773() {
        super.method_5773();
        class_1937 world = this.method_37908();
        if (!world.field_9236) {
            ++this.ticker;
            if (this.hasChildren() && this.ticker == 120) {
                this.setHasChildrenTimer(this.getHasChildrenTimer() + 0.2f);
                this.ticker = 0;
            }
        }
        if (world.field_9236) {
            this.setupAnimationStates();
        }
    }

    @Override
    public void method_6007() {
        if (!this.method_5799() && this.method_24828() && this.field_5992) {
            this.method_18799(this.method_18798().method_1031((double)((this.field_5974.method_43057() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.field_5974.method_43057() * 2.0f - 1.0f) * 0.05f)));
            this.method_24830(false);
            this.field_6007 = true;
            this.method_5783(this.method_6457(), this.method_6107(), this.method_6017());
        }
        if (this.getBreedingAge() != 0) {
            this.loveTicks = 0;
        }
        if (this.loveTicks > 0) {
            --this.loveTicks;
            if (this.loveTicks % 10 == 0) {
                double d = this.field_5974.method_43059() * 0.02;
                double e = this.field_5974.method_43059() * 0.02;
                double f = this.field_5974.method_43059() * 0.02;
                this.method_37908().method_8406((class_2394)class_2398.field_11201, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d, e, f);
            }
        }
        if (this.method_37908().field_9236) {
            if (this.happyTicksRemaining > 0) {
                if (this.happyTicksRemaining % 4 == 0) {
                    this.method_37908().method_8406((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), 0.0, 0.0, 0.0);
                }
                --this.happyTicksRemaining;
            }
        } else if (this.method_5805()) {
            int i = this.getBreedingAge();
            if (i < 0) {
                this.setBreedingAge(++i);
            } else if (i > 0) {
                this.setBreedingAge(--i);
            }
        }
        super.method_6007();
    }

    protected void onGrowUp() {
        class_1690 boatEntity;
        class_1297 var2;
        if (!this.method_6109() && this.method_5765() && (var2 = this.method_5854()) instanceof class_1690 && !(boatEntity = (class_1690)var2).method_49182((class_1297)this)) {
            this.method_5848();
        }
    }

    public boolean method_17326() {
        return super.method_17326() || this.method_6453();
    }

    public boolean method_5974(double distanceSquared) {
        return !this.method_6453() && !this.method_16914();
    }

    public class_3414 method_35171() {
        return class_3417.field_14568;
    }

    public boolean method_6109() {
        return this.getBreedingAge() < 0;
    }

    public void method_7217(boolean baby) {
        this.setBreedingAge(baby ? -24000 : 0);
    }

    public static int toGrowUpAge(int breedingAge) {
        return (int)((float)(breedingAge / 20) * 0.1f);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        this.loveTicks = 0;
        return super.method_5643(source, amount);
    }

    @Override
    protected class_3414 method_6457() {
        return class_3417.field_14878;
    }

    @Override
    public class_1799 method_6452() {
        return new class_1799((class_1935)ModItems.SEAHORSE_BUCKET);
    }

    public int getMaxChildren() {
        return 3;
    }
}

