/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutter.entity.custom;

import java.util.function.Predicate;
import net.emilsg.clutter.block.ModBlocks;
import net.emilsg.clutter.entity.ModEntityTypes;
import net.emilsg.clutter.entity.custom.goal.KiwiBirdLayEggGoal;
import net.emilsg.clutter.entity.custom.goal.KiwiBirdMateGoal;
import net.emilsg.clutter.entity.custom.goal.KiwiBirdWanderAroundFarGoal;
import net.emilsg.clutter.entity.custom.parent.ClutterAnimalEntity;
import net.emilsg.clutter.sound.ModSounds;
import net.emilsg.clutter.util.ModItemTags;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Nullable;

public class KiwiBirdEntity
extends ClutterAnimalEntity {
    private static final class_1856 BREEDING_INGREDIENT = class_1856.method_8106(ModItemTags.SEEDS);
    private static final class_2940<Boolean> HAS_EGG = class_2945.method_12791(KiwiBirdEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> EGG_TIMER = class_2945.method_12791(KiwiBirdEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> IS_DANCING = class_2945.method_12791(KiwiBirdEntity.class, (class_2941)class_2943.field_13323);
    private boolean songPlaying;
    @Nullable
    private class_2338 songSource;
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 dancingAnimationState = new class_7094();
    public int idleAnimationTimeout = 0;
    public int dancingAnimationTimeout = 0;

    public KiwiBirdEntity(class_1299<? extends ClutterAnimalEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_3, -1.0f);
        this.method_5941(class_7.field_21516, -1.0f);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0 && !this.isMoving() && !this.isSongPlaying()) {
            this.idleAnimationTimeout = 30;
            this.idleAnimationState.method_41322(this.field_6012);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.dancingAnimationTimeout <= 0 && this.isSongPlaying()) {
            this.dancingAnimationTimeout = 20;
            this.dancingAnimationState.method_41322(this.field_6012);
        } else {
            --this.dancingAnimationTimeout;
        }
    }

    public static class_5132.class_5133 setAttributes() {
        return ClutterAnimalEntity.method_26828().method_26868(class_5134.field_23716, 6.0).method_26868(class_5134.field_23719, (double)0.225f).method_26868(class_5134.field_23723, 0.5).method_26868(class_5134.field_23722, (double)0.1f).method_26868(class_5134.field_23721, 2.0).method_26868(class_5134.field_23717, 16.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.25));
        this.field_6201.method_6277(2, (class_1352)new KiwiBirdMateGoal(this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new KiwiBirdLayEggGoal(this, 1.0, ModBlocks.KIWI_BIRD_EGG.method_9564()));
        this.field_6201.method_6277(4, (class_1352)new class_1391((class_1314)this, 1.1, (Predicate)BREEDING_INGREDIENT, false));
        this.field_6201.method_6277(5, (class_1352)new class_1353((class_1429)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new KiwiBirdWanderAroundFarGoal(this, (class_1314)this, 1.0, 1.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HAS_EGG, (Object)false);
        builder.method_56912(EGG_TIMER, (Object)0);
        builder.method_56912(IS_DANCING, (Object)false);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("HasEgg", this.hasEgg());
        nbt.method_10569("EggTimer", this.getEggTimer());
        nbt.method_10556("IsDancing", this.isDancing());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setHasEgg(nbt.method_10577("HasEgg"));
        this.setEggTimer(nbt.method_10550("EggTimer"));
        this.setDancing(nbt.method_10577("IsDancing"));
    }

    public void method_5773() {
        super.method_5773();
        class_1937 world = this.method_37908();
        if (world.field_9236) {
            this.setupAnimationStates();
        }
        if (this.songSource == null || !this.songSource.method_19769((class_2374)this.method_19538(), 3.46) || !this.method_37908().method_8320(this.songSource).method_27852(class_2246.field_10223)) {
            this.songPlaying = false;
            this.songSource = null;
        }
        this.setDancing(this.isSongPlaying());
    }

    @Override
    public void method_6007() {
        if (this.hasEgg()) {
            this.setEggTimer(this.getEggTimer() + 1);
        }
        super.method_6007();
    }

    public void method_6006(class_2338 songPosition, boolean playing) {
        this.songSource = songPosition;
        this.songPlaying = playing;
    }

    public boolean isSongPlaying() {
        return this.songPlaying;
    }

    public boolean method_6482() {
        return super.method_6482() && !this.hasEgg() && !this.isDancing();
    }

    @Override
    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(ModItemTags.SEEDS);
    }

    @Override
    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296)ModEntityTypes.KIWI_BIRD.method_5883((class_1937)world);
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_15077;
    }

    @Nullable
    protected class_3414 method_6002() {
        return class_3417.field_15234;
    }

    @Nullable
    protected class_3414 method_5994() {
        return ModSounds.ENTITY_KIWI_CALL;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_14602, 0.15f, 0.75f);
    }

    public boolean isDancing() {
        return (Boolean)this.field_6011.method_12789(IS_DANCING);
    }

    public void setDancing(boolean dancing) {
        this.field_6011.method_12778(IS_DANCING, (Object)dancing);
    }

    public boolean hasEgg() {
        return (Boolean)this.field_6011.method_12789(HAS_EGG);
    }

    public void setHasEgg(boolean hasEgg) {
        this.field_6011.method_12778(HAS_EGG, (Object)hasEgg);
    }

    public int getEggTimer() {
        return (Integer)this.field_6011.method_12789(EGG_TIMER);
    }

    public void setEggTimer(int time) {
        this.field_6011.method_12778(EGG_TIMER, (Object)time);
    }
}

