/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutter.entity.custom;

import java.util.Objects;
import net.emilsg.clutter.entity.custom.goal.EchofinConditionalActiveTargetGoal;
import net.emilsg.clutter.entity.custom.goal.EchofinWanderAroundGoal;
import net.emilsg.clutter.entity.custom.parent.ClutterAnimalEntity;
import net.emilsg.clutter.entity.variants.EchofinVariant;
import net.emilsg.clutter.item.ModItems;
import net.emilsg.clutter.util.ModBlockTags;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1331;
import net.minecraft.class_1333;
import net.minecraft.class_1341;
import net.minecraft.class_1352;
import net.minecraft.class_1366;
import net.minecraft.class_1374;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Nullable;

public class EchofinEntity
extends ClutterAnimalEntity {
    private static final class_2940<class_2338> HOME_POS = class_2945.method_12791(EchofinEntity.class, (class_2941)class_2943.field_13324);
    private static final class_2940<Integer> DATA_ID_TYPE_VARIANT = class_2945.method_12791(EchofinEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> ABILITY_TIMER = class_2945.method_12791(EchofinEntity.class, (class_2941)class_2943.field_13327);
    final int maxAbilityTimer = 2400;
    public final class_7094 movingAnimState = new class_7094();
    private int animationTimeout = 0;

    public EchofinEntity(class_1299<? extends ClutterAnimalEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new class_1331((class_1308)this, 20, true);
        this.field_6206 = new EchofinLookControl((class_1308)this);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_4, 16.0f);
        this.method_5941(class_7.field_21516, -1.0f);
        this.method_5941(class_7.field_10, -1.0f);
    }

    public static class_5132.class_5133 setAttributes() {
        return ClutterAnimalEntity.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23721, 1.0).method_26868(class_5134.field_23720, 0.5).method_26868(class_5134.field_23719, (double)0.1f).method_26868(class_5134.field_23717, 16.0);
    }

    public static boolean isValidSpawn(class_1299<? extends ClutterAnimalEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(ModBlockTags.ECHOFINS_SPAWN_ON);
    }

    public boolean method_5974(double distanceSquared) {
        return true;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.25));
        this.field_6201.method_6277(2, (class_1352)new TeleportOrLevitateAttackGoal(this, 3.0, true));
        this.field_6201.method_6277(3, (class_1352)new EchofinWanderAroundGoal(this));
        this.field_6185.method_6277(1, (class_1352)new EchofinConditionalActiveTargetGoal(this, class_1657.class, false));
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HOME_POS, (Object)class_2338.field_10980);
        builder.method_56912(DATA_ID_TYPE_VARIANT, (Object)0);
        builder.method_56912(ABILITY_TIMER, (Object)0);
    }

    public float method_6144(class_2338 pos, class_4538 world) {
        return world.method_8320(pos).method_26215() ? 10.0f : 0.0f;
    }

    private void setupAnimationStates() {
        if (this.animationTimeout <= 0) {
            this.animationTimeout = 20;
            this.movingAnimState.method_41322(this.field_6012);
        } else {
            --this.animationTimeout;
        }
    }

    public void method_48922(class_1282 damageSource) {
        super.method_48922(damageSource);
        this.setEntityAbilityTimer(0);
    }

    public void method_5773() {
        super.method_5773();
        class_1937 world = this.method_37908();
        if (world instanceof class_3218) {
            this.setEntityAbilityTimer(this.getAbilityTimerEntitiesTimer() + this.field_5974.method_43048(3));
        }
        if (this.hasAbility() && this.field_5974.method_43048(1000) == 0) {
            this.setEntityAbilityTimer(0);
        }
        if (world.field_9236) {
            this.setupAnimationStates();
            if (this.getVariant() == EchofinVariant.CHORUS && this.field_5974.method_43056()) {
                this.method_37908().method_8466((class_2394)class_2398.field_11214, true, this.method_23317() + this.field_5974.method_43058() / 4.0 * (double)(this.field_5974.method_43056() ? 1 : -1), this.method_23318() + this.field_5974.method_43058() / 16.0 * (double)(this.field_5974.method_43056() ? 1 : -1), this.method_23321() + this.field_5974.method_43058() / 4.0 * (double)(this.field_5974.method_43056() ? 1 : -1), this.field_5974.method_43056() ? 0.1 : -0.1, this.field_5974.method_43056() ? 0.1 : -0.1, this.field_5974.method_43056() ? 0.1 : -0.1);
            }
        }
    }

    public int method_5945() {
        return 3;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 heldItem = player.method_5998(hand);
        if (!this.method_37908().field_9236 && heldItem.method_31574(class_1802.field_8550)) {
            EchofinVariant variant = this.getVariant();
            class_1792 returnItem = Objects.requireNonNull(variant) == EchofinVariant.CHORUS ? ModItems.CHORUS_ECHOFIN_BUCKET : ModItems.LEVITATING_ECHOFIN_BUCKET;
            if (player.method_5998(hand).method_7947() == 1) {
                player.method_6122(hand, new class_1799((class_1935)returnItem));
            } else {
                heldItem.method_7934(1);
                if (player.method_31548().method_7376() > 0) {
                    player.method_7270(new class_1799((class_1935)returnItem));
                } else {
                    this.method_5706((class_1935)returnItem);
                }
            }
            player.method_5783(class_3417.field_14568, 1.0f, 1.5f);
            this.method_5650(class_1297.class_5529.field_26999);
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public boolean method_5931() {
        return false;
    }

    public class_2338 getHomePos() {
        return (class_2338)this.field_6011.method_12789(HOME_POS);
    }

    public void setHomePos(class_2338 pos) {
        this.field_6011.method_12778(HOME_POS, (Object)pos);
    }

    public boolean shouldLevitatePlayers() {
        return this.hasAbility() && this.getVariant() == EchofinVariant.LEVITATING;
    }

    public boolean shouldTeleportPlayers() {
        return this.hasAbility() && this.getVariant() == EchofinVariant.CHORUS;
    }

    public boolean hasAbility() {
        return this.getAbilityTimerEntitiesTimer() >= 2400;
    }

    public int getAbilityTimerEntitiesTimer() {
        return (Integer)this.field_6011.method_12789(ABILITY_TIMER);
    }

    public void setEntityAbilityTimer(int timer) {
        this.field_6011.method_12778(ABILITY_TIMER, (Object)timer);
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
    }

    public boolean method_41330() {
        return true;
    }

    private void teleportPlayer(class_1657 player, class_1937 world) {
        for (int i = 0; i < 16; ++i) {
            double d = player.method_23317() + (player.method_59922().method_43058() - 0.5) * 512.0;
            double e = class_3532.method_15350((double)(player.method_23318() + (double)(player.method_59922().method_43048(16) - 8)), (double)world.method_31607(), (double)(world.method_31607() + ((class_3218)world).method_32819() - 1));
            double f = player.method_23321() + (player.method_59922().method_43058() - 0.5) * 512.0;
            if (player.method_5765()) {
                player.method_5848();
            }
            class_243 vec3d = player.method_19538();
            if (!player.method_6082(d, e, f, true)) continue;
            world.method_32888((class_6880)class_5712.field_39446, vec3d, class_5712.class_7397.method_43285((class_1297)player));
            class_3414 soundEvent = class_3417.field_14890;
            class_3419 soundCategory = class_3419.field_15248;
            this.setEntityAbilityTimer(0);
            world.method_54762(null, player.method_23317(), player.method_23318(), player.method_23321(), soundEvent, soundCategory);
            player.method_38785();
            break;
        }
    }

    private void levitatePlayer(class_1657 player) {
        player.method_37222(new class_1293(class_1294.field_5902, 100, 2), (class_1297)this);
    }

    protected class_1408 method_5965(class_1937 world) {
        class_1407 birdNavigation = new class_1407(this, (class_1308)this, world){

            public boolean method_6333(class_2338 pos) {
                return !this.field_6677.method_8320(pos.method_10074()).method_26215();
            }
        };
        birdNavigation.method_6332(false);
        birdNavigation.method_6354(false);
        birdNavigation.method_6331(true);
        return birdNavigation;
    }

    public boolean method_27298() {
        return false;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("HomePosX", this.getHomePos().method_10263());
        nbt.method_10569("HomePosY", this.getHomePos().method_10264());
        nbt.method_10569("HomePosZ", this.getHomePos().method_10260());
        nbt.method_10569("Variant", this.getTypeVariant());
        nbt.method_10569("AbilityTimer", this.getAbilityTimerEntitiesTimer());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        int i = nbt.method_10550("HomePosX");
        int j = nbt.method_10550("HomePosY");
        int k = nbt.method_10550("HomePosZ");
        this.setHomePos(new class_2338(i, j, k));
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)nbt.method_10550("Variant"));
        this.setEntityAbilityTimer(nbt.method_10550("AbilityTimer"));
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14628;
    }

    public boolean method_5753() {
        return this.getVariant().getId() >= 16;
    }

    @Nullable
    protected class_3414 method_6002() {
        return class_3417.field_15003;
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        EchofinVariant variant = (EchofinVariant)((Object)class_156.method_27173((Object[])EchofinVariant.values(), (class_5819)this.field_5974));
        this.setVariant(variant);
        this.setHomePos(this.method_24515());
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public void method_5725(class_2338 pos, float yaw, float pitch) {
        this.setHomePos(pos);
        super.method_5725(pos, yaw, pitch);
    }

    @Override
    public boolean method_6481(class_1799 stack) {
        return false;
    }

    @Override
    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    public EchofinVariant getVariant() {
        return EchofinVariant.byId(this.getTypeVariant() & 0xFF);
    }

    public void setVariant(EchofinVariant variant) {
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    private int getTypeVariant() {
        return (Integer)this.field_6011.method_12789(DATA_ID_TYPE_VARIANT);
    }

    private static class EchofinLookControl
    extends class_1333 {
        EchofinLookControl(class_1308 entity) {
            super(entity);
        }

        public void method_6231() {
            super.method_6231();
        }

        protected boolean method_20433() {
            return true;
        }
    }

    private static class TeleportOrLevitateAttackGoal
    extends class_1366 {
        private final EchofinEntity echofinEntity;

        public TeleportOrLevitateAttackGoal(EchofinEntity echofinEntity, double speed, boolean pauseWhenMobIdle) {
            super((class_1314)echofinEntity, speed, pauseWhenMobIdle);
            this.echofinEntity = echofinEntity;
        }

        protected void method_6288(class_1309 target) {
            class_1937 world = this.echofinEntity.method_37908();
            if (this.method_53715(target)) {
                this.method_28346();
                this.field_6503.method_6104(class_1268.field_5808);
                if (this.field_6503.method_6121((class_1297)target) && target instanceof class_1657) {
                    class_1657 player = (class_1657)target;
                    if (this.echofinEntity.shouldTeleportPlayers()) {
                        this.echofinEntity.teleportPlayer(player, world);
                    } else if (this.echofinEntity.shouldLevitatePlayers()) {
                        this.echofinEntity.levitatePlayer(player);
                    }
                }
            }
        }
    }
}

