/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.util;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.platform.ModVersion;
import com.faboslav.friendsandfoes.common.platform.Platform;
import com.faboslav.friendsandfoes.common.platform.ProjectUrlProvider;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_155;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public final class UpdateChecker {
    private static final Gson gson = new Gson();

    public static void checkForNewUpdatesInGame(class_746 clientPlayerEntity) {
        CompletableFuture.runAsync(() -> {
            if (!FriendsAndFoes.getConfig().checkForNewUpdates) {
                return;
            }
            ModuleDescriptor.Version latestVersion = UpdateChecker.getLatestVersion();
            if (latestVersion == null) {
                return;
            }
            String modVersion = ModVersion.getModVersion();
            if (modVersion == null) {
                return;
            }
            if (latestVersion.compareTo(ModuleDescriptor.Version.parse(modVersion)) <= 0) {
                return;
            }
            String updateMessageString = MessageFormat.format("Friend&Foes update is available! You are using {0} version, but the latest version is {1}. You can download it at ", modVersion, latestVersion.toString());
            class_5250 updateMessage = class_2561.method_43470((String)updateMessageString);
            class_5250 curseforgeLink = class_2561.method_43470((String)"CurseForge").method_27694(arg -> arg.method_10958(new class_2558(class_2558.class_2559.field_11749, ProjectUrlProvider.getCurseForgeProjectLink())).method_30938(Boolean.valueOf(true)));
            class_5250 updateMessageSecondPart = class_2561.method_43470((String)" or ");
            class_5250 modrinthLink = class_2561.method_43470((String)"Modrinth").method_27694(arg -> arg.method_10958(new class_2558(class_2558.class_2559.field_11749, ProjectUrlProvider.getModrinthProjectLink())).method_30938(Boolean.valueOf(true)));
            class_5250 updateMessageThirdPart = class_2561.method_43470((String)".");
            updateMessage.method_10852((class_2561)curseforgeLink).method_10852((class_2561)updateMessageSecondPart).method_10852((class_2561)modrinthLink).method_10852((class_2561)updateMessageThirdPart);
            clientPlayerEntity.method_7353((class_2561)updateMessage, false);
            FriendsAndFoes.getLogger().info("[Friends&Foes] An update is available! You are using {} version, but the latest version is {}.", (Object)modVersion, (Object)latestVersion.toString());
        });
    }

    public static void checkForNewUpdates() {
        CompletableFuture.runAsync(() -> {
            if (!FriendsAndFoes.getConfig().checkForNewUpdates) {
                return;
            }
            ModuleDescriptor.Version latestVersion = UpdateChecker.getLatestVersion();
            if (latestVersion == null) {
                return;
            }
            String modVersion = ModVersion.getModVersion();
            if (modVersion == null) {
                return;
            }
            if (latestVersion.compareTo(ModuleDescriptor.Version.parse(modVersion)) <= 0) {
                return;
            }
            FriendsAndFoes.getLogger().info("[Friends&Foes] An update is available! You are using {} version, but the latest version is {}.", (Object)modVersion, (Object)latestVersion.toString());
        });
    }

    @Nullable
    public static ModuleDescriptor.Version getLatestVersion() {
        HttpResponse<String> response;
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder(URI.create("https://api.modrinth.com/v2/project/" + Platform.getProjectSlug() + "/version")).build();
        try {
            response = client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException e) {
            return null;
        }
        if (response.statusCode() != 200) {
            return null;
        }
        HashMap<String, String> releases = new HashMap<String, String>();
        try {
            JsonArray jsonArray = (JsonArray)gson.fromJson(response.body(), JsonArray.class);
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject versionObject = jsonArray.get(i).getAsJsonObject();
                String versionNumber = versionObject.get("version_number").getAsString();
                String modVersion = versionNumber.substring(versionNumber.lastIndexOf(45) + 1);
                JsonArray gameVersions = versionObject.getAsJsonArray("game_versions");
                for (JsonElement gameVersion : gameVersions) {
                    if (releases.containsKey(gameVersion.getAsString())) continue;
                    releases.put(gameVersion.getAsString(), modVersion);
                }
            }
        }
        catch (JsonSyntaxException e) {
            return null;
        }
        String gameVersion = class_155.method_16673().method_48019();
        if (!releases.containsKey(gameVersion)) {
            return null;
        }
        return ModuleDescriptor.Version.parse((String)releases.get(gameVersion));
    }
}

