/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.coppergolem;

import com.faboslav.friendsandfoes.common.client.render.entity.animation.CopperGolemAnimations;
import com.faboslav.friendsandfoes.common.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.CopperGolemBrain;
import com.faboslav.friendsandfoes.common.entity.pose.CopperGolemEntityPose;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import java.util.Map;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4141;

public final class CopperGolemSpinHeadTask
extends class_4097<CopperGolemEntity> {
    private int spinHeadTicks = 0;
    private int maxSpinHeadTicks = 0;

    public CopperGolemSpinHeadTask() {
        super(Map.of(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_SPIN_HEAD_COOLDOWN.get(), class_4141.field_18457, FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_IS_OXIDIZED.get(), class_4141.field_18457), 40);
    }

    protected boolean shouldRun(class_3218 world, CopperGolemEntity copperGolem) {
        return !((double)copperGolem.method_59922().method_43057() < 0.9);
    }

    protected void run(class_3218 world, CopperGolemEntity copperGolem, long time) {
        this.spinHeadTicks = 0;
        this.maxSpinHeadTicks = CopperGolemAnimations.getSpinHeadKeyframeAnimation(copperGolem.getAnimationSpeedModifier()).getAnimationLengthInTicks();
        copperGolem.startSpinHeadAnimation();
    }

    protected boolean shouldKeepRunning(class_3218 world, CopperGolemEntity copperGolem, long time) {
        return this.spinHeadTicks <= this.maxSpinHeadTicks && !copperGolem.isOxidized();
    }

    protected void keepRunning(class_3218 world, CopperGolemEntity copperGolem, long time) {
        ++this.spinHeadTicks;
    }

    protected void finishRunning(class_3218 world, CopperGolemEntity copperGolem, long time) {
        copperGolem.setPose(CopperGolemEntityPose.IDLE);
        CopperGolemBrain.setSpinHeadCooldown(copperGolem);
    }
}

