/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.CopperGolemAnimations;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.KeyframeAnimation;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.animator.context.KeyframeAnimationContext;
import com.faboslav.friendsandfoes.common.entity.ai.brain.CopperGolemBrain;
import com.faboslav.friendsandfoes.common.entity.animation.AnimatedEntity;
import com.faboslav.friendsandfoes.common.entity.pose.CopperGolemEntityPose;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.common.mixin.LimbAnimatorAccessor;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.faboslav.friendsandfoes.common.util.MovementUtil;
import com.faboslav.friendsandfoes.common.util.particle.ParticleSpawner;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1333;
import net.minecraft.class_1335;
import net.minecraft.class_1427;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3730;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4208;
import net.minecraft.class_4209;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5955;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public final class CopperGolemEntity
extends class_1427
implements AnimatedEntity {
    private AnimationContextTracker animationContextTracker;
    private static final class_2940<Integer> POSE_TICKS = class_2945.method_12791(CopperGolemEntity.class, (class_2941)class_2943.field_13327);
    private static final float MOVEMENT_SPEED = 0.2f;
    private static final int COPPER_INGOT_HEAL_AMOUNT = 5;
    private static final float SPARK_CHANCE = 0.025f;
    private static final float OXIDATION_CHANCE = 2.0E-5f;
    public static final int MIN_STRUCT_BY_LIGHTNING_TICKS = 1200;
    public static final int MAX_STRUCT_BY_LIGHTNING_TICKS = 2400;
    private static final String POSE_NBT_NAME = "Pose";
    private static final String POSE_TICKS_NBT_NAME = "PoseTicks";
    private static final String OXIDATION_LEVEL_NBT_NAME = "OxidationLevel";
    private static final String IS_WAXED_NBT_NAME = "IsWaxed";
    private static final String ENTITY_SNAPSHOT_NBT_NAME = "EntitySnapshot";
    private static final class_2940<Integer> OXIDATION_LEVEL = class_2945.method_12791(CopperGolemEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> STRUCT_BY_LIGHTNING_TICKS = class_2945.method_12791(CopperGolemEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> WAS_STATUE = class_2945.method_12791(CopperGolemEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_WAXED = class_2945.method_12791(CopperGolemEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<class_2487> ENTITY_SNAPSHOT = class_2945.method_12791(CopperGolemEntity.class, (class_2941)class_2943.field_13318);

    @Override
    public AnimationContextTracker getAnimationContextTracker() {
        if (this.animationContextTracker == null) {
            this.refreshAnimationContextTracker();
        }
        return this.animationContextTracker;
    }

    private void refreshAnimationContextTracker() {
        this.animationContextTracker = new AnimationContextTracker();
        for (KeyframeAnimation keyframeAnimation : this.getAnimations()) {
            this.animationContextTracker.add(keyframeAnimation);
        }
        this.animationContextTracker.add(this.getMovementAnimation());
    }

    @Override
    public ArrayList<KeyframeAnimation> getAnimations() {
        return CopperGolemAnimations.getAnimations(this.getAnimationSpeedModifier());
    }

    @Override
    public KeyframeAnimation getMovementAnimation() {
        return CopperGolemAnimations.getWalkKeyframeAnimation(this.getAnimationSpeedModifier());
    }

    @Override
    public int getKeyframeAnimationTicks() {
        return (Integer)this.field_6011.method_12789(POSE_TICKS);
    }

    @Override
    public void setKeyframeAnimationTicks(int keyframeAnimationTicks) {
        this.field_6011.method_12778(POSE_TICKS, (Object)keyframeAnimationTicks);
    }

    public CopperGolemEntity(class_1299<? extends CopperGolemEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new CopperGolemMoveControl(this);
        this.field_6206 = new CopperGolemLookControl(this);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        class_1315 superEntityData = super.method_5943(world, difficulty, spawnReason, entityData);
        if (spawnReason == class_3730.field_16474) {
            return superEntityData;
        }
        this.setPose(CopperGolemEntityPose.IDLE);
        CopperGolemBrain.setSpinHeadCooldown(this);
        CopperGolemBrain.setPressButtonCooldown(this);
        return superEntityData;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(POSE_TICKS, (Object)0);
        builder.method_56912(OXIDATION_LEVEL, (Object)class_5955.class_5811.field_28704.ordinal());
        builder.method_56912(STRUCT_BY_LIGHTNING_TICKS, (Object)0);
        builder.method_56912(WAS_STATUE, (Object)false);
        builder.method_56912(IS_WAXED, (Object)false);
        builder.method_56912(ENTITY_SNAPSHOT, (Object)new class_2487());
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569(OXIDATION_LEVEL_NBT_NAME, this.getOxidationLevel().ordinal());
        nbt.method_10556(IS_WAXED_NBT_NAME, this.isWaxed());
        if (this.isOxidized()) {
            nbt.method_10582(POSE_NBT_NAME, this.method_18376().name());
            nbt.method_10569(POSE_TICKS_NBT_NAME, this.getKeyframeAnimationTicks());
            nbt.method_10566(ENTITY_SNAPSHOT_NBT_NAME, (class_2520)this.getEntitySnapshot());
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545(POSE_NBT_NAME)) {
            class_4050 entityPose = class_4050.valueOf((String)nbt.method_10558(POSE_NBT_NAME));
            this.method_18380(entityPose);
        }
        if (nbt.method_10545(POSE_TICKS_NBT_NAME)) {
            this.setKeyframeAnimationTicks(nbt.method_10550(POSE_TICKS_NBT_NAME));
        }
        if (nbt.method_10545(OXIDATION_LEVEL_NBT_NAME)) {
            this.setOxidationLevel(class_5955.class_5811.values()[nbt.method_10550(OXIDATION_LEVEL_NBT_NAME)]);
        }
        if (nbt.method_10545(IS_WAXED_NBT_NAME)) {
            this.setIsWaxed(nbt.method_10577(IS_WAXED_NBT_NAME));
        }
        if (nbt.method_10545(ENTITY_SNAPSHOT_NBT_NAME)) {
            this.setEntitySnapshot(nbt.method_10562(ENTITY_SNAPSHOT_NBT_NAME));
            this.applyEntitySnapshot();
        }
    }

    public static class_5132.class_5133 createCopperGolemAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, (double)0.2f).method_26868(class_5134.field_23718, 1.0);
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return CopperGolemBrain.create(dynamic);
    }

    public class_4095<CopperGolemEntity> method_18868() {
        return super.method_18868();
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    public void setEntitySnapshot(class_2487 entitySnapshot) {
        this.field_6011.method_12778(ENTITY_SNAPSHOT, (Object)entitySnapshot);
    }

    public void applyEntitySnapshot() {
        class_2487 entitySnapshot = this.getEntitySnapshot();
        if (entitySnapshot.method_33133()) {
            return;
        }
        if (!this.method_5765()) {
            this.field_6284 = entitySnapshot.method_10574("serverYaw");
            this.field_5982 = entitySnapshot.method_10583("prevYaw");
            this.method_36456(this.field_5982);
            this.field_6283 = this.field_6220 = entitySnapshot.method_10583("prevBodyYaw");
            this.field_45123 = entitySnapshot.method_10574("serverHeadYaw");
            this.field_6241 = this.field_6259 = entitySnapshot.method_10583("prevHeadYaw");
            this.field_6255 = this.field_6275 = entitySnapshot.method_10583("prevLookDirection");
        }
        this.field_6004 = entitySnapshot.method_10583("prevPitch");
        this.field_6221 = this.field_6004;
        this.method_36457(this.field_6004);
        this.field_6251 = this.field_6229 = entitySnapshot.method_10583("lastHandSwingProgress");
        ((LimbAnimatorAccessor)this.field_42108).setPrevSpeed(entitySnapshot.method_10583("limbAnimatorPrevSpeed"));
        this.field_42108.method_48567(entitySnapshot.method_10583("limbAnimatorSpeed"));
        ((LimbAnimatorAccessor)this.field_42108).setPos(entitySnapshot.method_10583("limbAnimatorPos"));
        this.field_6233 = this.field_6217 = entitySnapshot.method_10583("prevStepBobbingAmount");
    }

    public class_2487 getEntitySnapshot() {
        return (class_2487)this.field_6011.method_12789(ENTITY_SNAPSHOT);
    }

    private class_2487 takeEntitySnapshot() {
        class_2487 entitySnapshot = new class_2487();
        entitySnapshot.method_10549("serverYaw", this.field_6284);
        entitySnapshot.method_10548("prevYaw", this.field_5982);
        entitySnapshot.method_10549("serverPitch", this.field_6221);
        entitySnapshot.method_10548("prevPitch", this.field_6004);
        entitySnapshot.method_10548("prevBodyYaw", this.field_6220);
        entitySnapshot.method_10549("serverHeadYaw", this.field_45123);
        entitySnapshot.method_10548("prevHeadYaw", this.field_6259);
        entitySnapshot.method_10548("lastHandSwingProgress", this.field_6229);
        entitySnapshot.method_10548("limbAnimatorPrevSpeed", ((LimbAnimatorAccessor)this.field_42108).getPresSpeed());
        entitySnapshot.method_10548("limbAnimatorSpeed", this.field_42108.method_48566());
        entitySnapshot.method_10548("limbAnimatorPos", this.field_42108.method_48569());
        entitySnapshot.method_10548("prevLookDirection", this.field_6275);
        entitySnapshot.method_10548("prevStepBobbingAmount", this.field_6217);
        return entitySnapshot;
    }

    protected int method_6130(int air) {
        return air;
    }

    public float method_6017() {
        return (this.method_59922().method_43057() - this.method_59922().method_43057()) * 0.2f + 2.5f;
    }

    protected class_3414 method_6011(class_1282 source) {
        return FriendsAndFoesSoundEvents.ENTITY_COPPER_GOLEM_HURT.get();
    }

    protected class_3414 method_6002() {
        return FriendsAndFoesSoundEvents.ENTITY_COPPER_GOLEM_DEATH.get();
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        if (this.isImmobilized() || state.method_51176()) {
            return;
        }
        class_2680 blockState = this.method_37908().method_8320(pos.method_10084());
        class_2498 blockSoundGroup = blockState.method_26164(class_3481.field_28040) ? blockState.method_26231() : state.method_26231();
        this.method_5783(FriendsAndFoesSoundEvents.ENTITY_COPPER_GOLEM_STEP.get(), blockSoundGroup.method_10597() * 0.15f, this.method_6017());
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1297 attacker = source.method_5529();
        if (attacker instanceof class_1538 || source == this.method_48923().method_48835()) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    public class_243 method_29919() {
        return new class_243(0.0, (double)this.method_5751() * 0.45, 0.0);
    }

    public float getMovementSpeedModifier() {
        if (this.isStructByLightning()) {
            return 1.5f;
        }
        return (0.2f - (float)this.getOxidationModifier() * 0.033333335f) / 0.2f;
    }

    public float getAnimationSpeedModifier() {
        if (this.isStructByLightning()) {
            return 0.6666666f;
        }
        return 0.2f / (0.2f - (float)this.getOxidationModifier() * 0.033333335f);
    }

    private int getOxidationModifier() {
        return Math.min(this.getOxidationLevel().ordinal(), class_5955.class_5811.field_28706.ordinal());
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        class_1792 itemInHand = itemStack.method_7909();
        boolean interactionResult = false;
        if (itemInHand == class_1802.field_27022) {
            interactionResult = this.tryToInteractMobWithCopperIngot(player, itemStack);
        } else if (itemInHand == class_1802.field_20414) {
            interactionResult = this.tryToInteractMobWithHoneycomb(player, itemStack);
        } else if (itemInHand instanceof class_1743) {
            interactionResult = this.tryToInteractMobWithAxe(player, hand, itemStack);
        }
        if (interactionResult) {
            this.method_32875((class_6880)class_5712.field_28725, (class_1297)this);
            return class_1269.method_29236((boolean)this.method_37908().method_8608());
        }
        return super.method_5992(player, hand);
    }

    private boolean tryToInteractMobWithCopperIngot(class_1657 player, class_1799 itemStack) {
        if (this.method_6032() == this.method_6063()) {
            return false;
        }
        this.method_6025(5.0f);
        itemStack.method_57008(1, (class_1309)player);
        this.method_5783(FriendsAndFoesSoundEvents.ENTITY_COPPER_GOLEM_REPAIR.get(), 1.0f, this.method_6017() - 1.0f);
        return true;
    }

    private boolean tryToInteractMobWithHoneycomb(class_1657 player, class_1799 itemStack) {
        if (this.isWaxed() || this.isImmobilized()) {
            return false;
        }
        this.setIsWaxed(true);
        if (!player.method_31549().field_7477) {
            itemStack.method_7934(1);
        }
        this.method_5783(class_3417.field_29543, 1.0f, 1.0f);
        ParticleSpawner.spawnParticles((class_1309)this, (class_2394)class_2398.field_29642, 7, 1.0);
        return true;
    }

    private boolean tryToInteractMobWithAxe(class_1657 player, class_1268 hand, class_1799 itemStack) {
        if (!this.isWaxed() && !this.isDegraded() || this.wasStatue() && !this.isOxidized()) {
            return false;
        }
        if (this.isWaxed()) {
            this.setIsWaxed(false);
            this.method_5783(class_3417.field_29542, 1.0f, 1.0f);
            ParticleSpawner.spawnParticles((class_1309)this, (class_2394)class_2398.field_29643, 7, 1.0);
        } else if (this.isDegraded()) {
            if (!this.method_37908().method_8608()) {
                int increasedOxidationLevelOrdinal = this.getOxidationLevel().ordinal() - 1;
                class_5955.class_5811[] OxidationLevels = class_5955.class_5811.values();
                this.setOxidationLevel(OxidationLevels[increasedOxidationLevelOrdinal]);
            }
            this.method_5783(class_3417.field_29541, 1.0f, 1.0f);
            ParticleSpawner.spawnParticles((class_1309)this, (class_2394)class_2398.field_29645, 7, 1.0);
        }
        if (!this.method_37908().method_8608() && !player.method_31549().field_7477) {
            itemStack.method_7970(1, (class_1309)player, class_1657.method_56079((class_1268)hand));
        }
        return true;
    }

    protected void method_5958() {
        if (this.isImmobilized()) {
            super.method_5958();
            return;
        }
        this.method_37908().method_16107().method_15396("copperGolemBrain");
        this.method_18868().method_19542((class_3218)this.method_37908(), (class_1309)this);
        this.method_37908().method_16107().method_15407();
        this.method_37908().method_16107().method_15396("copperGolemActivityUpdate");
        CopperGolemBrain.updateActivities(this);
        this.method_37908().method_16107().method_15407();
        super.method_5958();
    }

    public void method_5773() {
        if (!FriendsAndFoes.getConfig().enableCopperGolem) {
            this.method_31472();
        }
        this.updateKeyframeAnimations();
        super.method_5773();
        if (this.isOxidized()) {
            this.applyEntitySnapshot();
            MovementUtil.stopMovement((class_1308)this);
            return;
        }
        if (this.isStructByLightning() && !this.method_5770().method_8608()) {
            this.setStructByLightningTicks(this.getStructByLightningTicks() - 1);
            if (this.method_59922().method_43057() < 0.025f) {
                for (int i = 0; i < 7; ++i) {
                    ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_29644, this.method_23322(0.35), this.method_23319() + 0.25, this.method_23325(0.35), 1, this.method_59922().method_43059() * 0.01, this.method_59922().method_43059() * 0.01, this.method_59922().method_43059() * 0.01, 0.1);
                }
            }
        }
        this.handleOxidationIncrease();
    }

    public boolean method_5810() {
        return !this.isImmobilized();
    }

    public void method_5800(class_3218 serverWorld, class_1538 lightning) {
        super.method_5800(serverWorld, lightning);
        this.method_20803(0);
        this.method_33572(false);
        this.method_6033(this.method_6063());
        if (this.isDegraded()) {
            ParticleSpawner.spawnParticles((class_1309)this, (class_2394)class_2398.field_29643, 7, 1.0);
        }
        if (!this.method_5770().method_8608()) {
            this.refreshStructByLightningTicks();
            if (!this.isWaxed()) {
                this.setOxidationLevel(class_5955.class_5811.field_28704);
            }
        }
    }

    private void updateKeyframeAnimations() {
        KeyframeAnimation keyframeAnimationToStart;
        if (!this.method_37908().method_8608() && !this.isOxidized()) {
            this.updateKeyframeAnimationTicks();
        }
        if ((keyframeAnimationToStart = this.getKeyframeAnimationByPose()) != null) {
            this.tryToStartKeyframeAnimation(keyframeAnimationToStart);
        }
    }

    @Override
    public void updateKeyframeAnimationTicks() {
        if (!this.isAnyKeyframeAnimationRunning()) {
            return;
        }
        this.setKeyframeAnimationTicks(this.getKeyframeAnimationTicks() - 1);
        if (!this.method_37908().method_8608() && this.wasStatue() && this.getKeyframeAnimationTicks() == 1) {
            this.setPose(CopperGolemEntityPose.IDLE);
            this.setWasStatue(false);
        }
        if (this.getKeyframeAnimationTicks() > 1) {
            return;
        }
        for (KeyframeAnimation keyframeAnimation : this.getAnimations()) {
            KeyframeAnimationContext keyframeAnimationContext;
            if (!keyframeAnimation.getAnimation().looping() || !(keyframeAnimationContext = this.getAnimationContextTracker().get(keyframeAnimation)).isRunning()) continue;
            this.setKeyframeAnimationTicks(keyframeAnimation.getAnimationLengthInTicks());
        }
    }

    @Nullable
    public KeyframeAnimation getKeyframeAnimationByPose() {
        KeyframeAnimation keyframeAnimation = null;
        if (this.isInPose(CopperGolemEntityPose.IDLE)) {
            keyframeAnimation = CopperGolemAnimations.IDLE;
        } else if (this.isInPose(CopperGolemEntityPose.SPIN_HEAD)) {
            keyframeAnimation = CopperGolemAnimations.getSpinHeadKeyframeAnimation(this.getAnimationSpeedModifier());
        } else if (this.isInPose(CopperGolemEntityPose.PRESS_BUTTON_UP)) {
            keyframeAnimation = CopperGolemAnimations.getPressButtonUpKeyframeAnimation(this.getAnimationSpeedModifier());
        } else if (this.isInPose(CopperGolemEntityPose.PRESS_BUTTON_DOWN)) {
            keyframeAnimation = CopperGolemAnimations.getPressButtonDownKeyframeAnimation(this.getAnimationSpeedModifier());
        }
        return keyframeAnimation;
    }

    public int getCurrentKeyframeAnimationTick() {
        KeyframeAnimation keyframeAnimation = this.getKeyframeAnimationByPose();
        if (keyframeAnimation == null) {
            return 0;
        }
        int totalAnimationTicks = keyframeAnimation.getAnimationLengthInTicks();
        int leftAnimationTicks = this.getKeyframeAnimationTicks();
        return totalAnimationTicks - leftAnimationTicks;
    }

    private void tryToStartKeyframeAnimation(KeyframeAnimation keyframeAnimationToStart) {
        if (this.isKeyframeAnimationRunning(keyframeAnimationToStart)) {
            return;
        }
        if (!this.method_37908().method_8608() && !this.isOxidized()) {
            this.setKeyframeAnimationTicks(keyframeAnimationToStart.getAnimationLengthInTicks());
        }
        this.startKeyframeAnimation(keyframeAnimationToStart);
    }

    private void startKeyframeAnimation(KeyframeAnimation keyframeAnimationToStart) {
        for (KeyframeAnimation keyframeAnimation : this.getAnimations()) {
            if (keyframeAnimation == keyframeAnimationToStart) continue;
            this.stopKeyframeAnimation(keyframeAnimation);
        }
        int initialTick = this.isOxidized() ? this.field_6012 - this.getCurrentKeyframeAnimationTick() : this.field_6012;
        this.startKeyframeAnimation(keyframeAnimationToStart, initialTick);
    }

    public void method_18380(class_4050 pose) {
        if (this.method_37908().method_8608()) {
            return;
        }
        super.method_18380(pose);
    }

    public void setPose(CopperGolemEntityPose pose) {
        if (this.method_37908().method_8608()) {
            return;
        }
        super.method_18380(pose.get());
    }

    public boolean isInPose(CopperGolemEntityPose pose) {
        return this.method_18376() == pose.get();
    }

    public void startSpinHeadAnimation() {
        if (this.isInPose(CopperGolemEntityPose.SPIN_HEAD)) {
            return;
        }
        this.method_5783(FriendsAndFoesSoundEvents.ENTITY_COPPER_GOLEM_HEAD_SPIN.get(), 1.0f, this.method_6017() - 1.5f);
        this.setPose(CopperGolemEntityPose.SPIN_HEAD);
    }

    public void startPressButtonUpAnimation() {
        if (this.isInPose(CopperGolemEntityPose.PRESS_BUTTON_UP)) {
            return;
        }
        this.setPose(CopperGolemEntityPose.PRESS_BUTTON_UP);
    }

    public void startPressButtonDownAnimation() {
        if (this.isInPose(CopperGolemEntityPose.PRESS_BUTTON_DOWN)) {
            return;
        }
        this.setPose(CopperGolemEntityPose.PRESS_BUTTON_DOWN);
    }

    public void handleOxidationIncrease() {
        if (this.method_5770().method_8608() || this.isImmobilized() || this.isWaxed()) {
            return;
        }
        if (this.method_59922().method_43057() < 2.0E-5f) {
            int degradedOxidationLevelOrdinal = this.getOxidationLevel().ordinal() + 1;
            class_5955.class_5811[] OxidationLevels = class_5955.class_5811.values();
            this.setOxidationLevel(OxidationLevels[degradedOxidationLevelOrdinal]);
        }
    }

    public boolean isOxidized() {
        return this.getOxidationLevel() == class_5955.class_5811.field_28707;
    }

    public boolean isDegraded() {
        return this.getOxidationLevel().ordinal() > class_5955.class_5811.field_28704.ordinal();
    }

    public class_5955.class_5811 getOxidationLevel() {
        return class_5955.class_5811.values()[(Integer)this.field_6011.method_12789(OXIDATION_LEVEL)];
    }

    public void setOxidationLevel(class_5955.class_5811 oxidationLevel) {
        this.field_6011.method_12778(OXIDATION_LEVEL, (Object)oxidationLevel.ordinal());
        this.method_5996(class_5134.field_23719).method_6192((double)(0.2f * this.getMovementSpeedModifier()));
        if (this.isOxidized()) {
            this.setWasStatue(true);
        }
        if (!this.isImmobilized()) {
            this.refreshAnimationContextTracker();
        }
        if (this.isOxidized() && this.method_18868().method_46873(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_IS_OXIDIZED.get()).isEmpty()) {
            this.method_18868().method_18878(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_IS_OXIDIZED.get(), (Object)true);
            this.becomeStatue();
        } else if (!this.isOxidized() && this.method_18868().method_46873(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_IS_OXIDIZED.get()).isPresent()) {
            this.method_18868().method_18875(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_IS_OXIDIZED.get());
            this.becomeEntity();
        }
    }

    public void setStructByLightningTicks(int structByLightningTicks) {
        this.field_6011.method_12778(STRUCT_BY_LIGHTNING_TICKS, (Object)structByLightningTicks);
    }

    public int getStructByLightningTicks() {
        return (Integer)this.field_6011.method_12789(STRUCT_BY_LIGHTNING_TICKS);
    }

    public void refreshStructByLightningTicks() {
        this.setStructByLightningTicks(this.method_59922().method_39332(1200, 2400));
    }

    public boolean isStructByLightning() {
        return this.getStructByLightningTicks() > 0;
    }

    @Nullable
    public class_4208 getButtonPos() {
        return this.method_18868().method_46873(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_BUTTON_POS.get()).orElse(null);
    }

    public boolean isButtonValidToBePressed(class_2338 pos) {
        return this.method_37908().method_8320(pos).method_26164(FriendsAndFoesTags.COPPER_BUTTONS);
    }

    private void becomeStatue() {
        class_2487 entitySnapshot = this.takeEntitySnapshot();
        this.setEntitySnapshot(entitySnapshot);
    }

    private void becomeEntity() {
        CopperGolemBrain.setSpinHeadCooldown(this);
        CopperGolemBrain.setPressButtonCooldown(this);
    }

    public boolean isWaxed() {
        return (Boolean)this.field_6011.method_12789(IS_WAXED);
    }

    public void setIsWaxed(boolean isWaxed) {
        this.field_6011.method_12778(IS_WAXED, (Object)isWaxed);
    }

    public boolean wasStatue() {
        return (Boolean)this.field_6011.method_12789(WAS_STATUE);
    }

    public void setWasStatue(boolean wasStatue) {
        this.field_6011.method_12778(WAS_STATUE, (Object)wasStatue);
    }

    public boolean isImmobilized() {
        return this.isOxidized() || this.wasStatue();
    }

    public void setSpawnYaw(float yaw) {
        this.field_6284 = yaw;
        this.field_5982 = yaw;
        this.method_36456(yaw);
        this.field_6220 = yaw;
        this.field_6283 = yaw;
        this.field_45123 = yaw;
        this.field_6259 = yaw;
        this.field_6241 = yaw;
    }

    final class CopperGolemMoveControl
    extends class_1335 {
        public CopperGolemMoveControl(CopperGolemEntity copperGolem) {
            super((class_1308)copperGolem);
        }

        public void method_6240() {
            if (CopperGolemEntity.this.isImmobilized()) {
                return;
            }
            super.method_6240();
        }
    }

    final class CopperGolemLookControl
    extends class_1333 {
        public CopperGolemLookControl(CopperGolemEntity copperGolem) {
            super((class_1308)copperGolem);
        }

        public void method_6231() {
            if (CopperGolemEntity.this.isImmobilized()) {
                return;
            }
            super.method_6231();
        }
    }
}

