/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdeserttemples.util;

import com.yungnickyoung.minecraft.betterdeserttemples.BetterDesertTemplesCommon;
import com.yungnickyoung.minecraft.betterdeserttemples.entity.IPharaohData;
import com.yungnickyoung.minecraft.betterdeserttemples.module.TagModule;
import com.yungnickyoung.minecraft.betterdeserttemples.world.state.ITempleStateCacheProvider;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1576;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3449;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9296;
import net.minecraft.class_9334;

public class PharaohUtil {
    private static final String PHARAOH_HEAD_TEXTURE = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTM1MGMwNDk5YTY4YmNkOWM3NWIyNWMxOTIzMTQzOWIxMDhkMDI3NTlmNDM1ZTMzZTRhZWU5ZWQxZGQyNDFhMiJ9fX0=";

    public static boolean isPharaoh(Object object) {
        if (!(object instanceof class_1576)) {
            return false;
        }
        class_1576 husk = (class_1576)object;
        for (class_1799 armorItem : husk.method_5661()) {
            class_9296 profile;
            if (!armorItem.method_31574(class_1802.field_8575) || (profile = (class_9296)armorItem.method_57824(class_9334.field_49617)) == null) continue;
            return profile.comp_2412().values().stream().filter(property -> property.name().equals("textures")).anyMatch(property -> property.value().equals(PHARAOH_HEAD_TEXTURE));
        }
        return false;
    }

    public static boolean isPharaoh(class_2487 mobNbt, class_5455 registryAccess) {
        if (!mobNbt.method_10558("id").equals("minecraft:husk")) {
            return false;
        }
        class_2499 armorItems = mobNbt.method_10554("ArmorItems", 10);
        if (armorItems.size() != 4) {
            return false;
        }
        class_2487 helmetTag = armorItems.method_10602(3);
        class_1799 helmetItemStack = class_1799.method_57359((class_7225.class_7874)registryAccess, (class_2487)helmetTag);
        if (!helmetItemStack.method_31574(class_1802.field_8575)) {
            return false;
        }
        class_9296 profile = (class_9296)helmetItemStack.method_57824(class_9334.field_49617);
        return profile != null && profile.comp_2412().values().stream().filter(property -> property.name().equals("textures")).anyMatch(property -> property.value().equals(PHARAOH_HEAD_TEXTURE));
    }

    public static void attachSpawnPos(class_2487 mobNbt, class_243 pos) {
        class_2499 spawnPos = new class_2499();
        spawnPos.add((Object)class_2489.method_23241((double)pos.method_10216()));
        spawnPos.add((Object)class_2489.method_23241((double)pos.method_10214()));
        spawnPos.add((Object)class_2489.method_23241((double)pos.method_10215()));
        mobNbt.method_10566("bdtOriginalSpawnPos", (class_2520)spawnPos);
    }

    public static void onKillOrDiscardPharaoh(class_1297 pharaoh, class_3218 serverLevel, class_1282 damageSource) {
        class_243 originalSpawnPos = ((IPharaohData)pharaoh).getOriginalSpawnPos();
        if (originalSpawnPos == null) {
            BetterDesertTemplesCommon.LOGGER.error("Pharaoh entity is missing original spawn position data. Attempting to clear the temple it's inside of instead...");
            PharaohUtil.tryClearTempleAtPosition(pharaoh, serverLevel, pharaoh.method_24515(), damageSource);
        } else {
            class_2338 pharaohSpawnPos = new class_2338((int)originalSpawnPos.field_1352, (int)originalSpawnPos.field_1351, (int)originalSpawnPos.field_1350);
            PharaohUtil.tryClearTempleAtPosition(pharaoh, serverLevel, pharaohSpawnPos, damageSource);
        }
    }

    private static void tryClearTempleAtPosition(class_1297 pharaoh, class_3218 serverLevel, class_2338 pos, class_1282 damageSource) {
        class_3449 structureStart = serverLevel.method_27056().method_57560(pos, TagModule.APPLIES_MINING_FATIGUE);
        if (structureStart.method_16657()) {
            class_3222 killer;
            class_1297 class_12972;
            class_2338 structureStartPos = structureStart.method_34000().method_8323();
            ((ITempleStateCacheProvider)serverLevel).getTempleStateCache().setTempleCleared(structureStartPos, true);
            List<class_3222> playersInTemple = serverLevel.method_18456().stream().filter(player -> serverLevel.method_8477(player.method_24515()) && serverLevel.method_27056().method_57560(player.method_24515(), TagModule.APPLIES_MINING_FATIGUE).method_16657()).toList();
            playersInTemple.forEach(player -> {
                player.field_13987.method_14364((class_2596)new class_2767(class_7923.field_41172.method_47983((Object)class_3417.field_19344), class_3419.field_15251, pharaoh.method_23317(), pharaoh.method_23318(), pharaoh.method_23321(), 1.0f, 1.0f, serverLevel.method_8412()));
                player.method_6016(class_1294.field_5901);
            });
            if (damageSource != null && (class_12972 = damageSource.method_5529()) instanceof class_3222 && !playersInTemple.contains(killer = (class_3222)class_12972)) {
                killer.field_13987.method_14364((class_2596)new class_2767(class_7923.field_41172.method_47983((Object)class_3417.field_19344), class_3419.field_15251, pharaoh.method_23317(), pharaoh.method_23318(), pharaoh.method_23321(), 1.0f, 1.0f, serverLevel.method_8412()));
                killer.method_6016(class_1294.field_5901);
            }
            BetterDesertTemplesCommon.LOGGER.info("Cleared Better Desert Temple at x={}, z={}", (Object)structureStartPos.method_10263(), (Object)structureStartPos.method_10260());
        } else {
            BetterDesertTemplesCommon.LOGGER.error("Position provided is not inside a Better Desert Temple. Unable to clear temple.");
        }
    }
}

