/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.vanity;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.upcraft.sparkweave.api.platform.ModContainer;
import dev.upcraft.sparkweave.api.platform.ModMetadata;
import dev.upcraft.sparkweave.api.platform.Services;
import dev.upcraft.sparkweave.api.reflect.ContextHelper;
import dev.upcraft.sparkweave.api.storage.DataStore;
import dev.upcraft.sparkweave.api.web.HttpStatus;
import dev.upcraft.sparkweave.logging.SparkweaveLogging;
import dev.upcraft.sparkweave.vanity.SparkweaveVanityData;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_3518;
import org.jetbrains.annotations.Nullable;

public class SparkweaveVanityHandler {
    private static final String DATA_URL = "http://localhost:8000/graphql";
    private static final String GET_VANITY_DATA_QUERY = "query {\n\tusers {\n\t\tusername,\n\t\tuuid,\n\t\ttier\n\t}\n}\n".stripIndent();
    private static final Gson GSON = new GsonBuilder().serializeNulls().create();
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    private static final DataStore<Map<UUID, SparkweaveVanityData>> DATA_STORE = (DataStore)class_156.method_656(() -> {
        Supplier<Map> dataFetcher = () -> {
            ModContainer container = ContextHelper.getCurrentContext();
            ModMetadata meta = container.metadata();
            try {
                JsonObject bodyJson = new JsonObject();
                bodyJson.addProperty("query", GET_VANITY_DATA_QUERY);
                String body = GSON.toJson((JsonElement)bodyJson);
                HttpRequest request = HttpRequest.newBuilder(URI.create(DATA_URL)).header("Accept", "application/json;charset=UTF-8").header("Content-Type", "application/json;charset=UTF-8").header("User-Agent", String.format("%s/%s %s", meta.id(), meta.version(), Services.PLATFORM.getUserAgent())).POST(HttpRequest.BodyPublishers.ofString(body, StandardCharsets.UTF_8)).build();
                HttpResponse<InputStream> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofInputStream());
                if (!HttpStatus.ok(response.statusCode())) {
                    HttpStatus status = HttpStatus.of(response.statusCode());
                    SparkweaveLogging.getLogger().error("Got Status {} ({}) while trying to fetch vanity data! see {}", (Object)status.code(), (Object)status.displayName(), (Object)status.getDescriptionUrl());
                    return Map.of();
                }
                try (InputStreamReader reader = new InputStreamReader(response.body(), StandardCharsets.UTF_8);){
                    JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                    JsonObject data = class_3518.method_15296((JsonObject)json, (String)"data");
                    JsonArray users = class_3518.method_15261((JsonObject)data, (String)"users");
                    Map map = (Map)SparkweaveVanityData.LIST_CODEC.map(list -> list.stream().collect(Collectors.toMap(SparkweaveVanityData::uuid, UnaryOperator.identity()))).parse((DynamicOps)JsonOps.INSTANCE, (Object)users).resultOrPartial(msg -> SparkweaveLogging.getLogger().error("Failed to parse vanity data: {}", msg)).orElseThrow(() -> new JsonParseException("Failed to parse vanity data"));
                    return map;
                }
            }
            catch (JsonParseException | IOException | InterruptedException e) {
                SparkweaveLogging.getLogger().error("Failed to retrieve vanity data", e);
            }
            return Map.of();
        };
        return new DataStore<Map>("sparkweave-vanity-data", dataFetcher, Duration.ofMinutes(10L), true);
    });

    @Nullable
    public static SparkweaveVanityData getData(UUID uuid) {
        return DATA_STORE.get().get(uuid);
    }

    public static boolean has(UUID uuid) {
        return DATA_STORE.get().containsKey(uuid);
    }

    public static Map<UUID, SparkweaveVanityData> getAll() {
        return DATA_STORE.get();
    }

    public static CompletableFuture<Void> refresh(Executor executor, boolean force) {
        return DATA_STORE.refresh(executor, force);
    }
}

