/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.event;

import com.google.common.base.Preconditions;
import dev.upcraft.sparkweave.api.event.Event;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

public class EventFactoryImpl<T>
implements Event<T> {
    private final Class<T> type;
    private final Function<T[], T> invokerFactory;
    private T[] listeners;
    private T invoker;

    private EventFactoryImpl(Class<T> type, Function<T[], T> invokerFactory) {
        this.type = type;
        this.invokerFactory = invokerFactory;
        this.listeners = this.makeArray(0);
        this.setupInvoker();
    }

    public static <T> Event<T> create(Class<T> type, Function<T[], T> invokerFactory) {
        return new EventFactoryImpl<T>(type, invokerFactory);
    }

    public static <T> Event<T> create(Class<T> type, T emptyInvoker, Function<T[], T> invokerFactory) {
        return new EventFactoryImpl<Object>(type, listeners -> switch (((Object[])listeners).length) {
            case 0 -> emptyInvoker;
            case 1 -> listeners[0];
            default -> invokerFactory.apply((T[])listeners);
        });
    }

    @Override
    public void register(T listener) {
        Preconditions.checkArgument((boolean)this.type.isInstance(listener), (Object)("Listener is not of the correct type, must extend " + this.type.getName()));
        Preconditions.checkArgument((boolean)Stream.of(this.listeners).noneMatch(it -> it == listener), (Object)"Listener is already registered");
        this.listeners = Arrays.copyOf(this.listeners, this.listeners.length + 1);
        this.listeners[this.listeners.length - 1] = listener;
        this.setupInvoker();
    }

    @Override
    public void unregister(T listener) {
        if (!this.type.isInstance(listener)) {
            return;
        }
        for (int i = 0; i < this.listeners.length; ++i) {
            if (this.listeners[i] != listener) continue;
            this.listeners[i] = null;
            break;
        }
        this.listeners = Arrays.stream(this.listeners).filter(Objects::nonNull).toArray(this::makeArray);
        this.setupInvoker();
    }

    private void setupInvoker() {
        this.invoker = this.invokerFactory.apply((T[][])this.listeners);
    }

    private T[] makeArray(int size) {
        return (Object[])Array.newInstance(this.type, size);
    }

    @Override
    public T invoker() {
        return this.invoker;
    }

    @Override
    public int listenerCount() {
        return this.listeners.length;
    }
}

