/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.client.render;

import dev.upcraft.sparkweave.api.SparkweaveApi;
import dev.upcraft.sparkweave.api.annotation.Mod;
import dev.upcraft.sparkweave.logging.SparkweaveLogging;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.logging.log4j.Logger;

@Mod.Context(value="sparkweave")
public class RenderDocHelper {
    private static final Logger LOGGER = SparkweaveLogging.getLogger();

    public static void init() {
        if (SparkweaveApi.Client.LOAD_RENDERDOC) {
            Object libraryPath = System.getProperty("java.library.path");
            String rdHome = System.getenv("RENDERDOC_HOME");
            if (rdHome != null) {
                libraryPath = rdHome + File.pathSeparator + rdHome;
            }
            String libraryName = System.mapLibraryName("renderdoc");
            boolean loaded = false;
            for (String dir : ((String)libraryPath).split(File.pathSeparator)) {
                try {
                    Path searchPath = Path.of(dir, libraryName).toAbsolutePath();
                    if (!Files.exists(searchPath, new LinkOption[0])) continue;
                    LOGGER.debug("Attempting to load RenderDoc from {}", (Object)searchPath);
                    System.load(searchPath.toString());
                    loaded = true;
                }
                catch (SecurityException | UnsatisfiedLinkError e) {
                    LOGGER.error("unable to load RenderDoc library", e);
                }
                break;
            }
            if (!loaded) {
                LOGGER.warn("RenderDoc not found or unable to load");
            }
        }
    }
}

