/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.api.reflect;

import dev.upcraft.sparkweave.api.annotation.CallerSensitive;
import dev.upcraft.sparkweave.api.annotation.Mod;
import dev.upcraft.sparkweave.api.logging.SparkweaveLoggerFactory;
import dev.upcraft.sparkweave.api.platform.ModContainer;
import dev.upcraft.sparkweave.api.platform.Services;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;

public class ContextHelper {
    private static final Map<Class<?>, ModContainer> CONTEXT_CACHE = new Object2ObjectOpenHashMap();
    private static final Map<String, String> PACKAGE_CONTEXT_CACHE = new Object2ObjectOpenHashMap();

    private ContextHelper() {
        throw new UnsupportedOperationException();
    }

    public static ModContainer getContext(Class<?> clazz) {
        return CONTEXT_CACHE.computeIfAbsent(clazz, node -> {
            String contextModID;
            Collection<String> packages;
            Mod.Context annotation = clazz.getDeclaredAnnotation(Mod.Context.class);
            if (annotation == null) {
                String packageName = clazz.getPackage().getName();
                packages = ClassLoader.getSystemClassLoader().getUnnamedModule().getPackages();
                if (packages.contains(packageName)) {
                    annotation = ClassLoader.getSystemClassLoader().getUnnamedModule().getClassLoader().getDefinedPackage(packageName).getAnnotation(Mod.Context.class);
                }
            }
            if (annotation != null) {
                String modid = annotation.value();
                return Services.PLATFORM.getModContainer(modid).orElseThrow(() -> new NoSuchElementException("No mod loaded with ID " + modid));
            }
            String pkgName = clazz.getPackageName();
            packages = new Vector();
            while (true) {
                ((Vector)packages).add(pkgName);
                contextModID = PACKAGE_CONTEXT_CACHE.get(pkgName);
                if (contextModID != null) break;
                try {
                    Class.forName(pkgName + ".package-info");
                    Package pkg = ContextHelper.class.getClassLoader().getDefinedPackage(pkgName);
                    if (pkg != null && (annotation = pkg.getAnnotation(Mod.Context.class)) != null) {
                        contextModID = annotation.value();
                        break;
                    }
                }
                catch (ClassNotFoundException pkg) {
                    // empty catch block
                }
                if (!pkgName.contains(".")) break;
                pkgName = pkgName.substring(0, pkgName.lastIndexOf(46));
            }
            if (contextModID == null) {
                SparkweaveLoggerFactory.getLogger("Sparkweave ContextHelper").error("Could not determine mod context for class {}, assuming Minecraft!", (Object)clazz.getCanonicalName());
                contextModID = "minecraft";
            }
            for (String pkg : packages) {
                PACKAGE_CONTEXT_CACHE.put(pkg, contextModID);
            }
            String modid = contextModID;
            return Services.PLATFORM.getModContainer(modid).orElseThrow(() -> new NoSuchElementException("No mod loaded with ID " + modid));
        });
    }

    @CallerSensitive
    public static ModContainer getCurrentContext() {
        return ContextHelper.getCurrentContext(1);
    }

    @CallerSensitive
    public static ModContainer getCallerContext() {
        return ContextHelper.getCurrentContext(2);
    }

    @CallerSensitive
    public static ModContainer getCurrentContext(int above) {
        Class caller = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(s -> s.map(StackWalker.StackFrame::getDeclaringClass).skip(above + 1).findFirst().orElseThrow(() -> new IllegalStateException("Could not determine class from call context")));
        return ContextHelper.getContext(caller);
    }

    static {
        PACKAGE_CONTEXT_CACHE.put("net.minecraft", "minecraft");
        PACKAGE_CONTEXT_CACHE.put("com.mojang", "minecraft");
        PACKAGE_CONTEXT_CACHE.put("org.quiltmc", "quilt_loader");
        PACKAGE_CONTEXT_CACHE.put("org.quiltmc.loader", "quilt_loader");
        PACKAGE_CONTEXT_CACHE.put("org.quiltmc.qsl", "qsl");
        PACKAGE_CONTEXT_CACHE.put("net.fabricmc", "quilt_loader");
        PACKAGE_CONTEXT_CACHE.put("net.fabricmc.loader", "quilt_loader");
        PACKAGE_CONTEXT_CACHE.put("net.fabricmc.fabric", "fabric");
        PACKAGE_CONTEXT_CACHE.put("net.neoforged", "neoforge");
        PACKAGE_CONTEXT_CACHE.put("cpw.mods.modlauncher", "neoforge");
        PACKAGE_CONTEXT_CACHE.put("cpw.mods.cl", "neoforge");
        List.of("java", "jdk", "javax", "com.sun", "sun", "org.ietf.jgss", "org.w3c.dom", "org.xml.sax", "org.jcp.xml.dsig.internal", "netscape.javascript").forEach(it -> PACKAGE_CONTEXT_CACHE.put((String)it, "java"));
    }
}

