/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.api.platform;

import dev.upcraft.sparkweave.api.logging.SparkweaveLoggerFactory;
import dev.upcraft.sparkweave.api.platform.services.PlatformService;
import java.util.ServiceLoader;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class Services {
    private static final Logger logger = SparkweaveLoggerFactory.getLogger("Sparkweave Engine/ServiceLoader");
    public static final PlatformService PLATFORM = Services.getService(PlatformService.class);

    public static <T> T getService(Class<T> serviceClass) {
        Object service = ServiceLoader.load(serviceClass).findFirst().orElseThrow(() -> new IllegalStateException("No platform implementation found for " + serviceClass.getCanonicalName()));
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> service.getClass().getName();
        supplierArray[1] = serviceClass::getName;
        logger.debug("Loaded {} for service {}", supplierArray);
        return service;
    }
}

