/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.storage;

import com.mojang.serialization.DynamicOps;
import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.block.entity.StorageDrawerBlockEntity;
import io.github.mattidragon.extendeddrawers.config.ConfigData;
import io.github.mattidragon.extendeddrawers.item.LimiterItem;
import io.github.mattidragon.extendeddrawers.item.UpgradeItem;
import io.github.mattidragon.extendeddrawers.misc.ItemUtils;
import io.github.mattidragon.extendeddrawers.registry.ModDataComponents;
import io.github.mattidragon.extendeddrawers.storage.CompactingDrawerStorage;
import io.github.mattidragon.extendeddrawers.storage.DrawerSlot;
import io.github.mattidragon.extendeddrawers.storage.ModifierAccess;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface DrawerStorage
extends Comparable<DrawerStorage>,
Storage<ItemVariant>,
ModifierAccess
permits DrawerSlot, CompactingDrawerStorage {
    public StorageDrawerBlockEntity getOwner();

    public Settings settings();

    public boolean isBlank();

    public long getCapacity();

    public long getTrueAmount();

    @Override
    default public boolean changeUpgrade(ItemVariant newUpgrade, class_1937 world, class_2338 pos, class_2350 side, @Nullable class_1657 player) {
        if (!(newUpgrade.getItem() instanceof UpgradeItem) && !newUpgrade.isBlank()) {
            return false;
        }
        ItemVariant oldUpgrade = this.settings().upgrade;
        if (newUpgrade.isBlank() && oldUpgrade.isBlank()) {
            return false;
        }
        this.settings().upgrade = newUpgrade;
        if (this.getTrueAmount() > this.getCapacity() && ((ConfigData)ExtendedDrawers.CONFIG.get()).misc().blockUpgradeRemovalsWithOverflow()) {
            this.settings().upgrade = oldUpgrade;
            if (player != null) {
                player.method_7353((class_2561)class_2561.method_43471((String)"extended_drawer.drawer.upgrade_fail"), true);
            }
            return false;
        }
        ItemUtils.offerOrDrop(world, pos, side, player, oldUpgrade.toStack());
        this.dumpExcess(world, pos, side, player);
        return true;
    }

    @Override
    default public boolean changeLimiter(ItemVariant newLimiter, class_1937 world, class_2338 pos, class_2350 side, @Nullable class_1657 player) {
        if (!(newLimiter.getItem() instanceof LimiterItem) && !newLimiter.isBlank()) {
            return false;
        }
        ItemVariant oldLimiter = this.settings().limiter;
        if (newLimiter.isBlank() && oldLimiter.isBlank()) {
            return false;
        }
        this.settings().limiter = newLimiter;
        if (this.getTrueAmount() > this.getCapacity() && ((ConfigData)ExtendedDrawers.CONFIG.get()).misc().blockUpgradeRemovalsWithOverflow()) {
            this.settings().limiter = oldLimiter;
            if (player != null) {
                player.method_7353((class_2561)class_2561.method_43471((String)"extended_drawer.drawer.limiter_fail"), true);
            }
            return false;
        }
        ItemUtils.offerOrDrop(world, pos, side, player, oldLimiter.toStack());
        this.dumpExcess(world, pos, side, player);
        return true;
    }

    default public void update() {
        this.getOwner().onSlotChanged(this.settings().sortingDirty);
        this.settings().sortingDirty = false;
    }

    @Override
    default public int compareTo(@NotNull DrawerStorage other) {
        if (this.isBlank() != other.isBlank()) {
            return this.isBlank() ? 1 : -1;
        }
        if (this.isLocked() != other.isLocked()) {
            return this.isLocked() ? -1 : 1;
        }
        if (this.isVoiding() != other.isVoiding()) {
            return this.isVoiding() ? 1 : -1;
        }
        return 0;
    }

    public void dumpExcess(class_1937 var1, class_2338 var2, @Nullable class_2350 var3, @Nullable class_1657 var4);

    default public void readNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        this.settings().locked = nbt.method_10577("locked");
        this.settings().voiding = nbt.method_10577("voiding");
        this.settings().hidden = nbt.method_10577("hidden");
        this.settings().duping = nbt.method_10577("duping");
        this.settings().upgrade = (ItemVariant)ItemVariant.CODEC.parse((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)registryLookup), (Object)nbt.method_10562("capacityUpgrade")).getOrThrow();
        this.settings().limiter = (ItemVariant)ItemVariant.CODEC.parse((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)registryLookup), (Object)nbt.method_10562("limiter")).getOrThrow();
    }

    default public void writeNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        nbt.method_10556("locked", this.settings().locked);
        nbt.method_10556("voiding", this.settings().voiding);
        nbt.method_10556("hidden", this.settings().hidden);
        nbt.method_10556("duping", this.settings().duping);
        nbt.method_10566("capacityUpgrade", (class_2520)ItemVariant.CODEC.encodeStart((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)registryLookup), (Object)this.settings().upgrade).getOrThrow());
        nbt.method_10566("limiter", (class_2520)ItemVariant.CODEC.encodeStart((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)registryLookup), (Object)this.settings().limiter).getOrThrow());
    }

    @Override
    default public void overrideLock(TransactionContext transaction) {
        if (this.settings().lockOverridden) {
            ExtendedDrawers.LOGGER.warn("Tried to override drawer lock while already overridden. Unexpected behavior may follow.");
            return;
        }
        transaction.addCloseCallback((transaction1, result) -> {
            this.settings().lockOverridden = false;
        });
        this.settings().lockOverridden = true;
    }

    @Override
    default public boolean isLocked() {
        return this.settings().locked;
    }

    @Override
    default public boolean isVoiding() {
        return this.settings().voiding;
    }

    @Override
    default public boolean isHidden() {
        return this.settings().hidden;
    }

    @Override
    default public boolean isDuping() {
        return this.settings().duping;
    }

    @Override
    @Nullable
    default public UpgradeItem getUpgrade() {
        UpgradeItem upgrade;
        class_1792 class_17922 = this.settings().upgrade.getItem();
        return class_17922 instanceof UpgradeItem ? (upgrade = (UpgradeItem)class_17922) : null;
    }

    @Override
    default public long getLimiter() {
        return (Long)this.settings().limiter.toStack().method_57825(ModDataComponents.LIMITER_LIMIT, (Object)Long.MAX_VALUE);
    }

    @Override
    default public void setLocked(boolean locked) {
        this.settings().sortingDirty = true;
        this.settings().locked = locked;
        this.update();
    }

    @Override
    default public void setVoiding(boolean voiding) {
        this.settings().sortingDirty = true;
        this.settings().voiding = voiding;
        this.update();
    }

    @Override
    default public void setHidden(boolean hidden) {
        this.settings().hidden = hidden;
        this.update();
    }

    @Override
    default public void setDuping(boolean duping) {
        this.settings().duping = duping;
        this.update();
    }

    @Override
    default public boolean hasLimiter() {
        return !this.settings().limiter.isBlank();
    }

    public static class Settings {
        ItemVariant upgrade = ItemVariant.blank();
        ItemVariant limiter = ItemVariant.blank();
        boolean locked = false;
        boolean hidden = false;
        boolean voiding = false;
        boolean duping = false;
        boolean lockOverridden = false;
        boolean sortingDirty = false;
    }
}

