/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.storage;

import com.google.common.base.MoreObjects;
import com.mojang.serialization.DynamicOps;
import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.block.entity.CompactingDrawerBlockEntity;
import io.github.mattidragon.extendeddrawers.compacting.CompressionLadder;
import io.github.mattidragon.extendeddrawers.compacting.CompressionRecipeManager;
import io.github.mattidragon.extendeddrawers.component.DrawerSlotComponent;
import io.github.mattidragon.extendeddrawers.config.ConfigData;
import io.github.mattidragon.extendeddrawers.config.category.StorageCategory;
import io.github.mattidragon.extendeddrawers.misc.ItemUtils;
import io.github.mattidragon.extendeddrawers.storage.DrawerStorage;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompactingDrawerStorage
extends SnapshotParticipant<Snapshot>
implements DrawerStorage,
SlottedStorage<ItemVariant> {
    private final CompactingDrawerBlockEntity owner;
    private final DrawerStorage.Settings settings;
    private ItemVariant item = ItemVariant.blank();
    private final Slot[] slots = new Slot[]{new Slot(), new Slot(), new Slot()};
    private boolean updatePending;
    private long amount;

    public CompactingDrawerStorage(CompactingDrawerBlockEntity owner) {
        this.owner = owner;
        this.settings = new DrawerStorage.Settings();
    }

    public void readComponent(DrawerSlotComponent component) {
        this.settings.upgrade = component.upgrade();
        this.settings.limiter = component.limiter();
        this.settings.locked = component.locked();
        this.settings.hidden = component.hidden();
        this.settings.voiding = component.voiding();
        this.settings.duping = component.duping();
        this.item = component.item();
        this.amount = component.amount();
        if (this.item.isBlank()) {
            this.amount = 0L;
        }
        this.updatePending = true;
    }

    public DrawerSlotComponent toComponent() {
        return new DrawerSlotComponent(this.settings.upgrade, this.settings.limiter, this.settings.locked, this.settings.hidden, this.settings.voiding, this.settings.duping, this.item, this.amount);
    }

    @Override
    public void dumpExcess(class_1937 world, class_2338 pos, @Nullable class_2350 side, @Nullable class_1657 player) {
        if (this.amount > this.getCapacity()) {
            Slot[] slots = this.getSlotArray();
            for (int i = slots.length - 1; i >= 0; --i) {
                Slot slot = slots[i];
                if (slot.isBlocked()) continue;
                long toDrop = slot.getTrueAmount() - slot.getCapacity();
                ItemUtils.offerOrDropStacks(world, pos, side, player, slot.getResource(), toDrop);
                this.amount -= toDrop * (long)slot.compression;
            }
        }
        this.update();
    }

    @Override
    public CompactingDrawerBlockEntity getOwner() {
        return this.owner;
    }

    @Override
    public long getCapacity() {
        StorageCategory config = ((ConfigData)ExtendedDrawers.CONFIG.get()).storage();
        long capacity = config.compactingCapacity();
        if (config.stackSizeAffectsCapacity()) {
            capacity /= (long)(64.0 / (double)this.item.getItem().method_7882());
        }
        if (this.getUpgrade() != null) {
            capacity = this.getUpgrade().modifier.applyAsLong(capacity);
        }
        capacity *= (long)this.getTotalCompression();
        capacity = Math.min(capacity, this.getLimiter());
        return capacity;
    }

    @Override
    public DrawerStorage.Settings settings() {
        return this.settings;
    }

    @Override
    public boolean isBlank() {
        return this.item.isBlank();
    }

    protected Snapshot createSnapshot() {
        return new Snapshot(this.item, this.amount);
    }

    protected void readSnapshot(Snapshot snapshot) {
        this.item = snapshot.item;
        this.amount = snapshot.amount;
        this.updatePending = true;
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        long inserted = 0L;
        for (Slot slot2 : this.getActiveSlotArray()) {
            if ((inserted += slot2.insert(resource, maxAmount - inserted, transaction)) == maxAmount) break;
        }
        if (Arrays.stream(this.getActiveSlotArray()).anyMatch(slot -> slot.item.equals((Object)resource)) && this.settings.voiding) {
            return maxAmount;
        }
        return inserted;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        long extracted = 0L;
        for (Slot slot : this.getActiveSlotArray()) {
            if ((extracted += slot.extract(resource, maxAmount - extracted, transaction)) == maxAmount) break;
        }
        return extracted;
    }

    public Iterator<StorageView<ItemVariant>> nonEmptyIterator() {
        return new NonEmptyIterator();
    }

    @NotNull
    public Iterator<StorageView<ItemVariant>> iterator() {
        return new StorageIterator();
    }

    public int getSlotCount() {
        return this.getActiveSlotCount();
    }

    public Slot getSlot(int index) {
        return this.getSlotArray()[index];
    }

    @Override
    public void setLocked(boolean locked) {
        if (!locked && this.amount == 0L) {
            this.clear();
        }
        DrawerStorage.super.setLocked(locked);
    }

    @Override
    public void readNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        DrawerStorage.super.readNbt(nbt, registryLookup);
        this.item = (ItemVariant)ItemVariant.CODEC.parse((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)registryLookup), (Object)nbt.method_10562("item")).getOrThrow();
        this.amount = nbt.method_10537("amount");
        if (this.item.isBlank()) {
            this.amount = 0L;
        }
        this.updatePending = true;
    }

    @Override
    public void writeNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        DrawerStorage.super.writeNbt(nbt, registryLookup);
        nbt.method_10566("item", (class_2520)ItemVariant.CODEC.encodeStart((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)registryLookup), (Object)this.item).getOrThrow());
        nbt.method_10544("amount", this.amount);
    }

    public Slot[] getActiveSlotArray() {
        int count = this.getActiveSlotCount();
        Slot[] result = new Slot[count];
        System.arraycopy(this.getSlotArray(), 0, result, 0, count);
        return result;
    }

    public int getActiveSlotCount() {
        int size;
        Slot[] slots = this.getSlotArray();
        for (size = 0; size < slots.length && !slots[size].blocked; ++size) {
        }
        return size;
    }

    public Slot[] getSlotArray() {
        if (this.updatePending) {
            this.updateSlots();
        }
        return this.slots;
    }

    private int getTotalCompression() {
        Slot[] slots = this.getActiveSlotArray();
        if (slots.length == 0) {
            return 1;
        }
        return slots[slots.length - 1].compression;
    }

    private void clear() {
        this.item = ItemVariant.blank();
        this.settings.sortingDirty = true;
        for (Slot slot : this.slots) {
            slot.reset(false);
        }
        this.updatePending = false;
    }

    private void updateSlots() {
        for (Slot slot2 : this.slots) {
            slot2.reset(true);
        }
        CompressionLadder ladder = this.owner.method_10997() == null ? new CompressionLadder(List.of(new CompressionLadder.Step(this.item, 1))) : CompressionRecipeManager.of(this.owner.method_10997().method_8433()).getLadder(this.item, this.owner.method_10997());
        int ladderSize = ladder.steps().size();
        int initialPosition = ladder.getPosition(this.item);
        if (initialPosition == -1) {
            throw new IllegalStateException("Item is not on it's own recipe ladder. Did we lookup mid-reload?");
        }
        int[] positions = CompactingDrawerStorage.chooseLadderPositions(ladderSize, initialPosition);
        int globalCompression = ladder.steps().get(positions[0]).size();
        for (int i = 0; i < positions.length; ++i) {
            int position = positions[i];
            CompressionLadder.Step step = ladder.steps().get(position);
            this.slots[i].compression = step.size() / globalCompression;
            this.slots[i].item = step.item();
            this.slots[i].blocked = false;
        }
        Slot initalSlot = Stream.of(this.slots).filter(slot -> slot.item.equals((Object)this.item)).findFirst().orElseThrow();
        this.item = this.slots[0].item;
        this.amount *= (long)initalSlot.compression;
        this.updatePending = false;
    }

    private static int[] chooseLadderPositions(int size, int start) {
        if (size == 1) {
            return new int[]{0};
        }
        if (size == 2) {
            return new int[]{0, 1};
        }
        if (start == size - 1) {
            return new int[]{start - 2, start - 1, start};
        }
        if (start == size - 2) {
            return new int[]{start - 1, start, start + 1};
        }
        return new int[]{start, start + 1, start + 2};
    }

    protected void onFinalCommit() {
        this.update();
    }

    @Override
    public long getTrueAmount() {
        return this.amount;
    }

    public class Slot
    implements SingleSlotStorage<ItemVariant> {
        private int compression;
        private ItemVariant item;
        private boolean blocked;

        public Slot() {
            this.reset(false);
        }

        private void reset(boolean blocked) {
            this.compression = 1;
            this.item = ItemVariant.blank();
            this.blocked = blocked;
        }

        public long insert(ItemVariant item, long maxAmount, TransactionContext transaction) {
            if (CompactingDrawerStorage.this.updatePending) {
                CompactingDrawerStorage.this.updateSlots();
            }
            StoragePreconditions.notBlankNotNegative((TransferVariant)item, (long)maxAmount);
            if (this.blocked) {
                return 0L;
            }
            if (!this.item.equals((Object)item) && !this.item.isBlank()) {
                return 0L;
            }
            if (!((ConfigData)ExtendedDrawers.CONFIG.get()).misc().allowRecursion() && !item.getItem().method_31568()) {
                return 0L;
            }
            if (this.item.isBlank() && CompactingDrawerStorage.this.settings.locked && !CompactingDrawerStorage.this.settings.lockOverridden) {
                return 0L;
            }
            if (this.item.isBlank()) {
                CompactingDrawerStorage.this.updateSnapshots(transaction);
                CompactingDrawerStorage.this.item = item;
                CompactingDrawerStorage.this.updateSlots();
                return CompactingDrawerStorage.this.insert(item, maxAmount, transaction);
            }
            long inserted = Math.min(maxAmount, this.getSpace());
            if (inserted > 0L) {
                CompactingDrawerStorage.this.updateSnapshots(transaction);
                CompactingDrawerStorage.this.amount += inserted * (long)this.compression;
            } else if (inserted < 0L) {
                ExtendedDrawers.LOGGER.warn("Somehow inserted negative amount of items ({}) into compacting drawer, aborting. Arguments: item={} maxAmount={}. Status: compression={} item={} capacity={} amount={}", new Object[]{inserted, item, maxAmount, this.compression, this.item, this.getCapacity(), this.getTrueAmount()});
                return 0L;
            }
            return inserted;
        }

        public long extract(ItemVariant item, long maxAmount, TransactionContext transaction) {
            if (CompactingDrawerStorage.this.updatePending) {
                CompactingDrawerStorage.this.updateSlots();
            }
            if (this.blocked) {
                return 0L;
            }
            if (!this.item.equals((Object)item)) {
                return 0L;
            }
            long extracted = Math.min(maxAmount, this.getTrueAmount());
            if (extracted > 0L) {
                CompactingDrawerStorage.this.updateSnapshots(transaction);
                CompactingDrawerStorage.this.amount -= extracted * (long)this.compression;
            } else if (extracted < 0L) {
                ExtendedDrawers.LOGGER.warn("Somehow extracted negative amount of items ({}) from compacting drawer, aborting. Arguments: item={} maxAmount={}. Status: compression={} item={} capacity={} amount={}", new Object[]{extracted, item, maxAmount, this.compression, this.item, this.getCapacity(), this.getTrueAmount()});
                return 0L;
            }
            if (CompactingDrawerStorage.this.amount == 0L && !CompactingDrawerStorage.this.settings.locked && !CompactingDrawerStorage.this.settings.duping) {
                CompactingDrawerStorage.this.clear();
            }
            return CompactingDrawerStorage.this.settings.duping ? maxAmount : extracted;
        }

        public boolean supportsInsertion() {
            return !this.blocked;
        }

        public boolean supportsExtraction() {
            return !this.blocked;
        }

        public boolean isResourceBlank() {
            if (CompactingDrawerStorage.this.updatePending) {
                CompactingDrawerStorage.this.updateSlots();
            }
            return this.item.isBlank();
        }

        public ItemVariant getResource() {
            return this.item;
        }

        public long getSpace() {
            return (CompactingDrawerStorage.this.getCapacity() - CompactingDrawerStorage.this.amount) / (long)this.compression;
        }

        public long getTrueAmount() {
            return CompactingDrawerStorage.this.amount / (long)this.compression;
        }

        public long getAmount() {
            return CompactingDrawerStorage.this.settings.duping ? Long.MAX_VALUE : this.getTrueAmount();
        }

        public long getCapacity() {
            return CompactingDrawerStorage.this.getCapacity() / (long)this.compression;
        }

        public CompactingDrawerStorage getStorage() {
            return CompactingDrawerStorage.this;
        }

        public boolean isBlocked() {
            return this.blocked;
        }

        public long getCompression() {
            return this.compression;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("compression", this.compression).add("item", (Object)this.item).add("blocked", this.blocked).toString();
        }
    }

    protected record Snapshot(ItemVariant item, long amount) {
    }

    private class NonEmptyIterator
    implements Iterator<StorageView<ItemVariant>> {
        private int index;

        private NonEmptyIterator() {
            this.index = CompactingDrawerStorage.this.slots.length - 1;
        }

        @Override
        public boolean hasNext() {
            for (int i = this.index; i >= 0; --i) {
                if (CompactingDrawerStorage.this.getSlotArray()[i].isResourceBlank()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Slot next() {
            while (this.index >= 0) {
                if (!CompactingDrawerStorage.this.getSlotArray()[this.index].isResourceBlank()) {
                    return CompactingDrawerStorage.this.slots[this.index--];
                }
                --this.index;
            }
            throw new NoSuchElementException();
        }
    }

    private class StorageIterator
    implements Iterator<StorageView<ItemVariant>> {
        private int index;

        private StorageIterator() {
            this.index = CompactingDrawerStorage.this.slots.length - 1;
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public Slot next() {
            return CompactingDrawerStorage.this.getSlotArray()[this.index--];
        }
    }
}

