/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.network.cache;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.kneelawk.graphlib.api.graph.BlockGraph;
import com.kneelawk.graphlib.api.graph.GraphEntityContext;
import com.kneelawk.graphlib.api.graph.NodeHolder;
import com.kneelawk.graphlib.api.graph.user.BlockNode;
import com.kneelawk.graphlib.api.graph.user.LinkEntity;
import com.kneelawk.graphlib.api.graph.user.NodeEntity;
import com.kneelawk.graphlib.api.util.LinkPos;
import io.github.mattidragon.extendeddrawers.block.entity.StorageDrawerBlockEntity;
import io.github.mattidragon.extendeddrawers.network.cache.NetworkStorageCache;
import io.github.mattidragon.extendeddrawers.network.node.CompactingDrawerBlockNode;
import io.github.mattidragon.extendeddrawers.network.node.DrawerBlockNode;
import io.github.mattidragon.extendeddrawers.storage.DrawerStorage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartNetworkStorageCache
implements NetworkStorageCache {
    private GraphEntityContext context;
    private final CombinedStorage<ItemVariant, DrawerStorage> cachedStorage = new CombinedStorage(new ArrayList());
    private final Multimap<class_2338, DrawerStorage> positions = HashMultimap.create();
    private final Set<class_2338> missingPositions = new HashSet<class_2338>();

    @Override
    public CombinedStorage<ItemVariant, DrawerStorage> get() {
        this.update();
        return this.cachedStorage;
    }

    @Override
    public void update() {
        if (!this.missingPositions.isEmpty()) {
            this.missingPositions.forEach(pos -> {
                class_2586 patt0$temp = this.context.getBlockWorld().method_8321(pos);
                if (patt0$temp instanceof StorageDrawerBlockEntity) {
                    StorageDrawerBlockEntity drawer = (StorageDrawerBlockEntity)patt0$temp;
                    drawer.streamStorages().forEach(storage -> {
                        this.cachedStorage.parts.add(storage);
                        this.positions.put(pos, storage);
                    });
                }
            });
            this.missingPositions.clear();
            this.onSortingChanged();
        }
    }

    @Override
    public void onSortingChanged() {
        this.cachedStorage.parts.sort(null);
    }

    public void onInit(@NotNull GraphEntityContext context) {
        this.context = context;
        this.missingPositions.clear();
        context.getGraph().getNodes().map(NodeHolder::getBlockPos).filter(Predicate.not(arg_0 -> this.positions.containsKey(arg_0))).forEach(this.missingPositions::add);
    }

    @NotNull
    public GraphEntityContext getContext() {
        return this.context;
    }

    public void onPostNodeCreated(@NotNull NodeHolder<BlockNode> node, @Nullable NodeEntity nodeEntity) {
        this.missingPositions.add(node.getBlockPos());
    }

    public void onPostNodeDestroyed(@NotNull NodeHolder<BlockNode> node, @Nullable NodeEntity nodeEntity, Map<LinkPos, LinkEntity> linkEntities) {
        class_2338 pos = node.getBlockPos();
        this.positions.get((Object)pos).forEach(this.cachedStorage.parts::remove);
        this.positions.removeAll((Object)pos);
        this.missingPositions.remove(pos);
    }

    @Override
    public void onNodeUnloaded(class_2338 pos) {
        this.positions.get((Object)pos).forEach(this.cachedStorage.parts::remove);
        this.positions.removeAll((Object)pos);
        this.missingPositions.add(pos);
    }

    @Override
    public void onNodeReloaded(class_2338 pos) {
        this.missingPositions.add(pos);
    }

    public void merge(@NotNull NetworkStorageCache other) {
        if (!(other instanceof SmartNetworkStorageCache)) {
            this.forceUpdate();
        } else {
            SmartNetworkStorageCache smart = (SmartNetworkStorageCache)other;
            this.positions.putAll(smart.positions);
            this.missingPositions.addAll(smart.missingPositions);
            this.cachedStorage.parts.addAll(smart.cachedStorage.parts);
            this.onSortingChanged();
        }
    }

    @Override
    @NotNull
    public SmartNetworkStorageCache split(@NotNull BlockGraph originalGraph, @NotNull BlockGraph newGraph) {
        SmartNetworkStorageCache newCache = new SmartNetworkStorageCache();
        Iterator<Object> iterator = this.positions.entries().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            class_2338 pos = (class_2338)entry.getKey();
            DrawerStorage storage = (DrawerStorage)entry.getValue();
            if (!newGraph.getNodesAt(pos).findAny().isPresent()) continue;
            iterator.remove();
            this.cachedStorage.parts.remove(storage);
            newCache.positions.put((Object)pos, (Object)storage);
        }
        iterator = this.missingPositions.iterator();
        while (iterator.hasNext()) {
            class_2338 pos = (class_2338)iterator.next();
            if (!newGraph.getNodesAt(pos).findAny().isPresent()) continue;
            iterator.remove();
            newCache.missingPositions.add(pos);
        }
        newCache.cachedStorage.parts.addAll(newCache.positions.values());
        newCache.onSortingChanged();
        this.onSortingChanged();
        return newCache;
    }

    @Override
    public List<class_2561> getDebugInfo() {
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        list.add((class_2561)class_2561.method_43470((String)"Smart Storage Cache Debug Info").method_27695(new class_124[]{class_124.field_1067, class_124.field_1054}));
        list.add((class_2561)class_2561.method_43470((String)"  %s uncached positions".formatted(this.missingPositions.size())));
        list.add((class_2561)class_2561.method_43470((String)"  %s cached positions".formatted(this.positions.size())));
        list.add((class_2561)class_2561.method_43470((String)"  %s storages".formatted(this.cachedStorage.parts.size())));
        list.add((class_2561)class_2561.method_43473());
        this.context.getGraph().getNodes().filter(holder -> holder.getNode() instanceof DrawerBlockNode || holder.getNode() instanceof CompactingDrawerBlockNode).map(NodeHolder::getBlockPos).forEach(pos -> {
            list.add((class_2561)class_2561.method_43470((String)"%s".formatted(pos.method_23854())).method_27692(class_124.field_1054));
            boolean isValid = false;
            if (this.missingPositions.contains(pos)) {
                list.add((class_2561)class_2561.method_43470((String)"  Not cached").method_27692(class_124.field_1061));
                isValid = true;
            }
            if (this.positions.containsKey(pos)) {
                list.add((class_2561)class_2561.method_43470((String)"  Cached: %s storage(s)".formatted(this.positions.get(pos).size())).method_27692(class_124.field_1060));
                isValid = true;
            }
            if (!isValid) {
                list.add((class_2561)class_2561.method_43470((String)"  Missing from cache").method_27692(class_124.field_1079));
            }
        });
        return list;
    }

    @Override
    public void forceUpdate() {
        this.cachedStorage.parts.clear();
        this.positions.clear();
        this.missingPositions.clear();
        this.context.getGraph().getNodes().map(NodeHolder::getBlockPos).forEach(this.missingPositions::add);
        this.update();
    }

    @Override
    public class_2561 getDebugInfo(class_2338 pos) {
        if (this.missingPositions.contains(pos)) {
            return class_2561.method_43470((String)"Not cached").method_27692(class_124.field_1060);
        }
        if (this.positions.containsKey((Object)pos)) {
            return class_2561.method_43470((String)"Cached: %s storage(s)".formatted(this.positions.get((Object)pos).size())).method_27692(class_124.field_1060);
        }
        return class_2561.method_43470((String)"Missing from cache").method_27692(class_124.field_1061);
    }
}

