/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.compacting;

import io.github.mattidragon.extendeddrawers.compacting.CompressionLadder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public final class CompressionRecipeManager {
    private final class_1863 recipeManager;
    private final Map<ItemVariant, CompressionLadder> ladders = new HashMap<ItemVariant, CompressionLadder>();
    private final List<CompressionLadder> overrides = new ArrayList<CompressionLadder>();

    public CompressionRecipeManager(class_1863 recipeManager) {
        this.recipeManager = recipeManager;
    }

    public static CompressionRecipeManager of(class_1863 recipeManager) {
        return ((Provider)recipeManager).extended_drawers$getCompactingManager();
    }

    public void setOverrides(List<CompressionLadder> overrides) {
        this.overrides.clear();
        this.overrides.addAll(overrides);
        this.reload();
    }

    public List<CompressionLadder> getOverrides() {
        return this.overrides;
    }

    public void reload() {
        this.ladders.clear();
        for (CompressionLadder override : this.overrides) {
            this.addLadder(override);
        }
    }

    public CompressionLadder getLadder(ItemVariant item, class_1937 world) {
        if (this.ladders.containsKey(item)) {
            return this.ladders.get(item);
        }
        CompressionLadder ladder = this.buildLadder(item, world);
        this.addLadder(ladder);
        return ladder;
    }

    private void addLadder(CompressionLadder ladder) {
        ladder.steps().forEach(step -> this.ladders.put(step.item(), ladder));
    }

    private CompressionLadder buildLadder(ItemVariant item, class_1937 world) {
        RecipePair pair;
        ItemVariant bottom = this.findBottom(item, world);
        ArrayList<CompressionLadder.Step> ladder = new ArrayList<CompressionLadder.Step>();
        HashSet<ItemVariant> visited = new HashSet<ItemVariant>();
        ItemVariant currentItem = bottom;
        int currentSize = 1;
        visited.add(currentItem);
        ladder.add(new CompressionLadder.Step(currentItem, currentSize));
        while ((pair = this.findCompressionRecipe(currentItem, world)) != null) {
            currentItem = pair.compressed;
            currentSize *= pair.scale;
            if (!visited.add(currentItem)) break;
            ladder.add(new CompressionLadder.Step(currentItem, currentSize));
        }
        return new CompressionLadder(List.copyOf(ladder));
    }

    private ItemVariant findBottom(ItemVariant item, class_1937 world) {
        RecipePair pair;
        HashSet<ItemVariant> visited = new HashSet<ItemVariant>();
        ItemVariant candidate = item;
        while ((pair = this.findDecompressionRecipe(candidate, world)) != null && !visited.contains(pair.decompressed)) {
            candidate = pair.decompressed;
            visited.add(candidate);
        }
        return candidate;
    }

    @Nullable
    private RecipePair findCompressionRecipe(ItemVariant decompressed, class_1937 world) {
        return IntStream.of(3, 2, 1).mapToObj(size -> this.findCompressionRecipeForSize(decompressed, world, size)).flatMap(Function.identity()).findFirst().orElse(null);
    }

    private Stream<RecipePair> findCompressionRecipeForSize(ItemVariant decompressed, class_1937 world, int size) {
        class_1799 decompressedStack = decompressed.toStack(size * size);
        return this.findRecipes(decompressed.toStack(), size, world).filter(compressed -> this.findRecipes((class_1799)compressed, 1, world).anyMatch(decompressed2 -> class_1799.method_7973((class_1799)decompressed2, (class_1799)decompressedStack))).map(compressed -> new RecipePair(ItemVariant.of((class_1799)compressed), decompressed, size * size));
    }

    @Nullable
    private RecipePair findDecompressionRecipe(ItemVariant compressed, class_1937 world) {
        class_1799 compressedStack = compressed.toStack();
        return this.findRecipes(compressedStack, 1, world).flatMap(decompressed -> IntStream.of(3, 2, 1).filter(size -> this.findRecipes((class_1799)decompressed, size, world).anyMatch(compressed2 -> class_1799.method_7973((class_1799)compressedStack, (class_1799)compressed2))).mapToObj(size -> new RecipePair(compressed, ItemVariant.of((class_1799)decompressed), size * size))).findFirst().orElse(null);
    }

    private Stream<class_1799> findRecipes(class_1799 stack, int size, class_1937 world) {
        class_9694 inventory = this.createInventory(stack, size);
        return this.recipeManager.method_17877(class_3956.field_17545, (class_9695)inventory, world).stream().map(class_8786::comp_1933).filter(recipe -> recipe.method_8111((class_9695)inventory).stream().allMatch(class_1799::method_7960)).map(recipe -> recipe.method_8116((class_9695)inventory, (class_7225.class_7874)world.method_30349())).filter(result -> !result.method_7960());
    }

    private class_9694 createInventory(class_1799 stack, int size) {
        ArrayList<class_1799> list = new ArrayList<class_1799>(size * size);
        for (int i = 0; i < size * size; ++i) {
            list.add(stack);
        }
        return class_9694.method_59986((int)size, (int)size, list);
    }

    public static interface Provider {
        default public CompressionRecipeManager extended_drawers$getCompactingManager() {
            throw new AssertionError((Object)"extended_drawers$getCompactingManager must be overridden");
        }
    }

    private record RecipePair(ItemVariant compressed, ItemVariant decompressed, int scale) {
    }
}

