/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.block.entity;

import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.block.DrawerBlock;
import io.github.mattidragon.extendeddrawers.block.entity.StorageDrawerBlockEntity;
import io.github.mattidragon.extendeddrawers.component.DrawerContentsComponent;
import io.github.mattidragon.extendeddrawers.component.DrawerSlotComponent;
import io.github.mattidragon.extendeddrawers.config.ConfigData;
import io.github.mattidragon.extendeddrawers.registry.ModBlocks;
import io.github.mattidragon.extendeddrawers.registry.ModDataComponents;
import io.github.mattidragon.extendeddrawers.storage.CombinedDrawerStorage;
import io.github.mattidragon.extendeddrawers.storage.DrawerSlot;
import io.github.mattidragon.extendeddrawers.storage.DrawerStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.minecraft.class_9323;

public class DrawerBlockEntity
extends StorageDrawerBlockEntity {
    public final int slots;
    public final DrawerSlot[] storages;
    public final CombinedDrawerStorage combinedStorage;

    public DrawerBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlocks.DRAWER_BLOCK_ENTITY, pos, state);
        this.slots = ((DrawerBlock)this.method_11010().method_26204()).slots;
        this.storages = new DrawerSlot[((DrawerBlock)this.method_11010().method_26204()).slots];
        double capacityMultiplier = ((ConfigData)ExtendedDrawers.CONFIG.get()).storage().slotCountAffectsCapacity() ? 1.0 / (double)this.slots : 1.0;
        for (int i = 0; i < this.storages.length; ++i) {
            this.storages[i] = new DrawerSlot(this, capacityMultiplier);
        }
        this.combinedStorage = new CombinedDrawerStorage(this.storages);
        this.sortSlots();
    }

    private void sortSlots() {
        this.combinedStorage.sort();
    }

    @Override
    public void onSlotChanged(boolean sortingChanged) {
        if (sortingChanged) {
            this.sortSlots();
        }
        super.onSlotChanged(sortingChanged);
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbt = new class_2487();
        this.method_11007(nbt, registryLookup);
        return nbt;
    }

    protected void method_57568(class_2586.class_9473 components) {
        DrawerContentsComponent component = (DrawerContentsComponent)components.method_58694(ModDataComponents.DRAWER_CONTENTS);
        if (component == null) {
            return;
        }
        for (int i = 0; i < component.slots().size(); ++i) {
            this.storages[i].readComponent(component.slots().get(i));
        }
    }

    protected void method_57567(class_9323.class_9324 componentMapBuilder) {
        if (this.isEmpty()) {
            return;
        }
        ArrayList<DrawerSlotComponent> slotComponents = new ArrayList<DrawerSlotComponent>();
        for (DrawerSlot storage : this.storages) {
            slotComponents.add(storage.toComponent());
        }
        componentMapBuilder.method_57840(ModDataComponents.DRAWER_CONTENTS, (Object)new DrawerContentsComponent(slotComponents));
    }

    @Override
    public Stream<? extends DrawerStorage> streamStorages() {
        return Arrays.stream(this.storages);
    }

    @Override
    public boolean isEmpty() {
        for (DrawerSlot storage : this.storages) {
            if (storage.getUpgrade() == null && storage.getLimiter() == Long.MAX_VALUE && storage.isResourceBlank() && !storage.isHidden() && !storage.isLocked() && !storage.isVoiding() && !storage.isDuping()) continue;
            return false;
        }
        return true;
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        List<class_2487> list = nbt.method_10554("items", 10).stream().map(class_2487.class::cast).toList();
        for (int i = 0; i < list.size(); ++i) {
            this.storages[i].readNbt(list.get(i), registryLookup);
        }
        this.sortSlots();
    }

    @Override
    public void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_2499 list = new class_2499();
        for (DrawerSlot storage : this.storages) {
            class_2487 storageNbt = new class_2487();
            storage.writeNbt(storageNbt, registryLookup);
            list.add((Object)storageNbt);
        }
        nbt.method_10566("items", (class_2520)list);
    }

    static {
        ItemStorage.SIDED.registerForBlockEntity((drawer, dir) -> drawer.combinedStorage, ModBlocks.DRAWER_BLOCK_ENTITY);
    }
}

