/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.misc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import immersive_aircraft.entity.inventory.VehicleInventoryDescription;
import immersive_aircraft.entity.inventory.slots.SlotDescription;
import immersive_aircraft.entity.misc.BoundingBoxDescriptor;
import immersive_aircraft.entity.misc.PositionDescriptor;
import immersive_aircraft.entity.misc.WeaponMount;
import immersive_aircraft.item.upgrade.VehicleStat;
import immersive_aircraft.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_9129;

public class VehicleData {
    private final Map<VehicleStat, Float> properties = new HashMap<VehicleStat, Float>();
    private final VehicleInventoryDescription inventoryDescription;
    private final Map<Integer, Map<WeaponMount.Type, List<WeaponMount>>> weaponMounts = new HashMap<Integer, Map<WeaponMount.Type, List<WeaponMount>>>();
    private final List<BoundingBoxDescriptor> boundingBoxes = new LinkedList<BoundingBoxDescriptor>();
    private final List<List<PositionDescriptor>> passengerPositions = new LinkedList<List<PositionDescriptor>>();

    public VehicleData() {
        this.inventoryDescription = new VehicleInventoryDescription();
    }

    public VehicleData(JsonObject json) {
        JsonObject propertyJson = json.getAsJsonObject("properties");
        VehicleStat.STATS.values().forEach(stat -> this.properties.put((VehicleStat)stat, Float.valueOf(Utils.getFloatElement(propertyJson, stat.name(), stat.defaultValue()))));
        this.inventoryDescription = new VehicleInventoryDescription(json.getAsJsonArray("inventorySlots"));
        this.populateWeaponMounts();
        ArrayList<SlotDescription> weaponSlots = new ArrayList<SlotDescription>(this.inventoryDescription.getSlots(VehicleInventoryDescription.WEAPON));
        json.getAsJsonArray("weaponMounts").forEach(weaponMountsJson -> {
            SlotDescription slot = (SlotDescription)weaponSlots.remove(0);
            weaponMountsJson.getAsJsonObject().entrySet().forEach(entry -> {
                WeaponMount.Type type = WeaponMount.Type.valueOf((String)entry.getKey());
                JsonArray mounts = ((JsonElement)entry.getValue()).getAsJsonArray();
                mounts.forEach(mountElement -> {
                    JsonObject mount = mountElement.getAsJsonObject();
                    PositionDescriptor position = PositionDescriptor.fromJson(mount);
                    boolean blocking = mount.has("blocking") && mount.get("blocking").getAsBoolean();
                    this.weaponMounts.get(slot.index()).get((Object)type).add(new WeaponMount(position.matrix(), blocking));
                });
            });
        });
        json.getAsJsonArray("passengerPositions").forEach(passengerPositionsSlotJson -> {
            LinkedList positions = new LinkedList();
            this.passengerPositions.add(positions);
            passengerPositionsSlotJson.getAsJsonArray().forEach(passengerPositionJson -> {
                PositionDescriptor position = PositionDescriptor.fromJson(passengerPositionJson.getAsJsonObject());
                positions.add(position);
            });
        });
        json.getAsJsonArray("boundingBoxes").forEach(e -> this.boundingBoxes.add(BoundingBoxDescriptor.fromJson(e.getAsJsonObject())));
    }

    public VehicleData(class_9129 byteBuf) {
        int propertiesCount = byteBuf.readInt();
        for (int i = 0; i < propertiesCount; ++i) {
            VehicleStat stat = VehicleStat.STATS.get(byteBuf.method_19772());
            this.properties.put(stat, Float.valueOf(byteBuf.readFloat()));
        }
        this.inventoryDescription = new VehicleInventoryDescription(byteBuf);
        this.populateWeaponMounts();
        int weaponMountsCount = byteBuf.readInt();
        for (int i = 0; i < weaponMountsCount; ++i) {
            int slot = byteBuf.readInt();
            int typeCount = byteBuf.readInt();
            for (int j = 0; j < typeCount; ++j) {
                WeaponMount.Type type = WeaponMount.Type.values()[byteBuf.readInt()];
                int mountCount = byteBuf.readInt();
                for (int k = 0; k < mountCount; ++k) {
                    this.weaponMounts.get(slot).get((Object)type).add(WeaponMount.decode(byteBuf));
                }
            }
        }
        int passengerPositionsCount = byteBuf.readInt();
        for (int i = 0; i < passengerPositionsCount; ++i) {
            int positionsCount = byteBuf.readInt();
            LinkedList<PositionDescriptor> positions = new LinkedList<PositionDescriptor>();
            this.passengerPositions.add(positions);
            for (int j = 0; j < positionsCount; ++j) {
                positions.add(PositionDescriptor.decode(byteBuf));
            }
        }
        int boundingBoxesCount = byteBuf.readInt();
        for (int i = 0; i < boundingBoxesCount; ++i) {
            this.boundingBoxes.add(BoundingBoxDescriptor.decode(byteBuf));
        }
    }

    private void populateWeaponMounts() {
        List<SlotDescription> weaponSlots = this.inventoryDescription.getSlots(VehicleInventoryDescription.WEAPON);
        weaponSlots.forEach(slot -> {
            for (WeaponMount.Type type : WeaponMount.Type.values()) {
                this.weaponMounts.computeIfAbsent(slot.index(), integer -> new HashMap()).put(type, new LinkedList());
            }
        });
    }

    public void encode(class_9129 buffer) {
        buffer.method_53002(this.properties.size());
        this.properties.forEach((stat, value) -> {
            buffer.method_10814(stat.name());
            buffer.method_52941(value.floatValue());
        });
        this.inventoryDescription.encode(buffer);
        buffer.method_53002(this.weaponMounts.size());
        this.weaponMounts.forEach((slot, mounts) -> {
            buffer.method_53002(slot.intValue());
            buffer.method_53002(mounts.size());
            mounts.forEach((type, mountList) -> {
                buffer.method_53002(type.ordinal());
                buffer.method_53002(mountList.size());
                mountList.forEach(mount -> mount.encode(buffer));
            });
        });
        buffer.method_53002(this.passengerPositions.size());
        this.passengerPositions.forEach(positions -> {
            buffer.method_53002(positions.size());
            positions.forEach(position -> position.encode(buffer));
        });
        buffer.method_53002(this.boundingBoxes.size());
        this.boundingBoxes.forEach(boundingBox -> boundingBox.encode(buffer));
    }

    public Map<VehicleStat, Float> getProperties() {
        return this.properties;
    }

    public VehicleInventoryDescription getInventoryDescription() {
        return this.inventoryDescription;
    }

    public Map<Integer, Map<WeaponMount.Type, List<WeaponMount>>> getWeaponMounts() {
        return this.weaponMounts;
    }

    public List<BoundingBoxDescriptor> getBoundingBoxes() {
        return this.boundingBoxes;
    }

    public List<List<PositionDescriptor>> getPassengerPositions() {
        return this.passengerPositions;
    }
}

