/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Items;
import immersive_aircraft.Main;
import immersive_aircraft.Sounds;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.AirshipEntity;
import immersive_aircraft.entity.misc.Trail;
import immersive_aircraft.entity.misc.WeaponMount;
import immersive_aircraft.entity.weapon.HeavyCrossbow;
import immersive_aircraft.resources.bbmodel.BBAnimationVariables;
import immersive_aircraft.util.InterpolatedFloat;
import immersive_aircraft.util.Utils;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class WarshipEntity
extends AirshipEntity {
    private final HeavyCrossbow turret;
    public final InterpolatedFloat turretYaw = new InterpolatedFloat(5.0f);
    public final InterpolatedFloat turretPitch = new InterpolatedFloat(5.0f);
    private final List<Trail> trails = List.of(new Trail(15, 0.25f), new Trail(15, 0.25f), new Trail(11, 0.25f), new Trail(11, 0.25f));

    public WarshipEntity(class_1299<? extends AircraftEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.turret = new HeavyCrossbow(this, new class_1799((class_1935)Items.HEAVY_CROSSBOW.get()), new WeaponMount(new Matrix4f(), false), -1, 5.0f, 0.0f);
    }

    @Override
    public class_1792 asItem() {
        return Items.WARSHIP.get();
    }

    @Override
    public List<Trail> getTrails() {
        return this.trails;
    }

    @Override
    protected void addTrails(Matrix4f transform) {
        Matrix4f tr = new Matrix4f((Matrix4fc)transform);
        tr.translate((Vector3fc)new Vector3f(0.0f, 1.4f, -2.75f));
        tr.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(this.engineRotation.getSmooth() * 40.0f));
        this.trail(tr, 0, 0.2f);
        tr = new Matrix4f((Matrix4fc)transform);
        tr.translate((Vector3fc)new Vector3f(2.5f, 4.5f, -5.5f));
        tr.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(this.engineRotation.getSmooth() * 40.0f));
        this.trail(tr, 1, 0.2f);
        tr = new Matrix4f((Matrix4fc)transform);
        tr.translate((Vector3fc)new Vector3f(0.0f, 4.5f, -5.5f));
        tr.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(this.engineRotation.getSmooth() * 40.0f));
        this.trail(tr, 2, 0.25f);
        tr = new Matrix4f((Matrix4fc)transform);
        tr.translate((Vector3fc)new Vector3f(-2.5f, 4.5f, -5.5f));
        tr.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(this.engineRotation.getSmooth() * 40.0f));
        this.trail(tr, 3, 0.2f);
    }

    @Override
    public void setAnimationVariables(float tickDelta) {
        super.setAnimationVariables(tickDelta);
        BBAnimationVariables.set("turret_yaw", -this.turretYaw.getSmooth(tickDelta));
        BBAnimationVariables.set("turret_pitch", -this.turretPitch.getSmooth(tickDelta));
        if (this.weapons.isEmpty()) {
            BBAnimationVariables.set("balloon_roll", (float)Utils.cosNoise(((float)this.field_6012 + tickDelta) * 0.01f) * 0.2f + this.getRoll(tickDelta) * 0.5f);
            BBAnimationVariables.set("balloon_pitch", (float)Utils.cosNoise(77.0f + ((float)this.field_6012 + tickDelta) * 0.02f) * 0.2f);
        } else {
            BBAnimationVariables.set("balloon_roll", 0.0f);
            BBAnimationVariables.set("balloon_pitch", 0.0f);
        }
        BBAnimationVariables.set("chest", (float)Math.max((double)0.0, (double)this.getSpeedVector().field_1351));
        BBAnimationVariables.set("turret_cooldown", this.turret.getCooldown());
    }

    @Override
    protected float getEngineReactionSpeed() {
        return 100.0f;
    }

    @Override
    protected class_3414 getEngineSound() {
        return Sounds.WARSHIP.get();
    }

    @Override
    protected class_3414 getEngineStartSound() {
        return Sounds.ENGINE_START_WARSHIP.get();
    }

    public Vector3f boneOffset(Vector3f position, Vector3f rotation, Vector3f origin) {
        position.sub((Vector3fc)origin);
        position = Utils.fromXYZ(rotation).transform(position);
        position.add((Vector3fc)origin);
        return position;
    }

    public class_1297 getTurretGunner() {
        List passengers = this.method_5685();
        if (passengers.size() >= 2) {
            return (class_1297)passengers.get(1);
        }
        return null;
    }

    public boolean isTurretGunner(class_1297 entity) {
        return this.getTurretGunner() == entity;
    }

    @Override
    public void method_5865(@NotNull class_1297 passenger, @NotNull class_1297.class_4738 positionUpdater) {
        Matrix4f transform = this.getVehicleTransform();
        if (this.isTurretGunner(passenger)) {
            Vector3f position = this.getGunnerPosition();
            float x = position.x();
            float y = position.y();
            float z = position.z();
            class_243 attachmentPoint = passenger.method_55668((class_1297)this);
            Vector4f worldPosition = this.transformPosition(transform, x += (float)attachmentPoint.field_1352, y += (float)attachmentPoint.field_1351, z += (float)attachmentPoint.field_1350);
            positionUpdater.accept(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            this.copyEntityData(passenger);
        } else {
            super.method_5865(passenger, positionUpdater);
        }
    }

    private Vector3f getGunnerPosition() {
        float pitch = this.turretPitch.getSmooth(1.0f) / 180.0f * (float)java.lang.Math.PI;
        float yaw = this.turretYaw.getSmooth(1.0f) / 180.0f * (float)java.lang.Math.PI;
        Vector3f position = new Vector3f(0.0f, 0.5f, 2.5f);
        this.boneOffset(position, new Vector3f(0.0f, -yaw, 0.0f), new Vector3f(0.0f, 0.5f, 2.0f));
        this.boneOffset(position, new Vector3f(pitch, 0.0f, 0.0f), new Vector3f(0.0f, 0.5f, 0.9f));
        return position;
    }

    @Override
    public void copyEntityData(class_1297 entity) {
        if (this.isTurretGunner(entity)) {
            entity.method_5636(this.method_36454() + this.turretYaw.getSmooth(1.0f));
            float py = class_3532.method_15393((float)(entity.method_36454() - this.method_36454()));
            float cpy = class_3532.method_15363((float)py, (float)-45.0f, (float)45.0f);
            entity.field_5982 += cpy - py;
            entity.method_36456(entity.method_36454() + cpy - py);
            entity.method_5847(entity.method_36454());
            float pp = class_3532.method_15393((float)(entity.method_36455() - this.method_36455()));
            float cpp = class_3532.method_15363((float)pp, (float)-30.0f, (float)30.0f);
            entity.field_6004 += cpp - pp;
            entity.method_36457(entity.method_36455() + cpp - pp);
        } else {
            super.copyEntityData(entity);
        }
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.turret.tick();
        class_1297 gunner = this.getTurretGunner();
        if (gunner != null) {
            this.turretYaw.update(Math.clamp((float)-75.0f, (float)75.0f, (float)class_3532.method_15393((float)(gunner.method_5791() - this.method_36454()))));
            this.turretPitch.update(Math.clamp((float)-30.0f, (float)30.0f, (float)gunner.method_36455()));
        } else {
            this.turretYaw.update(0.0f);
            this.turretPitch.update(0.0f);
        }
        Vector3f gunnerPosition = this.getGunnerPosition();
        Quaternionf turretRot = Utils.fromXYZ(Math.toRadians((float)this.turretPitch.get(1.0f)), Math.toRadians((float)(-this.turretYaw.get(1.0f))), 0.0f);
        this.turret.getMount().transform().identity().translate((Vector3fc)gunnerPosition).rotate((Quaternionfc)turretRot);
    }

    @Override
    public void clientFireWeapons(class_1297 entity) {
        if (this.isTurretGunner(entity)) {
            this.turret.clientFire(-1);
        } else {
            super.clientFireWeapons(entity);
        }
    }

    @Override
    public void fireWeapon(int slot, int index, Vector3f direction) {
        if (slot == -1) {
            this.turret.fire(direction);
        } else {
            super.fireWeapon(slot, index, direction);
        }
    }

    @Override
    public double getZoom() {
        return 5.0f + this.enginePower.getSmooth(Main.frameTime) * 5.0f;
    }
}

