/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.structure.jigsaw.element;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.module.StructurePoolElementTypeModule;
import com.yungnickyoung.minecraft.yungsapi.world.structure.condition.StructureCondition;
import com.yungnickyoung.minecraft.yungsapi.world.structure.jigsaw.element.YungJigsawPoolElement;
import com.yungnickyoung.minecraft.yungsapi.world.structure.modifier.StructureModifier;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.EnhancedTerrainAdaptation;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_156;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2776;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3785;
import net.minecraft.class_3793;
import net.minecraft.class_3794;
import net.minecraft.class_3816;
import net.minecraft.class_3828;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5497;
import net.minecraft.class_5819;
import net.minecraft.class_6328;
import net.minecraft.class_6880;
import net.minecraft.class_9822;

@ParametersAreNonnullByDefault
@class_6328
public class YungJigsawSinglePoolElement
extends YungJigsawPoolElement {
    private static final Codec<Either<class_2960, class_3499>> TEMPLATE_CODEC = Codec.of(YungJigsawSinglePoolElement::encodeTemplate, (Decoder)class_2960.field_25139.map(Either::left));
    public static final MapCodec<YungJigsawSinglePoolElement> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group(YungJigsawSinglePoolElement.templateCodec(), YungJigsawSinglePoolElement.processorsCodec(), (App)YungJigsawSinglePoolElement.method_28883(), YungJigsawSinglePoolElement.overrideLiquidSettingsCodec(), YungJigsawSinglePoolElement.nameCodec(), YungJigsawSinglePoolElement.maxCountCodec(), YungJigsawSinglePoolElement.minRequiredDepthCodec(), YungJigsawSinglePoolElement.maxPossibleDepthCodec(), YungJigsawSinglePoolElement.isPriorityCodec(), YungJigsawSinglePoolElement.ignoreBoundsCodec(), YungJigsawSinglePoolElement.conditionCodec(), YungJigsawSinglePoolElement.enhancedTerrainAdaptationCodec(), (App)class_2960.field_25139.optionalFieldOf("deadend_pool").forGetter(element -> element.deadendPool), (App)StructureModifier.CODEC.listOf().optionalFieldOf("modifiers", new ArrayList()).forGetter(element -> element.modifiers)).apply((Applicative)builder, YungJigsawSinglePoolElement::new));
    public final Either<class_2960, class_3499> template;
    public final class_6880<class_5497> processors;
    public final Optional<class_9822> overrideLiquidSettings;
    public final Optional<class_2960> deadendPool;
    public final List<StructureModifier> modifiers;

    public YungJigsawSinglePoolElement(Either<class_2960, class_3499> template, class_6880<class_5497> processors, class_3785.class_3786 projection, Optional<class_9822> overrideLiquidSettings, Optional<String> name, Optional<Integer> maxCount, Optional<Integer> minRequiredDepth, Optional<Integer> maxPossibleDepth, boolean isPriority, boolean ignoreBounds, StructureCondition condition, Optional<EnhancedTerrainAdaptation> enhancedTerrainAdaptation, Optional<class_2960> deadendPool, List<StructureModifier> modifiers) {
        super(projection, name, maxCount, minRequiredDepth, maxPossibleDepth, isPriority, ignoreBounds, condition, enhancedTerrainAdaptation);
        this.template = template;
        this.processors = processors;
        this.overrideLiquidSettings = overrideLiquidSettings;
        this.deadendPool = deadendPool;
        this.modifiers = modifiers;
    }

    public class_2382 method_16601(class_3485 structureTemplateManager, class_2470 rotation) {
        class_3499 structureTemplate = this.getTemplate(structureTemplateManager);
        return structureTemplate.method_15166(rotation);
    }

    public List<class_3499.class_3501> method_16627(class_3485 structureTemplateManager, class_2338 blockPos, class_2470 rotation, class_5819 randomSource) {
        class_3499 structureTemplate = this.getTemplate(structureTemplateManager);
        ObjectArrayList jigsawBlocks = structureTemplate.method_15165(blockPos, new class_3492().method_15123(rotation), class_2246.field_16540, true);
        class_156.method_43028((List)jigsawBlocks, (class_5819)randomSource);
        return jigsawBlocks;
    }

    public class_3341 method_16628(class_3485 structureTemplateManager, class_2338 blockPos, class_2470 rotation) {
        class_3499 structureTemplate = this.getTemplate(structureTemplateManager);
        return structureTemplate.method_16187(new class_3492().method_15123(rotation), blockPos);
    }

    public boolean method_16626(class_3485 structureTemplateManager, class_5281 worldGenLevel, class_5138 structureManager, class_2794 chunkGenerator, class_2338 pos, class_2338 pivotPos, class_2470 rotation, class_3341 boundingBox, class_5819 randomSource, class_9822 liquidSettings, boolean replaceJigsaws) {
        class_3492 structurePlaceSettings;
        class_3499 structureTemplate = this.getTemplate(structureTemplateManager);
        if (!structureTemplate.method_15172((class_5425)worldGenLevel, pos, pivotPos, structurePlaceSettings = this.getSettings(rotation, boundingBox, liquidSettings, replaceJigsaws), randomSource, 18)) {
            return false;
        }
        for (class_3499.class_3501 structureBlockInfo : class_3499.method_16446((class_5425)worldGenLevel, (class_2338)pos, (class_2338)pivotPos, (class_3492)structurePlaceSettings, this.getDataMarkers(structureTemplateManager, pos, rotation, false))) {
            this.method_16756((class_1936)worldGenLevel, structureBlockInfo, pos, rotation, randomSource, boundingBox);
        }
        return true;
    }

    public Optional<class_2960> getDeadendPool() {
        return this.deadendPool;
    }

    public boolean hasModifiers() {
        return !this.modifiers.isEmpty();
    }

    public class_3499 getTemplate(class_3485 structureTemplateManager) {
        return (class_3499)this.template.map(arg_0 -> ((class_3485)structureTemplateManager).method_15091(arg_0), Function.identity());
    }

    public class_3816<?> method_16757() {
        return StructurePoolElementTypeModule.YUNG_SINGLE_ELEMENT;
    }

    public String toString() {
        return String.format("YungJigsawSingle[%s][%s][%s][%s]", this.name.orElse("<unnamed>"), this.template, this.maxCount.isPresent() ? this.maxCount.get() : "no max count", this.isPriority);
    }

    private class_3492 getSettings(class_2470 rotation, class_3341 boundingBox, class_9822 liquidSettings, boolean replaceJigsaws) {
        class_3492 structurePlaceSettings = new class_3492();
        structurePlaceSettings.method_15126(boundingBox);
        structurePlaceSettings.method_15123(rotation);
        structurePlaceSettings.method_15131(true);
        structurePlaceSettings.method_15133(false);
        structurePlaceSettings.method_16184((class_3491)class_3793.field_16718);
        structurePlaceSettings.method_27264(true);
        structurePlaceSettings.method_61020(this.overrideLiquidSettings.orElse(liquidSettings));
        if (!replaceJigsaws) {
            structurePlaceSettings.method_16184((class_3491)class_3794.field_16871);
        }
        ((class_5497)this.processors.comp_349()).method_31027().forEach(arg_0 -> ((class_3492)structurePlaceSettings).method_16184(arg_0));
        this.method_16624().method_16636().forEach(arg_0 -> ((class_3492)structurePlaceSettings).method_16184(arg_0));
        return structurePlaceSettings;
    }

    private List<class_3499.class_3501> getDataMarkers(class_3485 structureTemplateManager, class_2338 blockPos, class_2470 rotation, boolean isPositionLocal) {
        class_3499 structureTemplate = this.getTemplate(structureTemplateManager);
        ObjectArrayList structureBlocks = structureTemplate.method_15165(blockPos, new class_3492().method_15123(rotation), class_2246.field_10465, isPositionLocal);
        ArrayList dataBlocks = Lists.newArrayList();
        for (class_3499.class_3501 block : structureBlocks) {
            class_2776 structureMode = class_2776.valueOf((String)block.comp_1343().method_10558("mode"));
            if (structureMode != class_2776.field_12696) continue;
            dataBlocks.add(block);
        }
        return dataBlocks;
    }

    public static <E extends YungJigsawSinglePoolElement> RecordCodecBuilder<E, class_6880<class_5497>> processorsCodec() {
        return class_3828.field_25877.fieldOf("processors").forGetter(element -> element.processors);
    }

    public static <E extends YungJigsawSinglePoolElement> RecordCodecBuilder<E, Either<class_2960, class_3499>> templateCodec() {
        return TEMPLATE_CODEC.fieldOf("location").forGetter(element -> element.template);
    }

    public static <E extends YungJigsawSinglePoolElement> RecordCodecBuilder<E, Optional<class_9822>> overrideLiquidSettingsCodec() {
        return class_9822.field_52239.optionalFieldOf("override_liquid_settings").forGetter(element -> element.overrideLiquidSettings);
    }

    private static <T> DataResult<T> encodeTemplate(Either<class_2960, class_3499> either, DynamicOps<T> ops, T template) {
        Optional optional = either.left();
        return !optional.isPresent() ? DataResult.error(() -> "Can not serialize a runtime pool element") : class_2960.field_25139.encode((Object)((class_2960)optional.get()), ops, template);
    }
}

